<?php
namespace NourElementorAddons\Inc;
use NourElementorAddons\Libs\Nour_Elementor_Dashboard;
use NourElementorAddonsPro\Inc\Nour_Elementor_Widget_Pro_List;
use NourElementorAddonsPro\Libs\Nour_Elementor_License;
defined('ABSPATH') || exit;
class Nour_Elementor_Widget_List {
    private static $instance = null;
    private static $list = [
        'heading' => [
            'slug' => 'heading',
            'title' => 'تیتر حرفه ای',
            'package' => 'free',
        ],
        'image-gallery' => [
            'slug' => 'image_gallery',
            'title' => 'گالری تصاویر',
            'package' => 'free',
        ],
        'pricing' => [
            'slug' => 'pricing',
            'title' => 'ستون قیمت',
            'package' => 'free',
        ],
        'progress-bar' => [
            'slug' => 'progress_bar',
            'title' => 'نوار پیشرفت',
            'package' => 'free',
        ],
        'pie-chart' => [
            'slug' => 'pie_chart',
            'title' => 'شمارنده دایره ای',
            'package' => 'free',
        ],
        'counter' => [
            'slug' => 'counter',
            'title' => 'شمارنده',
            'package' => 'free',
        ],
        'team' => [
            'slug' => 'team',
            'title' => 'اعضای تیم',
            'package' => 'free',
        ],
        'before-after' => [
            'slug' => 'before_after',
            'title' => 'نمایش قبل و بعد',
            'package' => 'free',
        ],
        'logo-grid' => [
            'slug' => 'logo_grid',
            'title' => 'شبکه لوگو',
            'package' => 'free',
        ],
        'content-toggle' => [
            'slug' => 'content_toggle',
            'title' => 'محتوای آکاردئونی',
            'package' => 'free',
        ],
        'news-ticker' => [
            'slug' => 'news_ticker',
            'title' => 'سرخط خبرها',
            'package' => 'free',
        ],
        'step-flow' => [
            'slug' => 'step_flow',
            'title' => 'مراحل توسعه',
            'package' => 'free',
        ],
        'table' => [
            'slug' => 'table',
            'title' => 'جدول حرفه ای',
            'package' => 'free',
        ],
        'post-grid' => [
            'slug' => 'post_grid',
            'title' => 'شبکه نوشته ها',
            'package' => 'free',
        ],
        'hot-spot' => [
            'slug' => 'hot_spot',
            'title' => 'نقاط روی تصویر',
            'package' => 'free',
        ],
        'block-quote' => [
            'slug' => 'block_quote',
            'title' => 'نقل قول',
            'package' => 'free',
        ],
        'image-scroller' => [
            'slug' => 'image_scroller',
            'title' => 'اسکرول تصویر',
            'package' => 'free',
        ],
        'business-hours' => [
            'slug' => 'business_hours',
            'title' => 'ساعات کاری',
            'package' => 'free',
        ],
        'horizontal-timeline' => [
            'slug' => 'horizontal_timeline',
            'title' => 'نوار زمان افقی',
            'package' => 'free',
        ],
        'woo-product-grid' => [
            'slug' => 'woo_product_grid',
            'title' => 'شبکه محصولات',
            'package' => 'free',
        ],
        'animated-link' => [
            'slug' => 'animated_link',
            'title' => 'پیوند ویژه',
            'package' => 'free',
        ],
    ];
    public function is_active($widget) {
        $act = self::instance()->get_list(true, $widget, 'active');
        return empty($act['package']) ? false : (($act['package'] === 'free' || $act['package'] === 'pro-disabled'));
    }
    public function get_list($filtered = true, $widget = '', $check_method = 'list') {
        $all_list = self::$list;

        if ($filtered === true) {
            $all_list = apply_filters('nour_elementor_addons_widgets_list', self::$list);
        }
        if (did_action('nour_elementor_addons_pro_loaded') && 
            class_exists('\NourElementorAddonsPro\Libs\Nour_Elementor_License') && 
            Nour_Elementor_License::$license_activate === 'valid') {
            $widget_pro = Nour_Elementor_Widget_Pro_List::instance()->get_list();
            $all_list = array_merge($all_list, $widget_pro);
        }
        if ($check_method === 'active') {
            $active_list = Nour_Elementor_Dashboard::instance()->utils->get_option('nour_elementor_widget_list', array_keys($all_list));

            foreach ($all_list as $widget_slug => $info) {
                if (is_array($active_list) && !in_array($widget_slug, $active_list, true)) {
                    unset($all_list[$widget_slug]);
                }
            }
        }
        if ($widget !== '') {
            return isset($all_list[$widget]) ? $all_list[$widget] : false;
        }

        return $all_list;
    }
    public static function instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }
}