<?php
namespace NourElementorAddons\Inc;
use NourElementorAddons\Libs\Nour_Elementor_Dashboard;
use NourElementorAddonsPro\Inc\Nour_Elementor_Module_Pro_List;
use NourElementorAddonsPro\Libs\Nour_Elementor_License;
defined( 'ABSPATH' ) || exit;
class Nour_Elementor_Module_List {
	private static $instance = null;
	private static $list     = array(
		'nour-icons'           => array(
			'slug'    => 'nour_elementor_icons',
			'title'   => 'نمادهای قالب',
			'package' => 'free',
		),
		'floating-effect'      => array(
			'slug'    => 'floating_effect',
			'title'   => 'جلوه حرکتی',
			'package' => 'free',
		),
		'entrance-animation'   => array(
			'slug'    => 'entrance_animation',
			'title'   => 'انیمیشن ها',
			'package' => 'free',
		),		
		'post-duplicator'      => array(
			'slug'    => 'post_duplicator',
			'title'   => 'تکثیرکننده',
			'package' => 'free',
		),
		'wrapper-link'         => array(
			'slug'    => 'wrapper_link',
			'title'   => 'پیوند کردن جعبه',
			'package' => 'free',
		),
	);
	public function get_list( $filtered = true, $module = '', $check_mathod = 'list' ) {
		$all_list = self::$list;
		if ( true === $filtered ) {
			$all_list = apply_filters( 'nour_elementor_addons_modules_list', self::$list );
		}
		if ( did_action( 'nour_elementor_addons_pro_loaded' ) && class_exists( '\NourElementorAddonsPro\Libs\Nour_Elementor_License' ) && 'valid' === Nour_Elementor_License::$license_activate ) {
			$module_pro = Nour_Elementor_Module_Pro_List::instance()->get_list();
			$all_list   = array_merge( $all_list, $module_pro );
		}
		if ( 'active' === $check_mathod ) {
			$active_list = Nour_Elementor_Dashboard::instance()->utils->get_option(
				'nour_elementor_module_list',
				array_keys( $all_list )
			);
			foreach ( $all_list as $widget_slug => $info ) {
				if ( ! in_array( $widget_slug, $active_list, true ) ) {
					unset( $all_list[ $widget_slug ] );
				}
			}
		}
		if ( '' !== $module ) {
			return ( ! isset( $all_list[ $module ] ) ? false : $all_list[ $module ] );
		}
		return $all_list;
	}
	public function is_active( $module_slug ) {

		$act = self::instance()->get_list( true, $module_slug, 'active' );

		return empty( $act['package'] ) ? false : ( ( 'free' === $act['package'] || 'pro-disabled' === $act['package'] ) );
	}
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}