<?php
namespace NourElementorAddons\Control;
use Elementor\Base_Data_Control;
defined( 'ABSPATH' ) || exit;
class Nour_Elementor_Widget_Area extends Base_Data_Control {
	const TYPE = 'widgetarea';
	public function get_type() {
		return self::TYPE;
	}
	public function enqueue() {
		wp_enqueue_style( 'nour-widgetarea-inspector', NOUR_ELEMENTOR_ADDONS_DIR_URL . 'inc/controls/assets/css/widgetarea-inspector.css', array(), NOUR_ELEMENTOR_ADDONS_VERSION );
		wp_enqueue_script( 'nour-widgetarea-inspector', NOUR_ELEMENTOR_ADDONS_DIR_URL . 'inc/controls/assets/js/widgetarea-inspector.js', null, NOUR_ELEMENTOR_ADDONS_VERSION, true );
	}
	public function content_template() {
		$control_uid = $this->get_control_uid();
		?>
		<div style="display:none" class="elementor-control-field">
			<label for="<?php echo esc_attr( $control_uid ); ?>" class="elementor-control-title">{{{ data.label
				}}}</label>
			<div class="elementor-control-input-wrapper">
				<input id="<?php echo esc_attr( $control_uid ); ?>" type="text" data-setting="{{ data.name }}"/>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{{ data.description }}}</div>
		<# } #>
		<?php
	}
	protected function get_default_settings() {
		return array(
			'label_block'      => true,
			'show_edit_button' => false,
		);
	}
}