<?php
namespace NourElementorAddons\Control;
use Elementor\Base_Data_Control;
class Nour_Elementor_Select extends Base_Data_Control {
	const TYPE = 'nour-select';
	public function get_type() {
		return self::TYPE;
	}
	public function enqueue() {
		wp_enqueue_script(
			'nour-select',
			NOUR_ELEMENTOR_ADDONS_DIR_URL . 'inc/controls/assets/js/nour-select.js',
			array( 'jquery-elementor-select2' ),
			NOUR_ELEMENTOR_ADDONS_VERSION,
			true
		);
		wp_localize_script(
			'nour-select',
			'nour_elementor_select_localize',
			array(
				'ajaxurl'     => admin_url( 'admin-ajax.php' ),
				'search_text' => esc_html__( 'جستجو', 'nour-elementor-addons' ),
				'nonce'       => wp_create_nonce( 'nour-select-nonce' ),
			)
		);
	}
	public function content_template() {
		$control_uid = $this->get_control_uid();
		?>
		<# var controlUID = '<?php echo esc_attr( $control_uid ); ?>'; #>
		<# var currentID = elementor.panel.currentView.currentPageView.model.attributes.settings.attributes[data.name]; #>
		<div class="elementor-control-field">
			<# if ( data.label ) { #>
			<label for="<?php echo esc_attr( $control_uid ); ?>" class="elementor-control-title">{{{data.label
				}}}</label>
			<# } #>
			<div class="elementor-control-input-wrapper elementor-control-unit-5">
				<# var multiple = ( data.multiple ) ? 'multiple' : ''; #>
				<select id="<?php echo esc_attr( $control_uid ); ?>" {{ multiple }} class="nour-select"
						data-setting="{{ data.name }}"></select>
			</div>
		</div>
		<#
		( function( $ ) {
		$( document.body ).trigger( 'nour_elementor_select_init',{currentID:data.controlValue,data:data,controlUID:controlUID,multiple:data.multiple} );
		}( jQuery ) );
		#>
		<?php
	}
	protected function get_default_settings() {
		return array(
			'multiple'    => false,
			'source_name' => 'post_type',
			'source_type' => 'post',
		);
	}
}