<?php
namespace NourElementorAddons\Control;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Base;
defined( 'ABSPATH' ) || die();
class Nour_Elementor_Group_Control_Foreground extends Group_Control_Base {
	protected static $fields;
	public static function get_type() {
		return 'foreground';
	}
	public function init_fields() {
		$fields = array();

		$fields['color_type'] = array(
			'label'       => _x( 'نوع رنگ', 'Background Control', 'nour-elementor-addons' ),
			'type'        => Controls_Manager::CHOOSE,
			'label_block' => false,
			'render_type' => 'ui',
			'options'     => array(
				'classic'  => array(
					'title' => _x( 'کلاسیک', 'Text Color Control', 'nour-elementor-addons' ),
					'icon'  => 'eicon-paint-brush',
				),
				'gradient' => array(
					'title' => _x( 'گرادیانت', 'Text Color Control', 'nour-elementor-addons' ),
					'icon'  => 'eicon-barcode',
				),
			)
		);
		$fields['color'] = array(
			'label'     => _x( 'Color', 'Background Control', 'nour-elementor-addons' ),
			'type'      => Controls_Manager::COLOR,
			'default'   => '',
			'title'     => _x( 'رنگ', 'Background Control', 'nour-elementor-addons' ),
			'selectors' => array(
				'{{SELECTOR}}' => 'color: {{VALUE}};',
			),
			'condition' => array(
				'color_type' => array( 'classic', 'gradient' ),
			)
		);
		$fields['color_stop'] = array(
			'label'       => _x( 'موقعیت', 'Background Control', 'nour-elementor-addons' ),
			'type'        => Controls_Manager::SLIDER,
			'size_units'  => array( '%' ),
			'default'     => array(
				'unit' => '%',
				'size' => 0,
			),
			'render_type' => 'ui',
			'condition'   => array(
				'color_type' => array( 'gradient' ),
			),
			'of_type'     => 'gradient',
		);
		$fields['color_b'] = array(
			'label'       => _x( 'رنگ دوم', 'Background Control', 'nour-elementor-addons' ),
			'type'        => Controls_Manager::COLOR,
			'default'     => '#f2295b',
			'render_type' => 'ui',
			'condition'   => array(
				'color_type' => array( 'gradient' ),
			),
			'of_type'     => 'gradient',
		);
		$fields['color_b_stop'] = array(
			'label'       => _x( 'موقعیت', 'Background Control', 'nour-elementor-addons' ),
			'type'        => Controls_Manager::SLIDER,
			'size_units'  => array( '%' ),
			'default'     => array(
				'unit' => '%',
				'size' => 100,
			),
			'render_type' => 'ui',
			'condition'   => array(
				'color_type' => array( 'gradient' ),
			),
			'of_type'     => 'gradient',
		);
		$fields['gradient_type'] = array(
			'label'       => _x( 'نوع', 'Background Control', 'nour-elementor-addons' ),
			'type'        => Controls_Manager::SELECT,
			'options'     => array(
				'linear' => _x( 'خطی', 'Background Control', 'nour-elementor-addons' ),
				'radial' => _x( 'حلقه ای', 'Background Control', 'nour-elementor-addons' ),
			),
			'default'     => 'linear',
			'render_type' => 'ui',
			'condition'   => array(
				'color_type' => array( 'gradient' ),
			),
			'of_type'     => 'gradient',
		);
		$fields['gradient_angle'] = array(
			'label'      => _x( 'زاویه', 'Background Control', 'nour-elementor-addons' ),
			'type'       => Controls_Manager::SLIDER,
			'size_units' => array( 'deg' ),
			'default'    => array(
				'unit' => 'deg',
				'size' => 180,
			),
			'range'      => array(
				'deg' => array(
					'step' => 10,
				),
			),
			'selectors'  => array(
				'{{SELECTOR}}' => '-webkit-background-clip: text; -webkit-text-fill-color: transparent; background-color: transparent; background-image: linear-gradient({{SIZE}}{{UNIT}}, {{color.VALUE}} {{color_stop.SIZE}}{{color_stop.UNIT}}, {{color_b.VALUE}} {{color_b_stop.SIZE}}{{color_b_stop.UNIT}})',
			),
			'condition'  => array(
				'color_type'    => array( 'gradient' ),
				'gradient_type' => 'linear',
			),
			'of_type'    => 'gradient',
		);
		$fields['gradient_position'] = array(
			'label'     => _x( 'موقعیت', 'Background Control', 'nour-elementor-addons' ),
			'type'      => Controls_Manager::SELECT,
			'options'   => array(
				'center center' => _x( 'وسط وسط', 'Background Control', 'nour-elementor-addons' ),
				'center left'   => _x( 'وسط چپ', 'Background Control', 'nour-elementor-addons' ),
				'center right'  => _x( 'وسط راست', 'Background Control', 'nour-elementor-addons' ),
				'top center'    => _x( 'بالا وسط', 'Background Control', 'nour-elementor-addons' ),
				'top left'      => _x( 'بالا چپ', 'Background Control', 'nour-elementor-addons' ),
				'top right'     => _x( 'بالا راست', 'Background Control', 'nour-elementor-addons' ),
				'bottom center' => _x( 'پایین وسط', 'Background Control', 'nour-elementor-addons' ),
				'bottom left'   => _x( 'پایین چپ', 'Background Control', 'nour-elementor-addons' ),
				'bottom right'  => _x( 'پایین راست', 'Background Control', 'nour-elementor-addons' ),
			),
			'default'   => 'center center',
			'selectors' => array(
				'{{SELECTOR}}' => '-webkit-background-clip: text; -webkit-text-fill-color: transparent; background-color: transparent; background-image: radial-gradient(at {{VALUE}}, {{color.VALUE}} {{color_stop.SIZE}}{{color_stop.UNIT}}, {{color_b.VALUE}} {{color_b_stop.SIZE}}{{color_b_stop.UNIT}})',
			),
			'condition' => array(
				'color_type'    => array( 'gradient' ),
				'gradient_type' => 'radial',
			),
			'of_type'   => 'gradient',
		);
		return $fields;
	}
	protected function get_child_default_args() {
		return array(
			'types' => array( 'classic', 'gradient' )
		);
	}
	protected function filter_fields() {
		$fields = parent::filter_fields();

		$args = $this->get_args();

		foreach ( $fields as &$field ) {
			if ( isset( $field['of_type'] ) && ! in_array( $field['of_type'], $args['types'], true ) ) {
				unset( $field );
			}
		}

		return $fields;
	}
	protected function get_default_options() {
		return array(
			'popover' => false,
		);
	}
}