<?php
/*
Plugin Name: Elementor Widgets
Description: Widgets for Elementor
Version: 1.4.4
Author: Rtl Theme
Author URI: https://www.rtl-theme.com
Text Domain: noorgfx-component
Domain Path: /languages/
*/
defined( 'ABSPATH' ) || die();
define( 'NOUR_ELEMENTOR_ADDONS_VERSION', '1.4.4' );
define( 'NOUR_ELEMENTOR_ADDONS__FILE__', __FILE__ );
define( 'NOUR_ELEMENTOR_ADDONS_BASE', plugin_basename( __FILE__ ) );
define( 'NOUR_ELEMENTOR_ADDONS_DIR_PATH', plugin_dir_path( NOUR_ELEMENTOR_ADDONS__FILE__ ) );
define( 'NOUR_ELEMENTOR_ADDONS_DIR_URL', plugin_dir_url( NOUR_ELEMENTOR_ADDONS__FILE__ ) );
define( 'NOUR_ELEMENTOR_ADDONS_ASSETS', trailingslashit( NOUR_ELEMENTOR_ADDONS_DIR_URL . 'assets' ) );
define( 'NOUR_ELEMENTOR_ADDONS_WIDGET', trailingslashit( NOUR_ELEMENTOR_ADDONS_DIR_PATH . 'widgets' ) );
$upload_dir                         = wp_upload_dir();
$nour_elementor_addons_temp         = $upload_dir['basedir'] . '/nour-elementor-addons-temp/';
$nour_elementor_addons_temp_zip     = $upload_dir['basedir'] . '/nour-elementor-addons-temp-zip/';
$nour_elementor_addons_temp_uploads = $nour_elementor_addons_temp . '/uploads/';
define( 'NOUR_ELEMENTOR_ADDONS_TEMP', $nour_elementor_addons_temp );
define( 'NOUR_ELEMENTOR_ADDONS_TEMP_ZIP', $nour_elementor_addons_temp_zip );
define( 'NOUR_ELEMENTOR_ADDONS_TEMP_UPLOADS', $nour_elementor_addons_temp_uploads );
final class Nour_Elementor_Addons {
	const PAGE_SLUG = 'nour-elementor-addons';
	const LICENSE_PAGE_SLUG = 'nour-elementor-addons-license';
	const VERSION = '1.4.4';
	const MINIMUM_ELEMENTOR_VERSION = '3.0.0';
	const MINIMUM_PHP_VERSION = '7.0';
	public function __construct() {
		add_action( 'init', array( $this, 'i18n' ) );
		add_action( 'plugins_loaded', array( $this, 'init' ) );
		do_action( 'nour_elementor_addons_loaded' );

	}
	public function i18n() {
		load_plugin_textdomain(
			'nour-elementor-addons',
			false,
			dirname( plugin_basename( NOUR_ELEMENTOR_ADDONS__FILE__ ) ) . '/language/'
		);
	}
	public function init() {
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_missing_main_plugin' ) );
		}
		if ( did_action( 'elementor/loaded' ) && ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_elementor_version' ) );
			return;
		}
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_php_version' ) );
			return;
		}
		require_once plugin_dir_path( __FILE__ ) . 'base.php';
	}
	public function admin_notice_missing_main_plugin() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
		$screen = get_current_screen();
		if ( 'plugins' === $screen->base ) {
			if ( file_exists( WP_PLUGIN_DIR . '/elementor/elementor.php' ) ) {
				$message = sprintf(
					esc_html__( '"%1$s" لازمه "%2$s" فعال باشه. %3$s', 'nour-elementor-addons' ),
					'<strong>' . esc_html__( 'برای اجرای ابزارک های قالب', 'nour-elementor-addons' ) . '</strong>',
					'<strong>' . esc_html__( 'المنتور', 'nour-elementor-addons' ) . '</strong>',
					'<p><a href="' . wp_nonce_url( 'plugins.php?action=activate&plugin=elementor/elementor.php', 'activate-plugin_elementor/elementor.php' ) . '" class="button-primary">' . esc_html__( 'فعالسازی المنتور', 'nour-elementor-addons' ) . '</a></p>'
				);
			} else {
				$message = sprintf(
					esc_html__( '"%1$s" لازمه "%2$s" نصب باشه %3$s', 'nour-elementor-addons' ),
					'<strong>' . esc_html__( 'برای اجرای ابزارک های قالب', 'nour-elementor-addons' ) . '</strong>',
					'<strong>' . esc_html__( 'المنتور', 'nour-elementor-addons' ) . '</strong>',
					'<p><a href="' . wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' ) . '" class="button-primary">' . esc_html__( 'نصب المنتور', 'nour-elementor-addons' ) . '</a></p>'
				);
			}
			printf( '<div class="notice notice-warning"><p>%1$s</p></div>', $message ); 
		}
	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
		$message = sprintf(
			esc_html__( '"%1$s" نیاز داره به "%2$s" نسخه %3$s به بالا.', 'nour-elementor-addons' ),
			'<strong>' . esc_html__( 'ابزارک های قالب', 'nour-elementor-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'المنتور', 'nour-elementor-addons' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);
		printf( '<div class="notice notice-warning"><p>%1$s</p></div>', $message ); 
	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
		$message = sprintf(
			esc_html__( '"%1$s" نیاز داره به "%2$s" نسخه %3$s به بالا.', 'nour-elementor-addons' ),
			'<strong>' . esc_html__( 'ابزارک های قالب', 'nour-elementor-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'nour-elementor-addons' ) . '</strong>',
			self::MINIMUM_PHP_VERSION
		);
		printf( '<div class="notice notice-warning"><p>%1$s</p></div>', $message ); 
	}
	public static function notices_enqueue_scripts() {
	}

	public function nour_theme_builder_dismiss_notice() {
		add_option( 'nour_theme_builder_dismiss_notice', true );
	}

}
new Nour_Elementor_Addons();