<?php
namespace NourElementorAddons\Core;
use WP_REST_Server;
class Nour_Elementor_Handler_Api {
	public $prefix  = '';
	public $param   = '';
	public $request = null;

	public function __construct() {
		$this->config();
		$this->init();
	}
	public function config() {
	}
	public function init() {
		add_action(
			'rest_api_init',
			function () {
				register_rest_route(
					untrailingslashit( 'nour/v1/' . $this->prefix ),
					'/(?P<action>\w+)/' . ltrim( $this->param, '/' ),
					array(
						'methods'             => WP_REST_Server::ALLMETHODS,
						'callback'            => array( $this, 'callback' ),
						'permission_callback' => '__return_true',
					)
				);
			}
		);
	}

	public function callback( $request ) {
		$this->request = $request;
		$action_class  = strtolower( $this->request->get_method() ) . '_' . $this->request['action'];

		if ( method_exists( $this, $action_class ) ) {
			return $this->{$action_class}();
		}
		return false;
	}
}
