<?php
namespace NourElementorAddons\Libs\Dashboard\Classes;
defined( 'ABSPATH' ) || exit;
class Nour_Elementor_Dashboard_Ajax {
	private $utils;
	public function __construct() {
		add_action( 'wp_ajax_nour_elementor_addons_admin_action', array( $this, 'nour_elementor_addons_admin_action' ) );
		$this->utils = Nour_Elementor_Dashboard_Utils::instance();
	}
	public function nour_elementor_addons_admin_action() {
		check_ajax_referer( 'nour-dashboard-nonce', 'nonce' );
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		$widgets   = filter_var_array( wp_unslash( $_POST['nour_elementor_widget_list'] ), FILTER_UNSAFE_RAW );
		$modules   = filter_var_array( wp_unslash( $_POST['nour_elementor_module_list'] ), FILTER_UNSAFE_RAW );
		$user_data = filter_var_array( wp_unslash( $_POST['nour_elementor_user_data'] ), FILTER_UNSAFE_RAW );

		$this->utils->save_option( 'nour_elementor_widget_list', $widgets ? $widgets : array() );
		$this->utils->save_option( 'nour_elementor_module_list', $modules ? $modules : array() );
		$this->utils->save_option( 'nour_elementor_user_data', $user_data ? $user_data : array() );
		wp_die();
	}
}
