<?php
/*
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Noorgfx
 */

if (have_posts()) {
	the_post();
}

if (
	function_exists('blc_get_content_block_that_matches')
	&&
	blc_get_content_block_that_matches([
		'template_type' => 'single',
		'template_subtype' => 'canvas'
	])
) {
	echo blc_render_content_block(
		blc_get_content_block_that_matches([
			'template_type' => 'single',
			'template_subtype' => 'canvas'
		])
	);
	have_posts();
	wp_reset_query();
	return;
}

/**
 * Note to code reviewers: This line doesn't need to be escaped.
 * Function noorgfx_output_hero_section() used here escapes the value properly.
 */
if (apply_filters('noorgfx:single:has-default-hero', true)) {
	echo noorgfx_output_hero_section([
		'type' => 'type-2'
	]);
}

$page_structure = noorgfx_get_page_structure();

$container_class = 'ct-container-full';
$data_container_output = '';

if ($page_structure === 'none' || noorgfx_post_uses_vc()) {
	$container_class = 'ct-container';

	if ($page_structure === 'narrow') {
		$container_class = 'ct-container-narrow';
	}
} else {
	$data_container_output = 'data-content="' . $page_structure . '"';
}


?>

	<div
		class="<?php echo trim($container_class) ?>"
		<?php echo wp_kses_post(noorgfx_sidebar_position_attr()); ?>
		<?php echo $data_container_output; ?>
		<?php echo noorgfx_get_v_spacing() ?>>

		<?php do_action('noorgfx:single:container:top'); ?>

		<?php
			/**
			 * Note to code reviewers: This line doesn't need to be escaped.
			 * Function noorgfx_single_content() used here escapes the value properly.
			 */
			echo noorgfx_single_content();
		?>

		<?php get_sidebar(); ?>

		<?php do_action('noorgfx:single:container:bottom'); ?>
	</div>

<?php

noorgfx_display_page_elements('separated');

have_posts();
wp_reset_query();

