import { getFirstLevelOptions } from '../../options/helpers/get-value-from-input'

export const getAttributesFromOptions = (options) => {
	return Object.entries(getFirstLevelOptions(options)).reduce((acc, item) => {
		const noorgfxType = item[1].type
		let type = 'string'

		if (noorgfxType === 'ct-number') {
			type = 'number'
		}

		if (
			noorgfxType === 'ct-visibility' ||
			noorgfxType === 'ct-checkboxes' ||
			noorgfxType === 'ct-image-uploader'
		) {
			type = 'object'
		}

		if (noorgfxType === 'ct-layers') {
			type = 'array'
		}

		acc[item[0]] = {
			type,
			default: item[1].value,
		}

		return acc
	}, {})
}

export const getDefaultsFromOptions = (options) => {
	const attributes = getAttributesFromOptions(options)

	return Object.entries(attributes).reduce((acc, item) => {
		acc[item[0]] = item[1].default

		return acc
	}, {})
}

export const getOptionsForBlock = (blockName) => {
	return (
		(window.ct_localizations || window.ct_customizer_localizations)
			?.block_editor_data?.[blockName] || []
	)
}
