import { Fragment, createElement } from '@wordpress/element'
import { __ } from 'ct-i18n'

const AfterHeading = ({ item, attribute, onChange, value }) => {
	const dopdownOptions = [
		{
			label: __('Color', 'noorgfx'),
			value: 'color',
		},
		{
			label: __('Image', 'noorgfx'),
			value: 'image',
		},
		{
			label: __('Button', 'noorgfx'),
			value: 'button',
		},
		{
			label: __('Mixed', 'noorgfx'),
			value: 'mixed',
		},
		{
			label: __('Select', 'noorgfx'),
			value: 'select',
		},
	]

	if (!attribute.customAttr) {
		dopdownOptions.unshift({
			label: __('Inherit', 'noorgfx'),
			value: 'inherit',
		})
	}

	const handleChange = (e) => {
		e.stopPropagation()

		const taxonomy = value[attribute.taxonomy] || {}

		onChange({
			...value,

			[attribute.taxonomy]: {
				...taxonomy,

				swatch_type: e.target.value,
			},
		})
	}

	return (
		<Fragment>
			{__('Type', 'noorgfx')}
			<select
				id={`ct-variation-type-${attribute.taxonomy}`}
				name={`ct-variation-type-${attribute.taxonomy}`}
				onChange={handleChange}
				value={value[attribute.taxonomy]?.swatch_type || 'button'}>
				{dopdownOptions.map(({ label, value: val }) => {
					return (
						<option
							value={val}
							selected={
								value[attribute.taxonomy]?.swatch_type ===
									val ||
								(attribute.customAttr
									? val === 'button'
									: false)
							}>
							{label}
						</option>
					)
				})}
			</select>
		</Fragment>
	)
}

export default AfterHeading
