<?php

if (! isset($device)) {
	$device = 'desktop';
}

$trigger_type = noorgfx_default_akg('mobile_menu_trigger_type', $atts, 'type-1');
$trigger_design = noorgfx_default_akg('trigger_design', $atts, 'simple');
$trigger_label = noorgfx_translate_dynamic(
	noorgfx_expand_responsive_value(
		noorgfx_default_akg('trigger_label', $atts, __('Menu', 'noorgfx'))
	)[$device],
	$panel_type . ':' . $section_id . ':' . $item_id . ':trigger_label'
);

$class = 'ct-header-trigger ct-toggle';

$visibility = noorgfx_default_akg('header_trigger_visibility', $atts, [
	'tablet' => true,
	'mobile' => true,
]);

$class .= ' ' . noorgfx_visibility_classes($visibility);

$label_class = 'ct-label';

$label_class .= ' ' . noorgfx_visibility_classes(noorgfx_akg('trigger_label_visibility', $atts,
	[
		'desktop' => false,
		'tablet' => false,
		'mobile' => false,
	]
));

$trigger_label_alignment = noorgfx_expand_responsive_value(
	noorgfx_akg('trigger_label_alignment', $atts, 'right')
);

$trigger_class = trim(
	'ct-icon ' .
	noorgfx_visibility_classes(
		noorgfx_akg('trigger_icon_visibility', $atts, [
			'desktop' => true,
			'tablet' => true,
			'mobile' => true,
		])
	)
);

?>

<button
	class="<?php echo esc_attr($class) ?>"
	data-toggle-panel="#offcanvas"
	aria-controls="offcanvas"
	data-design="<?php echo $trigger_design ?>"
	data-label="<?php echo $trigger_label_alignment[$device] ?>"
	aria-label="<?php echo $trigger_label ?>"
	<?php echo noorgfx_attr_to_html($attr) ?>>

	<span class="<?php echo $label_class ?>" aria-hidden="true"><?php echo $trigger_label ?></span>

	<svg
		class="<?php echo esc_attr($trigger_class) ?>"
		width="18" height="14" viewBox="0 0 18 14"
		data-type="<?php echo esc_attr($trigger_type) ?>"
		aria-hidden="true">

		<rect y="0.00" width="18" height="1.7" rx="1"/>
		<rect y="6.15" width="18" height="1.7" rx="1"/>
		<rect y="12.3" width="18" height="1.7" rx="1"/>
	</svg>
</button>
