<?php

$class = 'ct-header-socials';

$visibility = noorgfx_default_akg('visibility', $atts, [
	'tablet' => true,
	'mobile' => true,
]);

$class .= ' ' . noorgfx_visibility_classes($visibility);

$socialsColor = noorgfx_default_akg('headerSocialsColor', $atts, 'custom');
$socialsType = noorgfx_default_akg('socialsType', $atts, 'simple');

$socials = noorgfx_default_akg(
	'header_socials',
	$atts,
	[
		[
			'id' => 'facebook',
			'enabled' => true,
		],

		[
			'id' => 'twitter',
			'enabled' => true,
		],

		[
			'id' => 'instagram',
			'enabled' => true,
		],
	]
);

$link_rel = '';


$link_target = noorgfx_default_akg('link_target', $atts, 'no');

if ($link_target === 'yes') {
	$link_target = '_blank';
	$link_rel = 'noopener noreferrer';
} else {
	$link_target = false;
}

$link_nofollow = noorgfx_default_akg('link_nofollow', $atts, 'no');

if ($link_nofollow === 'yes') {
	$link_rel .= ' nofollow';
}

?>

<div
	class="<?php echo esc_attr($class) ?>"
	<?php echo noorgfx_attr_to_html($attr) ?>>

	<?php echo noorgfx_social_icons($socials, [
		'type' => $socialsType,
		'icons-color' => $socialsColor,
		'fill' => noorgfx_default_akg(
			'socialsFillType',
			$atts,
			'outline'
		),
		'label_visibility' => noorgfx_akg(
			'socialsLabelVisibility',
			$atts,
			[
				'desktop' => false,
				'tablet' => false,
				'mobile' => false,
			]
		),
		'links_target' => $link_target,
		'links_rel' => $link_rel,
	]) ?>

</div>
