<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'offcanvas_behavior' => [
				'label' => __('Reveal as', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'panel',
				'view' => 'text',
				'design' => 'block',
				'choices' => [
					'modal' => __( 'Modal', 'noorgfx' ),
					'panel' => __( 'Side Panel', 'noorgfx' ),
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'offcanvas_behavior' => 'panel' ],
				'options' => [

					'side_panel_position' => [
						'label' => __('Reveal From', 'noorgfx'),
						'type' => 'ct-radio',
						'value' => 'right',
						'view' => 'text',
						'design' => 'block',
						'choices' => [
							'left' => __( 'Left Side', 'noorgfx' ),
							'right' => __( 'Right Side', 'noorgfx' ),
						],
					],

					'side_panel_width' => [
						'label' => __( 'Panel Width', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => [
							'desktop' => '500px',
							'tablet' => '65vw',
							'mobile' => '90vw',
						],
						'units' => noorgfx_units_config([
							[ 'unit' => 'px', 'min' => 0, 'max' => 1000 ],
						]),
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'offcanvas_content_vertical_alignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Vertical Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'responsive' => true,
				'attr' => [ 'data-type' => 'vertical-alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'flex-start',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			'offcanvasContentAlignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Horizontal Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top',
				'responsive' => true,
				'attr' => [ 'data-type' => 'horizontal-alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'initial' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			'has_offcanvas_heading' => [
				'label' => __( 'Panel Heading', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top:full',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_offcanvas_heading' => 'yes' ],
				'options' => [

					'offcanvas_heading' => [
						'label' => false,
						'type' => 'text',
						'design' => 'block',
						'disableRevertButton' => true,
						'value' => __( 'Menu', 'noorgfx' ),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'offcanvas_behavior' => 'panel' ],
				'options' => [

					'has_offcanvas_offset' => [
						'label' => __( 'Panel Offset', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top:full',
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'has_offcanvas_offset' => 'yes' ],
						'options' => [

							'offcanvas_offset' => [
								'label' => __( 'Offset', 'noorgfx' ),
								'type' => 'ct-slider',
								'value' => 20,
								'min' => 10,
								'max' => 100,
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
							],

						],
					],

				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'offcanvasBackground' => [
				'label' => __( 'Panel Background', 'noorgfx' ),
				'type'  => 'ct-background',
				'design' => 'block:right',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => 'rgba(18, 21, 25, 0.98)'
						],
					],
				])
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'offcanvas_behavior' => 'panel' ],
				'options' => [

					'offcanvasBackdrop' => [
						'label' => __( 'Panel Backdrop', 'noorgfx' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'top',
						'has_no_color' => true,
						'default_inherit_color' => 'rgba(18, 21, 25, 0.5)',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => 'CT_CSS_SKIP_RULE',
								],
							],
						])
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'offcanvas_behavior' => 'panel' ],
				'options' => [

					'headerPanelShadow' => [
						'label' => __( 'Panel Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'design' => 'block',
						'responsive' => true,
						'divider' => 'top',
						'value' => noorgfx_box_shadow_value([
							'enable' => true,
							'h_offset' => 0,
							'v_offset' => 0,
							'blur' => 70,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(0, 0, 0, 0.35)',
							],
						])
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'has_offcanvas_offset' => 'yes'],
						'options' => [

							'offcanvas_panel_radius' => [
								'label' => __( 'Panel Border Radius', 'noorgfx' ),
								'type' => 'ct-spacing',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => noorgfx_spacing_value([
									'top' => '10px',
									'left' => '10px',
									'right' => '10px',
									'bottom' => '10px',
								]),
								'min' => 0,
								'responsive' => true
							],

						],
					],

				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_offcanvas_heading' => 'yes' ],
				'options' => [

					'offcanvas_heading_font_color' => [
						'label' => __( 'Panel Heading Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'top:full',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text Initial', 'noorgfx' ),
								'id' => 'default',
							],
						],
					],

				],
			],

			'menu_close_button_type' => [
				'label' => __('Close Button Type', 'noorgfx'),
				'type' => 'ct-select',
				'value' => 'type-1',
				'view' => 'text',
				'design' => 'inline',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => noorgfx_ordered_keys(
					[
						'type-1' => __( 'Simple', 'noorgfx' ),
						'type-2' => __( 'Border', 'noorgfx' ),
						'type-3' => __( 'Background', 'noorgfx' ),
					]
				),
			],

			'menu_close_button_icon_size' => [
				'label' => __( 'Icon Size', 'noorgfx' ),
				'type' => 'ct-number',
				'design' => 'inline',
				'value' => 12,
				'min' => 5,
				'max' => 50,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'menu_close_button_color' => [
				'label' => __( 'Icon Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'block',
				'divider' => 'top',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'rgba(255, 255, 255, 0.7)'
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => '#ffffff'
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_close_button_type' => 'type-2' ],
				'options' => [

					'menu_close_button_border_color' => [
						'label' => __( 'Border Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_close_button_type' => 'type-3' ],
				'options' => [

					'menu_close_button_shape_color' => [
						'label' => __( 'Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],

						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'rgba(0, 0, 0, 0.5)'
							],
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'menu_close_button_type' => '!type-1' ],
				'options' => [

					'menu_close_button_border_radius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'inline',
						'value' => 5,
						'min' => 0,
						'max' => 100,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],

				],
			],

		],
	],

];
