<?php

$has_shrink = false;

if (empty($default_height)) {
	$has_shrink = true;

	$default_height = [
		'mobile' => 70,
		'tablet' => 70,
		'desktop' => 120,
	];
}

if (empty($default_background)) {
	$default_background = noorgfx_background_default_value([
		'backgroundColor' => [
			'default' => [
				'color' => 'var(--theme-palette-color-8)',
			],
		],
	]);
}

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'headerRowWidth' => [
				'label' => __( 'Container Structure', 'noorgfx' ),
				'type' => 'ct-radio',
				'value' => 'fixed',
				'view' => 'text',
				'design' => 'block',
				'responsive' => [
					'tablet' => 'skip'
				],
				'choices' => [
					'fixed' => __( 'Default', 'noorgfx' ),
					'boxed' => __( 'Boxed', 'noorgfx' ),
					'fluid' => __( 'Full Width', 'noorgfx' ),
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'headerRowHeight' => [
				'label' => __( 'Row Min Height', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 20,
				'max' => 300,
				'responsive' => true,
				'value' => $default_height,
				'setting' => [ 'transport' => 'postMessage' ],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'builderSettings/has_sticky_header' => 'yes'
				],
				'options' => [
					'has_sticky_shrink' => [
						'label' => __( 'Sticky State Row Shrink', 'noorgfx' ),
						'type' => 'ct-switch',
						'type' => $has_shrink ? 'ct-switch' : 'hidden',
						'value' => 'no',
						'divider' => 'top',

						'sync' => [
							'id' => 'header_placements_1'
						]
					],
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_sticky_shrink' => 'yes' ],
				'options' => [

					'stickyHeaderRowShrink' => [
						'label' => __( 'Row Max Height', 'noorgfx' ),
						'type' => $has_shrink ? 'ct-slider' : 'hidden',
						'min' => 30,
						'max' => 100,
						'responsive' => true,
						'value' => 70,
						'defaultUnit' => '%',
						'sync' => [
							'id' => 'header_placements_1'
						],
					],

				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'itemsCount' => '0' ],
				'options' => [
					'render_empty_row' => [
						'label' => __( 'Render Empty Row', 'noorgfx' ),
						'type' => 'ct-switch',
						'type' => 'ct-switch',
						'value' => 'no',
						'divider' => 'top:full',
						'sync' => [
							'id' => 'header_placements_1'
						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
				'options' => [
					'headerRowVisibility' => [
						'label' => __( 'Row Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'divider' => 'top:full',
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'tablet' => true,
							'mobile' => true,
						]),
						'choices' => noorgfx_ordered_keys([
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],
				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Background', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerRowBackground',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderRowBackground',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderRowBackground',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerRowBackground' => [
						'label' => __( 'Background', 'noorgfx' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'value' => $default_background,
						'sync' => 'live'
					],

					'transparentHeaderRowBackground' => [
						'label' => __( 'Background', 'noorgfx' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => 'rgba(255,255,255,0)',
								],
							],
						]),
						'sync' => 'live'
					],

					'stickyHeaderRowBackground' => [
						'label' => __( 'Background', 'noorgfx' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'value' => $default_background,
						'sync' => 'live'
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Backdrop Blur', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerRowBlur',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderRowBlur',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderRowBlur',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerRowBlur' => [
						'label' => __( 'Backdrop Blur', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'block:right',
						'value' => 0,
						'min' => 0,
						'max' => 100,
						'responsive' => true,
					],

					'transparentHeaderRowBlur' => [
						'label' => __( 'Backdrop Blur', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'block:right',
						'value' => 0,
						'min' => 0,
						'max' => 100,
						'responsive' => true,
					],

					'stickyHeaderRowBlur' => [
						'label' => __( 'Backdrop Blur', 'noorgfx' ),
						'type' => 'ct-number',
						'design' => 'block:right',
						'value' => 0,
						'min' => 0,
						'max' => 100,
						'responsive' => true,
					],

				],
			],



			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Top Border', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerRowTopBorder',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderRowTopBorder',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderRowTopBorder',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerRowTopBorder' => [
						'label' => __( 'Top Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'responsive' => true,
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => 'rgba(44,62,80,0.2)',
							],
						]
					],

					'transparentHeaderRowTopBorder' => [
						'label' => __( 'Top Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						]
					],

					'stickyHeaderRowTopBorder' => [
						'label' => __( 'Top Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						]
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'headerRowTopBorder/style:responsive' => '!none',
						'transparentHeaderRowTopBorder/style:responsive' => '!none',
						'stickyHeaderRowTopBorder/style:responsive' => '!none',
					]
				],
				'options' => [

					'headerRowTopBorderFullWidth' => [
						'label' => __( 'Top Border Width', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'no',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'no' => __( 'Default', 'noorgfx' ),
							'yes' => __( 'Full Width', 'noorgfx' ),
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Bottom Border', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerRowBottomBorder',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderRowBottomBorder',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderRowBottomBorder',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerRowBottomBorder' => [
						'label' => __( 'Bottom Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => 'rgba(44,62,80,0.2)',
							],
						]
					],

					'transparentHeaderRowBottomBorder' => [
						'label' => __( 'Bottom Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						]
					],

					'stickyHeaderRowBottomBorder' => [
						'label' => __( 'Bottom Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'responsive' => true,
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						]
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'headerRowBottomBorder/style:responsive' => '!none',
						'transparentHeaderRowBottomBorder/style:responsive' => '!none',
						'stickyHeaderRowBottomBorder/style:responsive' => '!none'
					]
				],
				'options' => [

					'headerRowBottomBorderFullWidth' => [
						'label' => __( 'Bottom Border Width', 'noorgfx' ),
						'type' => 'ct-radio',
						'value' => 'no',
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'no' => __( 'Default', 'noorgfx' ),
							'yes' => __( 'Full Width', 'noorgfx' ),
						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Shadow', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerRowShadow',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderRowShadow',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderRowShadow',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerRowShadow' => [
						'label' => __( 'Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'responsive' => true,
						'hide_shadow_placement' => true,
						'value' => noorgfx_box_shadow_value([
							'enable' => false,
							'h_offset' => 0,
							'v_offset' => 10,
							'blur' => 20,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(44,62,80,0.05)',
							],
						])
					],

					'transparentHeaderRowShadow' => [
						'label' => __( 'Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'responsive' => true,
						'hide_shadow_placement' => true,
						'value' => noorgfx_box_shadow_value([
							'enable' => false,
							'h_offset' => 0,
							'v_offset' => 10,
							'blur' => 20,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(44,62,80,0.05)',
							],
						])
					],

					'stickyHeaderRowShadow' => [
						'label' => __( 'Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'responsive' => true,
						'hide_shadow_placement' => true,
						'value' => noorgfx_box_shadow_value([
							'enable' => false,
							'h_offset' => 0,
							'v_offset' => 10,
							'blur' => 20,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(44,62,80,0.05)',
							],
						])
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'headerRowWidth:responsive' => 'boxed' ],
				'options' => [
					'header_row_padding' => [
						'label' => __( 'Row Padding', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top: full',
						'value' => [
							'desktop' => noorgfx_spacing_value([
								'top' => 'auto',
								'left' => '35px',
								'right' => '35px',
								'bottom' => 'auto',
							]),
							'tablet' => noorgfx_spacing_value([
								'top' => 'auto',
								'left' => '4vw',
								'right' => '4vw',
								'bottom' => 'auto',
							]),
							'mobile'=> noorgfx_spacing_value([
								'top' => 'auto',
								'left' => '5vw',
								'right' => '5vw',
								'bottom' => 'auto',
							]),
							'__changed' => ['tablet', 'mobile']
						],
						'min' => 0,
						'responsive' => true,
						'sync' => 'live',
					],

					'header_row_border_radius' => [
						'label' => __( 'Row Border Radius', 'noorgfx' ),
						'type' => 'ct-spacing',
						'sync' => 'live',
						'divider' => 'top:',
						'value' => noorgfx_spacing_value(),
						'min' => 0,
						'responsive' => true
					],
				],
			],

		],
	],
];
