<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

$menu_type = noorgfx_akg( 'header_menu_type', $atts, 'type-1' );

// Items spacing
$headerMenuItemsSpacing = noorgfx_akg( 'headerMenuItemsSpacing', $atts, 25 );

if ($headerMenuItemsSpacing !== 25) {
	$css->put(
		noorgfx_assemble_selector($root_selector),
		'--menu-items-spacing: ' . $headerMenuItemsSpacing . 'px'
	);
}


// Items gap
$headerMenuItemsGap = noorgfx_akg( 'headerMenuItemsGap', $atts, 0 );

if ($headerMenuItemsGap !== 0) {
	$css->put(
		noorgfx_assemble_selector($root_selector),
		'--menu-items-gap: ' . $headerMenuItemsGap . 'px'
	);
}


// Items height
$headerMenuItemsHeight = noorgfx_akg( 'headerMenuItemsHeight', $atts, 100 );

if ($headerMenuItemsHeight !== 100) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])
		),
		'--menu-item-height: ' . $headerMenuItemsHeight . '%'
	);
}


// Top level font
noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'headerMenuFont', $atts,
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n7',
			'line-height' => '1.3',
			'text-transform' => 'uppercase',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '> ul > li > a'
		])
	)
]);


// Font color
$font_variables = [
	'default' => [
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])
		),
		'variable' => 'theme-link-initial-color'
	]
];

$hover_option_id = 'hover';
$active_option_id = 'active';

if ($menu_type === 'type-3') {
	$hover_option_id = 'hover-type-3';
	$active_option_id = 'active-type-3';
}

$font_variables[$hover_option_id] = [
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '> ul > li > a'
		])
	),
	'variable' => 'theme-link-hover-color'
];

$font_variables[$active_option_id] = [
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '> ul > li > a'
		])
	),
	'variable' => 'theme-link-active-color'
];

noorgfx_output_colors([
	'value' => noorgfx_akg('menuFontColor', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-text-color)' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

		'hover-type-3' => [ 'color' => '#ffffff' ],
		'active-type-3' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => $font_variables
]);

// Active indicator color
noorgfx_output_colors([
	'value' => noorgfx_akg('menuIndicatorColor', $atts),
	'default' => [
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'hover' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'menu-indicator-hover-color'
		],

		'active' => [
			'selector' => noorgfx_assemble_selector($root_selector),
			'variable' => 'menu-indicator-active-color'
		],
	],
]);

// Dropdown font color
noorgfx_output_colors([
	'value' => noorgfx_akg('headerDropdownFontColor', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-palette-color-8)' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu .ct-menu-link'
				])
			),
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu .ct-menu-link'
				])
			),
			'variable' => 'theme-link-hover-color'
		],

		'active' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu .ct-menu-link'
				])
			),
			'variable' => 'theme-link-active-color'
		],
	],
]);

// Dropdown background
noorgfx_output_colors([
	'value' => noorgfx_akg('headerDropdownBackground', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu'
				])
			),
			'variable' => 'dropdown-background-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.sub-menu'
				])
			),
			'variable' => 'dropdown-background-hover-color'
		],
	],
]);

// transparent state
if (isset($has_transparent_header) && $has_transparent_header) {
	$font_variables = [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '> ul > li > a'
					]),
					'operation' => 'between',
					'to_add' => '[data-transparent-row="yes"]'
				])
			),
			'variable' => 'theme-link-initial-color'
		]
	];

	$font_variables[$hover_option_id] = [
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> ul > li > a'
				]),
				'operation' => 'between',
				'to_add' => '[data-transparent-row="yes"]'
			])
		),

		'variable' => 'theme-link-hover-color'
	];

	$font_variables[$active_option_id] = [
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> ul > li > a'
				]),
				'operation' => 'between',
				'to_add' => '[data-transparent-row="yes"]'
			])
		),

		'variable' => 'theme-link-active-color'
	];

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentMenuFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

			'hover-type-3' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active-type-3' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => $font_variables
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentMenuIndicatorColor', $atts),
		'default' => [
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'menu-indicator-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'menu-indicator-active-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentHeaderDropdownFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu .ct-menu-link'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu .ct-menu-link'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu .ct-menu-link'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'theme-link-active-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('transparentHeaderDropdownBackground', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'dropdown-background-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu'
						]),
						'operation' => 'between',
						'to_add' => '[data-transparent-row="yes"]'
					])
				),
				'variable' => 'dropdown-background-hover-color'
			],
		],
	]);
}

// sticky state
if (isset($has_sticky_header) && $has_sticky_header) {
	$font_variables = [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '> ul > li > a'
					]),
					'operation' => 'between',
					'to_add' => '[data-sticky*="yes"]'
				])
			),
			'variable' => 'theme-link-initial-color'
		]
	];

	$font_variables[$hover_option_id] = [
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> ul > li > a'
				]),
				'operation' => 'between',
				'to_add' => '[data-sticky*="yes"]'
			])
		),
		'variable' => 'theme-link-hover-color'
	];

	$font_variables[$active_option_id] = [
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '> ul > li > a'
				]),
				'operation' => 'between',
				'to_add' => '[data-sticky*="yes"]'
			])
		),
		'variable' => 'theme-link-active-color'
	];

	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyMenuFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],

			'hover-type-3' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active-type-3' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => $font_variables
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyMenuIndicatorColor', $atts),
		'default' => [
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'menu-indicator-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'menu-indicator-active-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyHeaderDropdownFontColor', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu .ct-menu-link'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-initial-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu .ct-menu-link'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-hover-color'
			],

			'active' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu .ct-menu-link'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'theme-link-active-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_akg('stickyHeaderDropdownBackground', $atts),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,

		'variables' => [
			'default' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'dropdown-background-color'
			],

			'hover' => [
				'selector' => noorgfx_assemble_selector(
					noorgfx_mutate_selector([
						'selector' => noorgfx_mutate_selector([
							'selector' => $root_selector,
							'operation' => 'suffix',
							'to_add' => '.sub-menu'
						]),
						'operation' => 'between',
						'to_add' => '[data-sticky*="yes"]'
					])
				),
				'variable' => 'dropdown-background-hover-color'
			],
		],
	]);
}

// Top level margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'headerMenuMargin', $atts,
		noorgfx_spacing_value(
			// [
			// 	'top' => 'auto',
			// 	'bottom' => 'auto',
			// ]
		)
	)
]);

if($menu_type === 'type-3') {
	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])
		),
		'property' => 'menu-item-radius',
		'value' => noorgfx_default_akg(
			'headerToplevelBorderRadius',
			$atts,
			noorgfx_spacing_value()
		)
	]);
}

// Dropdown top offset
$dropdownTopOffset = noorgfx_akg( 'dropdownTopOffset', $atts, 0 );

if ($dropdownTopOffset !== 0) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.sub-menu'
			])
		),
		'--dropdown-top-offset: ' . $dropdownTopOffset . 'px'
	);
}

if (isset($has_sticky_header) && $has_sticky_header) {

	$stickyStateDropdownTopOffset = noorgfx_akg( 'stickyStateDropdownTopOffset', $atts, 0 );

	// if ($stickyStateDropdownTopOffset !== 0) {
		$css->put(
			noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => noorgfx_mutate_selector([
						'selector' => $root_selector,
						'operation' => 'suffix',
						'to_add' => '.sub-menu'
					]),
					'operation' => 'between',
					'to_add' => '[data-sticky*="yes"]'
				])
			),
			'--sticky-state-dropdown-top-offset: ' . $stickyStateDropdownTopOffset . 'px'
		);
	// }
}

// Dropdowns horizontal spacing
$dropdown_horizontal_offset = noorgfx_akg( 'dropdown_horizontal_offset', $atts, 5 );

if ($dropdown_horizontal_offset !== 5) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.sub-menu'
			])
		),
		'--dropdown-horizontal-offset: ' . $dropdown_horizontal_offset . 'px'
	);
}


// Dropdown box width
$dropdownMenuWidth = noorgfx_akg( 'dropdownMenuWidth', $atts, 200 );

if ($dropdownMenuWidth !== 200) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.sub-menu'
			])
		),
		'--dropdown-width: ' . $dropdownMenuWidth . 'px'
	);
}


// Dropdown items spacing
$dropdownItemsSpacing = noorgfx_akg( 'dropdownItemsSpacing', $atts, 13 );

if ($dropdownItemsSpacing !== 13) {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.sub-menu'
			])
		),
		'--dropdown-items-spacing: ' . $dropdownItemsSpacing . 'px'
	);
}


// Dropdown font
noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'headerDropdownFont', $atts,
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n5',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.sub-menu .ct-menu-link'
		])
	),
]);

// Dropdown divider
$headerDropdownDividerDefault = [
	'width' => 1,
	'style' => 'dashed',
	'color' => [
		'color' => 'rgba(255, 255, 255, 0.1)',
	],
];

$headerDropdownDivider = noorgfx_akg(
	'headerDropdownDivider',
	$atts,
	$headerDropdownDividerDefault
);

noorgfx_output_border([
	'css' => $css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.sub-menu'
		])
	),
	'variableName' => 'dropdown-divider',
	'value' => $headerDropdownDivider,
	'default' => $headerDropdownDividerDefault
]);

if (noorgfx_default_akg('dropdown_items_type', $atts, 'simple') === 'padded') {
	$css->put(
		noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '.sub-menu'
			])
		),
		'--has-divider: ' . (
			$headerDropdownDivider['style'] !== 'none' ? '1' : '0'
		)
	);
}

// Box shadow
noorgfx_output_box_shadow([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.sub-menu'
		])
	),
	'value' => noorgfx_akg('headerDropdownShadow', $atts, noorgfx_box_shadow_value([
		'enable' => true,
		'h_offset' => 0,
		'v_offset' => 10,
		'blur' => 20,
		'spread' => 0,
		'inset' => false,
		'color' => [
			'color' => 'rgba(41, 51, 61, 0.1)',
		],
	])),
	'responsive' => true
]);

// Border radius
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.sub-menu'
		])
	),
	'property' => 'theme-border-radius',
	'value' => noorgfx_default_akg(
		'headerDropdownRadius',
		$atts,
		noorgfx_spacing_value([
			'top' => '0px',
			'left' => '2px',
			'right' => '0px',
			'bottom' => '2px',
		])
	)
]);
