<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => array_merge(
			[
				'custom_logo' => [
					'label' => __( 'Logo', 'noorgfx' ),
					'type' => 'ct-image-uploader',
					'value' => noorgfx_get_theme_mod('custom_logo', ''),
					'revertDefaultValue' => '',
					'inline_value' => true,
					'responsive' => [
						'tablet' => 'skip'
					],
					'attr' => [ 'data-type' => 'small' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'builderSettings/has_transparent_header' => 'yes',
					],
					'options' => [
						'transparent_logo' => [
							'label' => __( 'Transparent State Logo', 'noorgfx' ),
							'type' => 'ct-image-uploader',
							'value' => '',
							'inline_value' => true,
							'responsive' => [
								'tablet' => 'skip'
							],
							'divider' => 'top',
							'attr' => [ 'data-type' => 'small' ],
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							'custom_logo:truthy' => 'yes',
							'all' => [
								'builderSettings/has_transparent_header' => 'yes',
								'transparent_logo:truthy' => 'yes',
							]
						]
					],
					'options' => [
						[
							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [
									'builderSettings/has_sticky_header' => 'yes',
								],
								'options' => [
									'sticky_logo' => [
										'label' => __( 'Sticky State Logo', 'noorgfx' ),
										'type' => 'ct-image-uploader',
										'value' => '',
										'inline_value' => true,
										'responsive' => [
											'tablet' => 'skip'
										],
										'divider' => 'top',
										'attr' => [ 'data-type' => 'small' ],
									],
								],
							],
						],

						apply_filters(
							'noorgfx:panel-builder:logo:options:general',
							[],
							$panel_type
						),
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'logoMaxHeight' => [
					'label' => __( 'Logo Height', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 300,
					'value' => 50,
					'responsive' => true,
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'builderSettings/has_sticky_header' => 'yes',
						'row' => 'middle-row'
					],
					'options' => [
						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						'has_sticky_logo_shrink' => [
							'label' => __( 'Sticky State Shrink', 'noorgfx' ),
							'type' => 'ct-switch',
							'type' => 'ct-switch',
							'value' => 'no',
							'sync' => [
								'id' => 'header_placements_1'
							]
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'builderSettings/has_sticky_header' => 'yes',
						'row' => 'middle-row',
						'has_sticky_logo_shrink' => 'yes'
					],
					'options' => [

						'sticky_logo_shrink' => [
							'label' => __( 'Logo Height', 'noorgfx' ),
							'type' => 'ct-slider',
							'min' => 30,
							'max' => 100,
							'responsive' => true,
							'value' => 70,
							'defaultUnit' => '%',
							'sync' => [
								'id' => 'header_placements_1'
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'has_site_title' => [
					'label' => __( 'Site Title', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'yes',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_site_title' => 'yes' ],
					'options' => [

						'blogname' => [
							'label' => false,
							'type' => 'text',
							'design' => 'block',
							'disableRevertButton' => true,
							'value' => get_option('blogname'),
						],

						'has_site_title_link' => [
							'label' => __( 'Site Title Link', 'noorgfx' ),
							'type' => 'ct-switch',
							'value' => 'yes',
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'blogname_visibility' => [
							'label' => __( 'Site Title Visibility', 'noorgfx' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'allow_empty' => true,
							'sync' => 'live',
							'value' => noorgfx_default_responsive_value([
								'desktop' => true,
								'tablet' => true,
								'mobile' => true,
							]),
							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx' ),
								'tablet' => __( 'Tablet', 'noorgfx' ),
								'mobile' => __( 'Mobile', 'noorgfx' ),
							]),
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'has_tagline' => [
					'label' => __( 'Site Tagline', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'no',
					'setting' => [ 'transport' => 'postMessage' ],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_tagline' => 'yes' ],
					'options' => [

						'blogdescription' => [
							'label' => false,
							'type' => 'text',
							'design' => 'block',
							'disableRevertButton' => true,
							'value' => get_option( 'blogdescription' ),
						],

						'blogdescription_visibility' => [
							'label' => __( 'Site Tagline Visibility', 'noorgfx' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'allow_empty' => true,
							'sync' => 'live',
							'value' => noorgfx_default_responsive_value([
								'desktop' => true,
								'tablet' => true,
								'mobile' => true,
							]),
							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx' ),
								'tablet' => __( 'Tablet', 'noorgfx' ),
								'mobile' => __( 'Mobile', 'noorgfx' ),
							]),
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'custom_logo:truthy' => 'yes',
					],
					'options' => [

						'has_logo_image_link' => [
							'label' => __( 'Logo Image Link', 'noorgfx' ),
							'type' => 'ct-switch',
							'value' => 'yes',
							'setting' => [ 'transport' => 'postMessage' ],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'has_svg_logo' => 'yes'
					],
					'computed_fields' => ['has_svg_logo'],
					'options' => [
						'inline_svg_logos' => [
							'label' => __('Logo Inline SVG File', 'noorgfx'),
							'type' => 'ct-switch',
							'value' => 'no',
							// 'divider' => 'top:full',
						]
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						'custom_logo:truthy' => 'yes',
					],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [
								'any' => [
									'has_site_title' => 'yes',
									'has_tagline' => 'yes',
								]
							],
							'options' => [

								noorgfx_rand_md5() => [
									'type' => 'ct-divider',
								],

								'logo_position' => [
									'label' => __( 'Logo Image Position', 'noorgfx' ),
									'type' => 'ct-radio',
									'value' => 'top',
									'view' => 'text',
									'design' => 'block',
									'responsive' => [
										'tablet' => 'skip'
									],
									'choices' => [
										'left' => __( 'Left', 'noorgfx' ),
										'right' => __( 'Right', 'noorgfx' ),
										'top' => __( 'Top', 'noorgfx' ),
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],
					],
				],
			],

			$panel_type === 'header' ? [
				// noorgfx_rand_md5() => [
				// 	'type' => 'ct-divider',
				// ],

				'header_logo_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Content Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'left' => '',
						'center' => '',
						'right' => '',
					],
				],
			] : [],

			$panel_type === 'footer' ? [
				// noorgfx_rand_md5() => [
				// 	'type' => 'ct-divider',
				// ],

				'footer_logo_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_logo_vertical_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Vertical Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'attr' => [ 'data-type' => 'vertical-alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'visibility' => [
					'label' => __('Element Visibility', 'noorgfx'),
					'type' => 'ct-visibility',
					'design' => 'block',
					'divider' => 'top',
					'sync' => 'live',
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx' ),
						'tablet' => __( 'Tablet', 'noorgfx' ),
						'mobile' => __( 'Mobile', 'noorgfx' ),
					]),
				],
			] : [],

			[
				'header_logo_class' => [
					'label' => __( 'CSS Class', 'noorgfx' ),
					'type' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'value' => '',
					'desc' => __( 'Separate multiple classes with spaces.', 'noorgfx' ),
				],

				'header_logo_aria_label' => [
					'label' => __( 'Custom Aria Label', 'noorgfx' ),
					'type' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'value' => '',
					'desc' => noorgfx_safe_sprintf(
						// translators: placeholder here means the actual URL.
						__( 'Add a custom %saria label%s attribute.', 'noorgfx' ),
						noorgfx_safe_sprintf(
							'<a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-label" target="_blank">'
						),
						'</a>'
					),
				],
			]
		),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_site_title' => 'yes' ],
				'options' => [

					'siteTitle' => [
						'type' => 'ct-typography',
						'label' => __( 'Site Title', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '25px',
							'variation' => 'n7',
							'line-height' => '1.5'
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Site Title Color', 'noorgfx' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'siteTitleColor',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparentSiteTitleColor',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'stickySiteTitleColor',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [

							'siteTitleColor' => [
								'label' => __( 'Site Title Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => 'var(--theme-palette-color-4)',
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)',
										'condition' => [ 'has_site_title_link' => 'yes' ]
									],
								],
							],

							'transparentSiteTitleColor' => [
								'label' => __( 'Site Title Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'condition' => [ 'has_site_title_link' => 'yes' ]
									],
								],
							],

							'stickySiteTitleColor' => [
								'label' => __( 'Site Title Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'condition' => [ 'has_site_title_link' => 'yes' ]
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_tagline' => 'yes' ],
				'options' => [

					'siteTagline' => [
						'type' => 'ct-typography',
						'label' => __( 'Site Tagline Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '13px',
							'variation' => 'n5',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Site Tagline Color', 'noorgfx' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'siteTaglineColor',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparentSiteTaglineColor',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'stickySiteTaglineColor',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [

							'siteTaglineColor' => [
								'label' => __( 'Site Tagline Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],
								],
							],

							'transparentSiteTaglineColor' => [
								'label' => __( 'Site Tagline Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],
								],
							],

							'stickySiteTaglineColor' => [
								'label' => __( 'Site Tagline Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

				],
			],

			'headerLogoMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],
];
