<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

$render = new Noorgfx_Header_Builder_Render([
	'current_section_id' => $section_id
]);
$header_height = $render->get_header_height();

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'variableName' => 'header-height',
	'value' => $header_height
]);

if (isset($has_sticky_header) && $has_sticky_header) {
	$scroll_margin_top_offset = $header_height;

	$header_sticky_height = $render->get_header_height($has_sticky_header);

	if (! in_array('desktop', $has_sticky_header['devices'])) {
		$header_sticky_height['desktop'] = 0;
	}

	if (! in_array('mobile', $has_sticky_header['devices'])) {
		$header_sticky_height['tablet'] = 0;
		$header_sticky_height['mobile'] = 0;
	}

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'header-sticky-height',
		'value' => $header_sticky_height
	]);

	$current_section = $render->get_current_section();

	if (! isset($current_section['settings'])) {
		$current_section['settings'] = [];
	}

	$atts = $current_section['settings'];

	$sticky_offset = noorgfx_akg('sticky_offset', $atts, '0');
	$animation_speed = noorgfx_akg('sticky_animation_speed', $atts, '0.2');

	if ($animation_speed !== '0.2') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_assemble_selector($root_selector),
			'variableName' => 'header-sticky-animation-speed',
			'value' => $animation_speed,
			'unit' => 's'
		]);
	}

	if ($sticky_offset !== '0') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_assemble_selector($root_selector),
			'variableName' => 'header-sticky-offset',
			'value' => $sticky_offset
		]);
	}
}

// background - initial state
noorgfx_output_background_css([
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.ct-header'
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => noorgfx_akg(
		'headerBackground',
		$atts,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
				],
			],
		])
	),
	'responsive' => true,
	'forced_background_image' => true
]);


// background - transparent state
if (isset($has_transparent_header) && $has_transparent_header) {

	noorgfx_output_background_css([
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '[data-transparent]'
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => noorgfx_akg(
			'transparentHeaderBackground',
			$atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
					],
				],
			])
		),
		'responsive' => true,
		'forced_background_image' => true
	]);
}

// background - sticky state
if (isset($has_sticky_header) && $has_sticky_header) {

	noorgfx_output_background_css([
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'to_add' => '[data-sticky*="yes"]'
			])
		),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => noorgfx_akg(
			'stickyHeaderBackground',
			$atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')
					],
				],
			])
		),
		'responsive' => true,
		'forced_background_image' => true
	]);
}