<?php

$options = [

	noorgfx_rand_md5() => [
		'type' => 'ct-title',
		'label' => __( 'Top Level Options', 'noorgfx' ),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			apply_filters(
				'noorgfx:header:cart:options:icon',
				[
					'mini_cart_type' => [
						'label' => false,
						'type' => 'ct-image-picker',
						'value' => 'type-1',
						'attr' => [
							'data-type' => 'background',
							'data-columns' => '3',
						],
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [

							'type-1' => [
								'src'   => noorgfx_image_picker_file( 'cart-1' ),
								'title' => __( 'Type 1', 'noorgfx' ),
							],

							'type-2' => [
								'src'   => noorgfx_image_picker_file( 'cart-2' ),
								'title' => __( 'Type 2', 'noorgfx' ),
							],

							'type-3' => [
								'src'   => noorgfx_image_picker_file( 'cart-3' ),
								'title' => __( 'Type 3', 'noorgfx' ),
							],

							'type-4' => [
								'src'   => noorgfx_image_picker_file( 'cart-4' ),
								'title' => __( 'Type 4', 'noorgfx' ),
							],

							'type-5' => [
								'src'   => noorgfx_image_picker_file( 'cart-5' ),
								'title' => __( 'Type 5', 'noorgfx' ),
							],

							'type-6' => [
								'src'   => noorgfx_image_picker_file( 'cart-6' ),
								'title' => __( 'Type 6', 'noorgfx' ),
							],
						],
					],
				]
			),

			'cartIconSize' => [
				'label' => __( 'Icon Size', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 5,
				'max' => 50,
				'value' => 15,
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'cart_icon_visibility' => [
				'label' => __('Icon Visibility', 'noorgfx'),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top',
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),

				'choices' => noorgfx_ordered_keys([
					'desktop' => __('Desktop', 'noorgfx'),
					'tablet' => __('Tablet', 'noorgfx'),
					'mobile' => __('Mobile', 'noorgfx'),
				]),
			],

			'has_cart_badge' => [
				'label' => __( 'Icon Badge', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'yes',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'cart_subtotal_visibility' => [
				'label' => __( 'Label Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'divider' => 'top:full',
				'allow_empty' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'cart_subtotal_visibility/desktop' => true,
						'cart_subtotal_visibility/tablet' => true,
						'cart_subtotal_visibility/mobile' => true,
					]
				],
				'options' => [
					'cart_total_position' => [
						'type' => 'ct-radio',
						'label' => __( 'Label Position', 'noorgfx' ),
						'value' => 'left',
						'view' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'responsive' => [
							'tablet' => 'skip'
						],
						'choices' => [
							'left' => __( 'Left', 'noorgfx' ),
							'right' => __( 'Right', 'noorgfx' ),
							'bottom' => __( 'Bottom', 'noorgfx' ),
						],
					],

					'cart_total_label' => [
						'label' => __( 'Label Text', 'noorgfx' ),
						'type' => 'text',
						'divider' => 'top',
						'design' => 'block',
						'value' => '{price}',
						'responsive' => [
							'tablet' => 'skip'
						],
					],
				],
			],

			'has_empty_cart' => [
				'label' => __( 'Hide Empty Cart', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'no',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'any' => [
						'cart_subtotal_visibility/desktop' => true,
						'cart_subtotal_visibility/tablet' => true,
						'cart_subtotal_visibility/mobile' => true,
					]
				],
				'options' => [
					'cart_total_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Cart Total Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n6',
							'text-transform' => 'uppercase',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Cart Total Font Color', 'noorgfx' ),
						'responsive' => true,
						'choices' => [
							[
								'id' => 'cart_total_font_color',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparent_cart_total_font_color',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'sticky_cart_total_font_color',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [
							'cart_total_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'transparent_cart_total_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],

							'sticky_cart_total_font_color' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Icon Color', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'cartHeaderIconColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentCartHeaderIconColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyCartHeaderIconColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [
					'cartHeaderIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => 'var(--theme-text-color)',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-palette-color-2)',
							],
						],
					],

					'transparentCartHeaderIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickyCartHeaderIconColor' => [
						'label' => __( 'Icon Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],
				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Badge Color', 'noorgfx' ),
				'responsive' => true,
				'divider' => 'top',
				'choices' => [
					[
						'id' => 'cartBadgeColor',
						'label' => __('Default State', 'noorgfx'),
						'condition' => [
							'has_cart_badge' => 'yes',
						],
					],

					[
						'id' => 'transparentCartBadgeColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'has_cart_badge' => 'yes',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyCartBadgeColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'has_cart_badge' => 'yes',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'cartBadgeColor' => [
						'label' => __( 'Badge Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'background' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'text' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Background', 'noorgfx' ),
								'id' => 'background',
								'inherit' => 'var(--theme-palette-color-1)',
							],

							[
								'title' => __( 'Text', 'noorgfx' ),
								'id' => 'text',
								'inherit' => '#ffffff',
							],
						],
					],

					'transparentCartBadgeColor' => [
						'label' => __( 'Badge Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'top',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'background' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'text' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Background', 'noorgfx' ),
								'id' => 'background',
							],

							[
								'title' => __( 'Text', 'noorgfx' ),
								'id' => 'text',
							],
						],
					],

					'stickyCartBadgeColor' => [
						'label' => __( 'Badge Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'divider' => 'top',
						'responsive' => true,
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'background' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'text' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Background', 'noorgfx' ),
								'id' => 'background',
							],

							[
								'title' => __( 'Text', 'noorgfx' ),
								'id' => 'text',
							],
						],
					],

				],
			],

			'headerCartMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],

	'has_cart_dropdown' => [
		'label' => __( 'Cart Drawer', 'noorgfx' ),
		'type' => 'ct-switch',
		'value' => 'yes',
		'wrapperAttr' => [ 'data-label' => 'heading-label' ],
		'setting' => [ 'transport' => 'postMessage' ],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'has_cart_dropdown' => 'yes' ],
		'options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'cart_drawer_type' => [
						'label' => __('Cart Drawer Type', 'noorgfx'),
						'type' => apply_filters(
							'noorgfx:header:cart:cart_drawer_type:option',
							'hidden'
						),
						'value' => 'dropdown',
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
						'choices' => [
							'dropdown' => [
								'src' => noorgfx_image_picker_url('cart-1.svg'),
								'title' => __( 'Dropdown', 'noorgfx' ),
							],

							'offcanvas' => [
								'src' => noorgfx_image_picker_url('cart-2.svg'),
								'title' => __( 'Off Canvas', 'noorgfx' ),
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'cart_drawer_type' => 'dropdown' ],
						'options' => [
							'cartDropdownTopOffset' => [
								'label' => __( 'Dropdown Top Offset', 'noorgfx' ),
								'type' => 'ct-slider',
								'value' => 15,
								'min' => 0,
								'max' => 50,
								'setting' => [ 'transport' => 'postMessage' ],
							],
						]
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'cart_drawer_type' => 'offcanvas' ],
						'options' => [

							'cart_panel_width' => [
								'label' => __( 'Panel Width', 'noorgfx' ),
								'type' => 'ct-slider',
								'value' => [
									'desktop' => '500px',
									'tablet' => '65vw',
									'mobile' => '90vw',
								],
								'units' => noorgfx_units_config([
									[ 'unit' => 'px', 'min' => 0, 'max' => 1000 ],
								]),
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
							],

							'cart_panel_position' => [
								'label' => __('Reveal From', 'noorgfx'),
								'type' => 'ct-radio',
								'value' => 'right',
								'view' => 'text',
								'design' => 'block',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'choices' => [
									'left' => __( 'Left Side', 'noorgfx' ),
									'right' => __( 'Right Side', 'noorgfx' ),
								],
							],

							'auto_open_cart' => [
								'label' => __( 'Open Cart Automatically On', 'noorgfx' ),
								'type' => 'ct-checkboxes',
								'view' => 'text',
								'design' => 'block',
								'divider' => 'top',
								'allow_empty' => true,
								'setting' => ['transport' => 'postMessage'],
								'desc' => __( 'Automatically open the cart drawer after a product is added to cart.', 'noorgfx' ),
								'value' => [
									'archive' => false,
									'product' => false,
								],
								'choices' => noorgfx_ordered_keys([
									'archive' => __('Archive Page', 'noorgfx'),
									'product' => __('Product Page', 'noorgfx'),
								]),
							],

							'has_cart_panel_quantity' => [
								'label' => __( 'Quantity Input', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'no',
								'divider' => 'top',
								'desc' => __( 'Display the quantity input field inside the off-canvas cart panel.', 'noorgfx' ),
							],

						],
					],

					'thumb_ratio' => [
						'label' => __('Image Ratio', 'noorgfx'),
						'type' => 'ct-ratio',
						'view' => 'inline',
						'value' => '1/1',
						'divider' => 'top'
					],

					'image_size' => [
						'label' => __('Image Size', 'noorgfx'),
						'type' => 'ct-select',
						'value' => 'woocommerce_thumbnail',
						'view' => 'text',
						'design' => 'inline',
						'divider' => 'top',
						'choices' => noorgfx_ordered_keys(
							noorgfx_get_all_image_sizes()
						),
					],
				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'cart_drawer_type' => 'dropdown' ],
						'options' => [

							'cartFontColor' => [
								'label' => __( 'Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => '#ffffff',
									],

									'link_initial' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'link_hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Text Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Link Initial', 'noorgfx' ),
										'id' => 'link_initial',
										'inherit' => 'var(--theme-link-initial-color)'
									],

									[
										'title' => __( 'Link Hover', 'noorgfx' ),
										'id' => 'link_hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'cartTotalFontColor' => [
								'label' => __( 'Subtotal Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => '#ffffff',
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],
								],
							],

							'cartDropDownBackground' => [
								'label' => __( 'Background Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => '#29333C',
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'cart_drawer_type' => 'offcanvas' ],
						'options' => [

							'cart_panel_heading_font_color' => [
								'label' => __( 'Panel Heading Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Text Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-headings-color)'
									],
								],
							],

							'cart_panel_font_color' => [
								'label' => __( 'Products Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'divider' => 'top',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'link_initial' => [
										'color' => 'var(--theme-headings-color)',
									],

									'link_hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Text Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],

									[
										'title' => __( 'Link Initial', 'noorgfx' ),
										'id' => 'link_initial',
									],

									[
										'title' => __( 'Link Hover', 'noorgfx' ),
										'id' => 'link_hover',
										'inherit' => 'var(--theme-link-hover-color)'
									],
								],
							],

							'cart_panel_total_font_color' => [
								'label' => __( 'Subtotal Font Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'divider' => 'top',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Text Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-text-color)'
									],
								],
							],

						],
					],

					'mini_cart_image_radius' => [
						'label' => __( 'Image Border Radius', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'value' => noorgfx_spacing_value(),
						'inputAttr' => [
							'placeholder' => '3'
						],
						'min' => 0,
						'sync' => 'live',
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'cart_drawer_type' => 'offcanvas' ],
						'options' => [

							'cart_panel_background' => [
								'label' => __( 'Panel Background', 'noorgfx' ),
								'type'  => 'ct-background',
								'design' => 'block:right',
								'responsive' => true,
								'divider' => 'top:full',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => noorgfx_background_default_value([
									'backgroundColor' => [
										'default' => [
											'color' => 'var(--theme-palette-color-8)'
										],
									],
								])
							],

							'cart_panel_backdrop' => [
								'label' => __( 'Panel Backdrop', 'noorgfx' ),
								'type'  => 'ct-background',
								'design' => 'block:right',
								'responsive' => true,
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'value' => noorgfx_background_default_value([
									'backgroundColor' => [
										'default' => [
											'color' => 'rgba(18, 21, 25, 0.6)'
										],
									],
								])
							],

							'cart_panel_shadow' => [
								'label' => __( 'Panel Shadow', 'noorgfx' ),
								'type' => 'ct-box-shadow',
								'design' => 'block',
								'divider' => 'top',
								'responsive' => true,
								'value' => noorgfx_box_shadow_value([
									'enable' => true,
									'h_offset' => 0,
									'v_offset' => 0,
									'blur' => 70,
									'spread' => 0,
									'inset' => false,
									'color' => [
										'color' => 'rgba(0, 0, 0, 0.35)',
									],
								])
							],

							'cart_panel_close_button_type' => [
								'label' => __('Close Button Type', 'noorgfx'),
								'type' => 'ct-select',
								'value' => 'type-1',
								'view' => 'text',
								'design' => 'inline',
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
								'choices' => noorgfx_ordered_keys(
									[
										'type-1' => __( 'Simple', 'noorgfx' ),
										'type-2' => __( 'Border', 'noorgfx' ),
										'type-3' => __( 'Background', 'noorgfx' ),
									]
								),
							],

							'cart_panel_close_button_color' => [
								'label' => __( 'Icon Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => 'rgba(0, 0, 0, 0.5)',
									],

									'hover' => [
										'color' => 'rgba(0, 0, 0, 0.8)',
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
									],
								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'cart_panel_close_button_type' => 'type-2' ],
								'options' => [

									'cart_panel_close_button_border_color' => [
										'label' => __( 'Border Color', 'noorgfx' ),
										'type'  => 'ct-color-picker',
										'design' => 'block:right',
										'responsive' => true,
										'setting' => [ 'transport' => 'postMessage' ],

										'value' => [
											'default' => [
												'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
											],

											'hover' => [
												'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
											],
										],

										'pickers' => [
											[
												'title' => __( 'Initial', 'noorgfx' ),
												'id' => 'default',
												'inherit' => 'rgba(0, 0, 0, 0.5)'
											],

											[
												'title' => __( 'Hover', 'noorgfx' ),
												'id' => 'hover',
												'inherit' => 'rgba(0, 0, 0, 0.5)'
											],
										],
									],

								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'cart_panel_close_button_type' => 'type-3' ],
								'options' => [

									'cart_panel_close_button_shape_color' => [
										'label' => __( 'Background Color', 'noorgfx' ),
										'type'  => 'ct-color-picker',
										'design' => 'block:right',
										'responsive' => true,
										'setting' => [ 'transport' => 'postMessage' ],

										'value' => [
											'default' => [
												'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
											],

											'hover' => [
												'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
											],
										],

										'pickers' => [
											[
												'title' => __( 'Initial', 'noorgfx' ),
												'id' => 'default',
												'inherit' => 'rgba(0, 0, 0, 0.5)'
											],

											[
												'title' => __( 'Hover', 'noorgfx' ),
												'id' => 'hover',
												'inherit' => 'rgba(0, 0, 0, 0.5)'
											],
										],
									],

								],
							],

							'cart_panel_close_button_icon_size' => [
								'label' => __( 'Icon Size', 'noorgfx' ),
								'type' => 'ct-number',
								'design' => 'inline',
								'value' => 12,
								'min' => 5,
								'max' => 50,
								'divider' => 'top',
								'setting' => [ 'transport' => 'postMessage' ],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [ 'cart_panel_close_button_type' => '!type-1' ],
								'options' => [

									'cart_panel_close_button_border_radius' => [
										'label' => __( 'Border Radius', 'noorgfx' ),
										'type' => 'ct-number',
										'design' => 'inline',
										'value' => 5,
										'min' => 0,
										'max' => 100,
										'divider' => 'top',
										'setting' => [ 'transport' => 'postMessage' ],
									],

								],
							],

							noorgfx_rand_md5() => [
								'type' => 'ct-spacer',
								'height' => 50
							],

						],
					],

				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'header_cart_visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'allow_empty' => true,
				'value' => noorgfx_default_responsive_value([
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

		],
	],
];
