<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
        'options' => array_merge(
			[
				'header_button_type' => [
					'label' => false,
					'type' => 'ct-image-picker',
					'value' => 'type-1',
					'choices' => [

						'type-1' => [
							'src'   => noorgfx_image_picker_file( 'button-1' ),
							'title' => __( 'Default', 'noorgfx' ),
						],

						'type-2' => [
							'src'   => noorgfx_image_picker_file( 'button-2' ),
							'title' => __( 'Ghost', 'noorgfx' ),
						],

					],
				],

				'header_button_size' => [
					'label' => __('Size', 'noorgfx'),
					'type' => 'ct-select',
					'value' => 'small',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'choices' => noorgfx_ordered_keys(
						[
							'default' => __( 'Default', 'noorgfx' ),
							'small' => __( 'Small', 'noorgfx' ),
							'medium' => __( 'Medium', 'noorgfx' ),
							'large' => __( 'Large', 'noorgfx' ),
						]
					),
				],

				'header_button_text' => [
					'label' => __( 'Label Text', 'noorgfx' ),
					'type' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'value' => __( 'Download', 'noorgfx' ),
				],

				'has_header_button_secondary_text' => [
					'label' => __( 'Secondary Label', 'noorgfx' ),
					'type'  => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_header_button_secondary_text' => 'yes' ],
					'options' => [

						'header_button_secondary_text' => [
							'label' => __( 'Label Text', 'noorgfx' ),
							'type' => 'text',
							'design' => 'inline',
							'value' => __( 'Hurry Up!', 'noorgfx' ),
							'divider' => 'bottom',
						],

						'header_button_text_horizontal_alignment' => [
							'type' => 'ct-radio',
							'label' => __( 'Text Alignment', 'noorgfx' ),
							'view' => 'text',
							'design' => 'block',
							'responsive' => true,
							'attr' => [ 'data-type' => 'alignment' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => 'CT_CSS_SKIP_RULE',
							'choices' => [
								'left' => '',
								'center' => '',
								'right' => '',
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'header_button_open' => [
					'label' => __('Click Behavior', 'noorgfx'),
					'type' => (
						function_exists('blc_site_has_feature')
						&&
						blc_site_has_feature('base_pro')
					) ? 'ct-select' : 'hidden',
					'value' => 'link',
					'view' => 'text',
					'design' => 'inline',
					'choices' => [
						'link' => __('Open Link', 'noorgfx'),
						'popup' => __('Open Popup', 'noorgfx'),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'header_button_open' => '!popup' ],
					'options' => [

						'header_button_link' => [
							'label' => __( 'Link/URL', 'noorgfx' ),
							'type' => 'text',
							'design' => 'inline',
							'value' => '#',
						],

						'header_button_target' => [
							'label' => __( 'Open in new tab', 'noorgfx' ),
							'type'  => 'ct-switch',
							'value' => 'no',
							'divider' => 'top',
						],

						'header_button_nofollow' => [
							'type'  => 'ct-switch',
							'label' => __( 'Set link to nofollow', 'noorgfx' ),
							'value' => 'no',
						],

						'header_button_sponsored' => [
							'type'  => 'ct-switch',
							'label' => __( 'Set link to sponsored', 'noorgfx' ),
							'value' => 'no',
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'header_button_open' => 'popup' ],
					'options' => (
						function_exists('blc_get_content_blocks')
						&&
						! empty(blc_get_content_blocks([
							'template_type' => 'popup'
						]))
					) ? [
						'header_button_select_popup' => [
							'label' => __('Popup Template', 'noorgfx' ),
							'type' => 'ct-select',
							'design' => 'inline',
							'value' => '',
							'search' => true,
							'defaultToFirstItem' => false,
							'placeholder' => __('None', 'noorgfx'),
							'choices' => noorgfx_ordered_keys(blc_get_content_blocks([
								'template_type' => 'popup'
							])),
						],
					] : [
						noorgfx_rand_md5() => [
							'type' => 'html',
							'label' => __('Popup Template', 'noorgfx'),
							'value' => '',
							'design' => 'inline',
							'html' => '<a href="' . admin_url('/edit.php?post_type=ct_content_block') .'" target="_blank" class="button" style="width: 130px; text-align: center;">' . __('Create Popup', 'noorgfx') . '</a>',
						],
					],
				],
			],

			apply_filters(
				'noorgfx:header:button:options:after-link-options',
				[]
			),

			$panel_type === 'header' ? [
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
					'options' => [
						'visibility' => [
							'label' => __( 'Element Visibility', 'noorgfx' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'divider' => 'top:full',
							'allow_empty' => true,
							'value' => noorgfx_default_responsive_value([
								'tablet' => true,
								'mobile' => true,
							]),
							'choices' => noorgfx_ordered_keys([
								'tablet' => __( 'Tablet', 'noorgfx' ),
								'mobile' => __( 'Mobile', 'noorgfx' ),
							]),
							'setting' => [ 'transport' => 'postMessage' ],
						],
					],
				],
			] : [],

			$panel_type === 'footer' ? [
				'footer_button_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_button_vertical_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Vertical Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'attr' => [ 'data-type' => 'vertical-alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'visibility' => [
					'label' => __( 'Element Visibility', 'noorgfx' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'sync' => 'live',
					'divider' => 'top',
					'value' => noorgfx_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => noorgfx_ordered_keys([
						'desktop' => __( 'Desktop', 'noorgfx' ),
						'tablet' => __( 'Tablet', 'noorgfx' ),
						'mobile' => __( 'Mobile', 'noorgfx' ),
					]),
				],
			] : [],

			[
				'user_visibility' => [
					'label' => __( 'User Visibility', 'noorgfx' ),
					'type' => 'ct-checkboxes',
					'design' => 'block',
					'view' => 'text',
					'divider' => 'top:full',
					'value' => [
						'logged_in' => true,
						'logged_out' => true,
					],
					'choices' => noorgfx_ordered_keys([
						'logged_in' => __( 'Logged In', 'noorgfx' ),
						'logged_out' => __( 'Logged Out', 'noorgfx' ),
					]),
				],
			],

			[
				'header_button_class' => [
					'label' => __( 'CSS Class', 'noorgfx' ),
					'type' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'value' => '',
					'desc' => __( 'Separate multiple classes with spaces.', 'noorgfx' ),
				],

				'button_aria_label' => [
					'label' => __( 'Custom Aria Label', 'noorgfx' ),
					'type' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'value' => '',
					'desc' => noorgfx_safe_sprintf(
						// translators: placeholder here means the actual URL.
						__( 'Add a custom %saria label%s attribute.', 'noorgfx' ),
						noorgfx_safe_sprintf(
							'<a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-label" target="_blank">'
						),
						'</a>'
					),
				],
			]
		)
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'headerButtonFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Label Text Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([]),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Label Text Color', 'noorgfx' ),
				'divider' => 'bottom',
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerButtonFontColor',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderButtonFontColor',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderButtonFontColor',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerButtonFontColor' => [
						'label' => __( 'Label Text Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'default_2' => [
								'color' => 'var(--theme-button-background-initial-color)',
							],

							'hover_2' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-button-text-initial-color)',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-button-text-hover-color)',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],
						],
					],

					'transparentHeaderButtonFontColor' => [
						'label' => __( 'Label Text Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'default_2' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover_2' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],
						],
					],

					'stickyHeaderButtonFontColor' => [
						'label' => __( 'Label Text Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'default_2' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover_2' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],
						],
					],
				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_header_button_secondary_text' => 'yes' ],
				'options' => [

					'headerButtonSecondaryLabelFont' => [
						'type' => 'ct-typography',
						'label' => __( 'Secondary Label Text Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Secondary Label Text Color', 'noorgfx' ),
						'divider' => 'bottom',
						'responsive' => true,
						'choices' => [
							[
								'id' => 'headerButtonSecondaryFontColor',
								'label' => __('Default State', 'noorgfx')
							],

							[
								'id' => 'transparentHeaderButtonSecondaryFontColor',
								'label' => __('Transparent State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'stickyHeaderButtonSecondaryFontColor',
								'label' => __('Sticky State', 'noorgfx'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [

							'headerButtonSecondaryFontColor' => [
								'label' => __( 'Label Text Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'default_2' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover_2' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],
								],
							],

							'transparentHeaderButtonSecondaryFontColor' => [
								'label' => __( 'Label Text Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'default_2' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover_2' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],
								],
							],

							'stickyHeaderButtonSecondaryFontColor' => [
								'label' => __( 'Label Text Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'default_2' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover_2' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],
								],
							],
						],
					],

				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Button Color', 'noorgfx' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerButtonForeground',
						'label' => __('Default State', 'noorgfx')
					],

					[
						'id' => 'transparentHeaderButtonForeground',
						'label' => __('Transparent State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderButtonForeground',
						'label' => __('Sticky State', 'noorgfx'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerButtonForeground' => [
						'label' => __( 'Button Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-button-background-initial-color)'
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-button-background-hover-color)'
							],
						],
					],

					'transparentHeaderButtonForeground' => [
						'label' => __( 'Button Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],

					'stickyHeaderButtonForeground' => [
						'label' => __( 'Button Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
							],
						],
					],
				],
			],


			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'headerCtaRadius' => [
				'label' => __( 'Border Radius', 'noorgfx' ),
				'type' => 'ct-spacing',
				'value' => noorgfx_spacing_value(),
				'min' => 0,
				'responsive' => true
			],

			'headerCtaPadding' => [
				'label' => __( 'Padding', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'value' => noorgfx_spacing_value(),
				'min' => 0,
				'responsive' => true
			],

			'headerCtaMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'value' => noorgfx_spacing_value(),
				'responsive' => true,
			],

		],
	],
];
