<?php

if (! isset($sidebarId)) {
	$sidebarId = 'ct-footer-sidebar-1';
}

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			'widget' => [
				'type' => 'ct-widget-area',
				'sidebarId' => $sidebarId
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'horizontal_alignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Horizontal Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'responsive' => true,
				'attr' => [ 'data-type' => 'alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'left' => '',
					'center' => '',
					'right' => '',
				],
			],

			'vertical_alignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Vertical Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top',
				'responsive' => true,
				'attr' => [ 'data-type' => 'vertical-alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],
		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'widget_area_colors' => [
				'label' => __( 'Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
					],

					'link_initial' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
					],

					'link_hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Link Initial', 'noorgfx' ),
						'id' => 'link_initial',
					],

					[
						'title' => __( 'Link Hover', 'noorgfx' ),
						'id' => 'link_hover',
					],
				],
			],

			'widgets_link_type' => [
				'type' => 'ct-radio',
				'label' => __( 'Links Decoration', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'inherit',
				'choices' => [
					'none' => __( 'None', 'noorgfx' ),
					'inherit' => __( 'Inherit', 'noorgfx' ),
					'underline' => __( 'Underline', 'noorgfx' ),
				],
			],

			'widget_area_margin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],
];
