<?php

$options = [

	'footer_container_structure' => [
		'label' => __( 'Container Structure', 'noorgfx' ),
		'type' => 'ct-radio',
		'value' => 'fixed',
		'view' => 'text',
		'design' => 'block',
		'choices' => [
			'fixed' => __( 'Default', 'noorgfx' ),
			'boxed' => __( 'Boxed', 'noorgfx' ),
			'fluid' => __( 'Full Width', 'noorgfx' ),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'footer_container_structure' => 'boxed' ],
		'options' => [

			'footer_boxed_offset' => [
				'label' => __( 'Container Bottom Offset', 'noorgfx' ),
				'type' => 'ct-slider',
				'min' => 0,
				'max' => 300,
				'value' => 50,
				'responsive' => true,
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
			],

		],
	],

	'has_reveal_effect' => [
		'label' => __( 'Enable reveal effect on', 'noorgfx' ),
		'desc' => __('Enables a nice reveal effect as you scroll down.', 'noorgfx'),
		'type' => 'ct-visibility',
		'design' => 'block',
		'divider' => 'top:full',
		'allow_empty' => true,
		'setting' => ['transport' => 'postMessage'],
		'value' => noorgfx_default_responsive_value([
			'desktop' => false,
			'tablet' => false,
			'mobile' => false,
		]),
		'choices' => noorgfx_ordered_keys([
			'desktop' => __('Desktop', 'noorgfx'),
			'tablet' => __('Tablet', 'noorgfx'),
			'mobile' => __('Mobile', 'noorgfx'),
		]),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => ['has_reveal_effect:visibility' => 'yes'],
		'options' => [

			'footerShadow' => [
				'label' => __( 'Shadow', 'noorgfx' ),
				'type' => 'ct-box-shadow',
				'responsive' => true,
				'divider' => 'top',
				'hide_shadow_placement' => true,
				'value' => noorgfx_box_shadow_value([
					'enable' => true,
					'h_offset' => 0,
					'v_offset' => 30,
					'blur' => 50,
					'spread' => 0,
					'inset' => false,
					'color' => [
						'color' => 'rgba(0, 0, 0, 0.1)',
					],
				])
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-divider',
	],

	'footerBackground' => [
		'label' => __( 'Container Background', 'noorgfx' ),
		'type' => 'ct-background',
		'design' => 'block:right',
		'responsive' => true,
		'setting' => [ 'transport' => 'postMessage' ],
		'value' => noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => 'var(--theme-palette-color-6)'
				],
			],
		]),
		'desc' => __( 'Please note, you can also change the background color for each row individually.', 'noorgfx' ),
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'footer_container_structure' => '!boxed' ],
		'options' => [

			'footer_spacing' => [
				'label' => __( 'Container Padding', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ 'footer_container_structure' => 'boxed' ],
		'options' => [

			'footer_boxed_spacing' => [
				'label' => __( 'Container Padding', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => [
					'desktop' => noorgfx_spacing_value([
						'top' => '0px',
						'left' => '35px',
						'right' => '35px',
						'bottom' => '0px',
					]),
					'tablet' => noorgfx_spacing_value([
						'top' => '0vw',
						'left' => '4vw',
						'right' => '4vw',
						'bottom' => '0vw',
					]),
					'mobile'=> noorgfx_spacing_value([
						'top' => '0vw',
						'left' => '5vw',
						'right' => '5vw',
						'bottom' => '0vw',
					]),
				],
				'min' => 0,
				'responsive' => true
			],

			'footer_container_border_radius' => [
				'label' => __( 'Container Border Radius', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'min' => 0,
				'responsive' => true
			],

		],
	],

];
