<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Row top & bottom spacing
if (empty($default_top_bottom_spacing)) {
	$default_top_bottom_spacing = [
		'desktop' => '70px',
		'tablet' => '50px',
		'mobile' => '40px',
	];
}

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '> div'
		])
	),
	'variableName' => 'container-spacing',
	'unit' => '',
	'value' => noorgfx_akg(
		'rowTopBottomSpacing',
		$atts,
		$default_top_bottom_spacing
	)
]);


// Columns spacing
$columns_gap = noorgfx_akg( 'footerItemsGap', $atts, 50 );

if ($columns_gap !== 50) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> div'
			])
		),
		'variableName' => 'columns-gap',
		'value' => $columns_gap
	]);
}

$widgets_gap = noorgfx_akg( 'footerWidgetsGap', $atts, 40 );

if ($widgets_gap !== 40) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> div'
			])
		),
		'variableName' => 'widgets-gap',
		'value' => $widgets_gap
	]);
}

// vertical alignment
$vertical_alignment = noorgfx_akg( 'footer_row_vertical_alignment', $atts, 'flex-start' );

if ($vertical_alignment !== 'flex-start') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector(
			noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> div'
			])
		),
		'variableName' => 'vertical-alignment',
		'value' => $vertical_alignment,
		'unit' => '',
	]);
}

// Widgets title font & color
noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'footerWidgetsTitleFont', $atts,
		noorgfx_typography_default_values([
			'size' => '16px',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.widget-title'
		])
	),
]);

noorgfx_output_colors([
	'value' => noorgfx_akg('footerWidgetsTitleColor', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.widget-title'
				])
			),
			'variable' => 'theme-heading-color'
		],
	],
]);

// Widgets font & color
noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'footerWidgetsFont', $atts,
		noorgfx_typography_default_values([
			// 'size' => '16px',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '.ct-widget > *:not(.widget-title)'
		])
	),
]);

// Widgets font color
noorgfx_output_colors([
	'value' => noorgfx_akg('rowFontColor', $atts),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'link_initial' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'link_hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					// 'to_add' => '.ct-widget > *:not(.widget-title)'
					'to_add' => '.ct-widget'
				])
			),
			'variable' => 'theme-text-color'
		],

		'link_initial' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-widget'
				])
			),
			'variable' => 'theme-link-initial-color'
		],

		'link_hover' => [
			'selector' => noorgfx_assemble_selector(
				noorgfx_mutate_selector([
					'selector' => $root_selector,
					'operation' => 'suffix',
					'to_add' => '.ct-widget'
				])
			),
			'variable' => 'theme-link-hover-color'
		],
	],
]);


// Columns divider
noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(
		noorgfx_mutate_selector([
			'selector' => $root_selector,
			'operation' => 'suffix',
			'to_add' => '> div'
		])
	),
	'variableName' => 'theme-border',
	'value' => noorgfx_akg('footerColumnsDivider', $atts),
	'default' => [
		'width' => 1,
		'style' => 'none',
		'color' => [
			'color' => '#dddddd',
		],
	]
]);


// Top border
$footerRowTopBorderFullWidth = noorgfx_akg('footerRowTopBorderFullWidth', $atts, 'no');

$top_has_border_selector = noorgfx_mutate_selector([
	'selector' => $root_selector,
	'operation' => 'suffix',
	'to_add' => '> div'
]);

$top_has_no_border_selector = $root_selector;

if ($footerRowTopBorderFullWidth === 'yes') {
	$top_has_border_selector = $root_selector;

	$top_has_no_border_selector = noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	]);
}

$footerRowTopDividerDefault = [
	'width' => 1,
	'style' => 'none',
	'color' => [
		'color' => '#dddddd',
	],
];
$footerRowTopDivider = noorgfx_akg(
	'footerRowTopDivider',
	$atts,
	$footerRowTopDividerDefault
);

$footerRowTopDivider = noorgfx_expand_responsive_value($footerRowTopDivider);

if (isset($footerRowTopDivider['desktop']) || is_customize_preview()) {
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($top_has_border_selector),
		'variableName' => 'theme-border-top',
		'value' => $footerRowTopDivider,
		'default' => $footerRowTopDividerDefault,
		'responsive' => true
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($top_has_no_border_selector),
		'variableName' => 'theme-border-top',
		'value' => [
			'desktop' => 'none',
			'tablet' => 'none',
			'mobile' => 'none'
		],
		'unit' => ''
	]);
}



// Bottom border
$footerRowBottomBorderFullWidth = noorgfx_akg('footerRowBottomBorderFullWidth', $atts, 'no');

$bottom_has_border_selector = noorgfx_mutate_selector([
	'selector' => $root_selector,
	'operation' => 'suffix',
	'to_add' => '> div'
]);
$bottom_has_no_border_selector = $root_selector;

if ($footerRowBottomBorderFullWidth === 'yes') {
	$bottom_has_border_selector = $root_selector;

	$bottom_has_no_border_selector = noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	]);
}

$footerRowBottomDividerDefault = [
	'width' => 1,
	'style' => 'none',
	'color' => [
		'color' => '#dddddd',
	],
];
$footerRowBottomDivider = noorgfx_akg(
	'footerRowBottomDivider',
	$atts,
	$footerRowBottomDividerDefault
);

$footerRowBottomDivider = noorgfx_expand_responsive_value($footerRowBottomDivider);

if (isset($footerRowBottomDivider['desktop']) || is_customize_preview()) {
	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($bottom_has_border_selector),
		'variableName' => 'theme-border-bottom',
		'value' => $footerRowBottomDivider,
		'default' => $footerRowBottomDividerDefault,
		'responsive' => true
	]);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($bottom_has_no_border_selector),
		'variableName' => 'theme-border-bottom',
		'value' => [
			'desktop' => 'none',
			'tablet' => 'none',
			'mobile' => 'none'
		],
		'unit' => ''
	]);
}

// Row background
if (empty($default_background)) {
	$default_background = noorgfx_background_default_value([
		'backgroundColor' => [
			'default' => [
				'color' => 'transparent'
			],
		],
	]);
}

noorgfx_output_background_css([
	'selector' => noorgfx_assemble_selector($root_selector),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => noorgfx_akg('footerRowBackground', $atts,
		$default_background
	),
	'responsive' => true
]);

$count = count($primary_item['columns']);

$gridTemplate = [
	'desktop' => 'initial',
	'tablet' => 'initial',
	'mobile' => 'initial'
];

if ($count === 2) {
	$gridTemplate = noorgfx_default_akg('2_columns_layout', $atts, [
		'desktop' => 'repeat(2, 1fr)',
		'tablet' => 'initial',
		'mobile' => 'initial'
	]);
}

if ($count === 3) {
	$gridTemplate = noorgfx_default_akg('3_columns_layout', $atts, [
		'desktop' => 'repeat(3, 1fr)',
		'tablet' => 'initial',
		'mobile' => 'initial',
	]);
}

if ($count === 4) {
	$gridTemplate = noorgfx_default_akg('4_columns_layout', $atts, [
		'desktop' => 'repeat(4, 1fr)',
		'tablet' => 'initial',
		'mobile' => 'initial'
	]);
}

if ($count === 5) {
	$gridTemplate = noorgfx_default_akg('5_columns_layout', $atts, [
		'desktop' => 'repeat(5, 1fr)',
		'tablet' => 'initial',
		'mobile' => 'initial'
	]);
}

if ($count === 6) {
	$gridTemplate = noorgfx_default_akg('6_columns_layout', $atts, [
		'desktop' => 'repeat(6, 1fr)',
		'tablet' => 'initial',
		'mobile' => 'initial'
	]);
}

$gridTemplate = noorgfx_expand_responsive_value($gridTemplate);

$mobile_possible_choices = ['initial', 'repeat(2, 1fr)'];

if (! in_array($gridTemplate['tablet'], $mobile_possible_choices)) {
	$gridTemplate['tablet'] = $mobile_possible_choices[0];
}

if (! in_array($gridTemplate['mobile'], $mobile_possible_choices)) {
	$gridTemplate['mobile'] = $mobile_possible_choices[0];
}

$css->put(
	noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	])),
	'--grid-template-columns: ' . $gridTemplate['desktop']
);

$tablet_css->put(
	noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	])),
	'--grid-template-columns: ' . $gridTemplate['tablet']
);

$mobile_css->put(
	noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => '> div'
	])),
	'--grid-template-columns: ' . $gridTemplate['mobile']
);

