<?php

if (! function_exists('noorgfx_assemble_selector')) {
	return;
}

// Items direction
$items_direction = noorgfx_akg('menu_items_direction', $atts, 'horizontal');

if ($items_direction !== 'horizontal') {
	$items_direction = noorgfx_expand_responsive_value($items_direction);

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'menu-item-width',
		'unit' => '',
		'value' => [
			'desktop' => $items_direction['desktop'] === 'vertical' ? '100%' : 'initial',
			'tablet' => $items_direction['tablet'] === 'vertical' ? '100%' : 'initial',
			'mobile' => $items_direction['mobile'] === 'vertical' ? '100%' : 'initial',
		]
	]);
}

// Items spacing
$footerMenuItemsSpacing = noorgfx_akg('footerMenuItemsSpacing', $atts, 25);

if ($footerMenuItemsSpacing !== 25) {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_assemble_selector($root_selector),
		'variableName' => 'menu-items-spacing',
		'value' => $footerMenuItemsSpacing
	]);
}

// Horizontal alignment
noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="' . $item['id'] . '"]'
	])),
	'variableName' => 'horizontal-alignment',
	'value' => noorgfx_akg( 'footerMenuAlignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);

// Vertical alignment
noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'replace-last',
		'to_add' => '[data-column="' . $item['id'] . '"]'
	])),
	'variableName' => 'vertical-alignment',
	'value' => noorgfx_akg( 'footerMenuVerticalAlignment', $atts, 'CT_CSS_SKIP_RULE' ),
	'unit' => '',
]);


// Top level font
noorgfx_output_font_css([
	'font_value' => noorgfx_akg( 'footerMenuFont', $atts,
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n7',
			'line-height' => '1.3',
			'text-transform' => 'uppercase',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
		'selector' => $root_selector,
		'operation' => 'suffix',
		'to_add' => 'ul'
	])),
]);


// Font color
noorgfx_output_colors([
	'value' => noorgfx_akg('footerMenuFontColor', $atts),
	'default' => [
		'default' => [ 'color' => 'var(--theme-text-color)' ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])),
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])),
			'variable' => 'theme-link-hover-color'
		],

		'active' => [
			'selector' => noorgfx_assemble_selector(noorgfx_mutate_selector([
				'selector' => $root_selector,
				'operation' => 'suffix',
				'to_add' => '> ul > li > a'
			])),
			'variable' => 'theme-link-active-color'
		],
	],
]);

// Top level margin
noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_assemble_selector($root_selector),
	'important' => true,
	'value' => noorgfx_default_akg(
		'footerMenuMargin',
		$atts,
		noorgfx_spacing_value()
	)
]);
