<?php

$options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'copyright_text' => [
				'label' => __( 'Copyright Text', 'noorgfx' ),
				'type' => 'wp-editor',
				'value' => apply_filters(
					'noorgfx:footer:copyright:default-value',
					__('Copyright &copy; {current_year} - WordPress Theme by {theme_author}', 'noorgfx')
				),
				'desc' => __( 'You can insert some arbitrary HTML code tags: {current_year}, {site_title} and {theme_author}', 'noorgfx' ),
				'disableRevertButton' => true,
				'setting' => [ 'transport' => 'postMessage' ],
				'mediaButtons' => false,
				'tinymce' => [
					'toolbar1' => 'bold,italic,link,undo,redo',
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'footerCopyrightAlignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Horizontal Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'responsive' => true,
				'attr' => [ 'data-type' => 'alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'left' => '',
					'center' => '',
					'right' => '',
				],
			],

			'footerCopyrightVerticalAlignment' => [
				'type' => 'ct-radio',
				'label' => __( 'Vertical Alignment', 'noorgfx' ),
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top',
				'responsive' => true,
				'attr' => [ 'data-type' => 'vertical-alignment' ],
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => 'CT_CSS_SKIP_RULE',
				'choices' => [
					'flex-start' => '',
					'center' => '',
					'flex-end' => '',
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'footer_copyright_visibility' => [
				'label' => __( 'Element Visibility', 'noorgfx' ),
				'type' => 'ct-visibility',
				'design' => 'block',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_default_responsive_value([
					'desktop' => true,
					'tablet' => true,
					'mobile' => true,
				]),
				'choices' => noorgfx_ordered_keys([
					'desktop' => __( 'Desktop', 'noorgfx' ),
					'tablet' => __( 'Tablet', 'noorgfx' ),
					'mobile' => __( 'Mobile', 'noorgfx' ),
				]),
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'copyrightFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '15px',
					'variation' => 'n4',
					'line-height' => '1.3',
				]),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			'copyrightColor' => [
				'label' => __( 'Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'block:right',
				'responsive' => true,
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'link_initial' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'link_hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-text-color)'
					],

					[
						'title' => __( 'Link Initial', 'noorgfx' ),
						'id' => 'link_initial',
						'inherit' => 'self:default'
					],

					[
						'title' => __( 'Link Hover', 'noorgfx' ),
						'id' => 'link_hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

			'copyrightMargin' => [
				'label' => __( 'Margin', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value(),
				'responsive' => true
			],

		],
	],
];
