<?php

$options = [
	'woo_has_product_tabs' => [
		'label' => __( 'Product Tabs', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'yes',
		'sync' => noorgfx_sync_whole_page([
			'prefix' => 'product',
			'loader_selector' => '.type-product'
		]),
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					[
						'woo_tabs_type' => [
							'label' => false,
							'type' => 'ct-image-picker',
							'value' => 'type-1',
							'divider' => 'bottom:full',
							'choices' => [
								'type-1' => [
									'src' => noorgfx_image_picker_url('woo-tabs-type-1.svg'),
									'title' => __('Type 1', 'noorgfx'),
								],
	
								'type-2' => [
									'src' => noorgfx_image_picker_url('woo-tabs-type-2.svg'),
									'title' => __('Type 2', 'noorgfx'),
								],
	
								'type-3' => [
									'src' => noorgfx_image_picker_url('woo-tabs-type-3.svg'),
									'title' => __('Type 3', 'noorgfx'),
								],
	
								'type-4' => [
									'src' => noorgfx_image_picker_url('woo-tabs-type-4.svg'),
									'title' => __('Type 4', 'noorgfx'),
								],
							],
							'sync' => noorgfx_sync_whole_page([
								'prefix' => 'product',
								'loader_selector' => '.woocommerce-tabs'
							]),
						],
	
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_tabs_type' => 'type-1|type-2' ],
							'options' => [
	
								'woo_tabs_alignment' => [
									'type' => 'ct-radio',
									'label' => __( 'Horizontal Alignment', 'noorgfx' ),
									'view' => 'text',
									'design' => 'block',
									'divider' => 'bottom',
									'attr' => [ 'data-type' => 'alignment' ],
									'setting' => [ 'transport' => 'postMessage' ],
									'value' => 'center',
									'choices' => [
										'left' => '',
										'center' => '',
										'right' => '',
									],
								],
	
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 
								'woo_tabs_type' => 'type-3|type-4',
							],
							'options' => [

								'woo_accordion_in_summary' => [
									'label' => __('Module Placement', 'noorgfx'),
									'type' => 'ct-radio',
									'value' => 'default',
									'view' => 'text',
									'divider' => 'bottom',
									'choices' => [
										'default' => __('Default', 'noorgfx'),
										'summary' => __('Summary', 'noorgfx'),
									],

									'sync' => noorgfx_sync_whole_page([
										'prefix' => 'product',
										'loader_selector' => '.product'
									]),
								],
	
							],
						],
	
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_tabs_type' => 'type-3' ],
							'options' => [
	
								'woo_accordion_closed_by_default' => [
									'label' => __( 'First Tab Expanded', 'noorgfx' ),
									'type' => 'ct-switch',
									'switch' => true,
									'value' => 'yes',
									// 'divider' => 'top',
									'sync' => noorgfx_sync_whole_page([
										'prefix' => 'product',
										'loader_selector' => '.woocommerce-tabs'
									]),
								],

								'woo_accordion_close_prev' => [
									'label' => __( 'Close Adjacent Tabs', 'noorgfx' ),
									'type' => 'ct-switch',
									'switch' => true,
									'value' => 'yes',
									// 'divider' => 'top',
									'sync' => noorgfx_sync_whole_page([
										'prefix' => 'product',
										'loader_selector' => '.woocommerce-tabs'
									]),
								],
	
							],
						],
	
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_tabs_type' => '!type-4' ],
							'options' => [
								'woo_has_product_tabs_description' => [
									'label' => __( 'Description Heading ', 'noorgfx' ),
									'type' => 'ct-switch',
									'switch' => true,
									'value' => 'no',
									// 'divider' => 'top',
									'sync' => noorgfx_sync_whole_page([
										'prefix' => 'product',
										'loader_selector' => '.woocommerce-tabs'
									]),
								],
							]
						],

					],

					apply_filters('noorgfx:options:woo:tabs:general:brands', []),

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'woo_tabs_type' => 'type-4' ],
							'options' => [
	
								'woo_separated_tabs_spacing' => [
									'label' => __( 'Items Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 200,
									'value' => 50,
									'divider' => 'top',
									'responsive' => true,
									'setting' => [ 'transport' => 'postMessage' ],
								],
	
							],
						],
					],
				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'woo_tabs_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '12px',
							'variation' => 'n6',
							'text-transform' => 'uppercase',
							'line-height' => '1',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'woo_tabs_font_color' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'sync' => 'live',
						'value' => [
							'default' => [
								'color' => 'var(--theme-text-color)',
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)',
								'condition' => [ 'woo_tabs_type' => '!type-4' ]
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'self:hover',
								'condition' => [ 'woo_tabs_type' => '!type-4' ]
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'woo_tabs_type' => '!type-4' ],
						'options' => [

							'woo_tabs_border_color' => [
								'label' => __( 'Border Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'divider' => 'top',
								'sync' => 'live',
								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-border-color)'
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'woo_tabs_type' => 'type-1' ],
						'options' => [

							'woo_actibe_tab_border' => [
								'label' => __( 'Active Tab Border', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'divider' => 'top',
								'sync' => 'live',
								'value' => [
									'default' => [
										'color' => 'var(--theme-palette-color-1)',
									],
								],

								'pickers' => [
									[
										'title' => __( 'Active', 'noorgfx' ),
										'id' => 'default',
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'woo_tabs_type' => 'type-2' ],
						'options' => [

							'woo_actibe_tab_background' => [
								'label' => __( 'Active Tab Colors', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'inline',
								'divider' => 'top',
								'sync' => 'live',
								'value' => [
									'default' => [
										'color' => 'rgba(242, 244, 247, 0.7)',
									],

									'border' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Background', 'noorgfx' ),
										'id' => 'default',
									],

									[
										'title' => __( 'Border', 'noorgfx' ),
										'id' => 'border',
										'inherit' => 'var(--theme-border-color)'
									],
								],
							],

						],
					],

				],
			],

		],
	],

];
