<?php

$is_pro = function_exists('blc_site_has_feature') && blc_site_has_feature('base_pro');

$payment_method_options = [
	'item_visa' => [
		'label' => __('Visa', 'noorgfx'),
	],

	'item_mastercard' => [
		'label' => __('Mastercard', 'noorgfx'),
	],

	'item_amex' => [
		'label' => __('Amex', 'noorgfx'),
	],

	'item_discover' => [
		'label' => __('Discover', 'noorgfx'),
	],

	'item_paypal' => [
		'label' => __('PayPal', 'noorgfx'),
	],

	'item_apple_pay' => [
		'label' => __('Apple Pay', 'noorgfx'),
	],

	'item_google_pay' => [
		'label' => __('Google Pay', 'noorgfx'),
	],
];

$payment_method_options = array_merge(
	$payment_method_options,
	$is_pro ? [
		'custom_link' => [
			'label' => noorgfx_safe_sprintf(
				__('%s', 'noorgfx'),
				__('Custom', 'noorgfx')
			),
			'clone' => 4,
		]
	] : []
);

$additional_info_options = [
	'additional_info_item' => [
		'label' => noorgfx_safe_sprintf('<%%= item_title || "%s" %%>', __('Item Label', 'noorgfx')),
		'clone' => 10,
		'options' => [
			$is_pro ? [
				'icon_source' => [
					'label' => __( 'Icon Source', 'noorgfx' ),
					'type' => 'ct-radio',
					'value' => 'default',
					'view' => 'text',
					'design' => 'block',
					'choices' => [
						'default' => __( 'Default', 'noorgfx' ),
						'custom' => __( 'Custom', 'noorgfx' ),
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['icon_source' => 'custom'],
					'options' => [
						'icon' => [
							'type' => 'icon-picker',
							'label' => __('Icon', 'noorgfx'),
							'design' => 'inline',
							'value' => [
								'icon' => 'fas fa-check'
							]
						]
					]
				],
			]: [],

			'item_title' => [
				'label' => __('Title', 'noorgfx'),
				'type' => 'text',
				'design' => 'block',
				'value' => 'Test text',
				'disableRevertButton' => true,
				'sync' => [
					'id' => 'woo_single_layout_skip'
				]
			],
		]
	]
];

if ($is_pro) {
	foreach ($payment_method_options as $key => $method) {
		$payment_method_options[$key]['options'] = [
			'icon_source' => [
				'label' => __( 'Icon Source', 'noorgfx' ),
				'type' => 'ct-radio',
				'value' => 'default',
				'view' => 'text',
				'design' => 'block',
				'choices' => [
					'default' => __( 'Default', 'noorgfx' ),
					'custom' => __( 'Custom', 'noorgfx' ),
				]
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['icon_source' => 'custom'],
				'options' => [
					'icon' => [
						'type' => 'icon-picker',
						'label' => __('Icon', 'noorgfx'),
						'design' => 'inline',
						'value' => [
							'icon' => 'blc blc-user'
						]
					]
				]
			]
		];
	}
}

$options = apply_filters(
	'noorgfx_woo_single_options_layers:extra',
	[
		'product_breadcrumbs' => [
			'label' => __('Breadcrumbs', 'noorgfx'),
			'options' => [
				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'product_title' => [
			'label' => __('Title', 'noorgfx'),
			'options' => [
				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'product_rating' => [
			'label' => __('Star Rating', 'noorgfx'),
			'options' => [
				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'product_price' => [
			'label' => __('Price', 'noorgfx'),
			'options' => apply_filters(
				'noorgfx:single-product-layer:options:product_price',
				[
					[
						'spacing' => [
							'label' => __( 'Bottom Spacing', 'noorgfx' ),
							'type' => 'ct-slider',
							'min' => 0,
							'max' => 100,
							'value' => 35,
							'responsive' => true,
							'sync' => [
								'id' => 'woo_single_layout_skip'
							],
						],
					]
				],
				'blc blc-feather'
			),
		],

		'product_desc' => [
			'label' => __('Short Description', 'noorgfx'),
			'options' => [
				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 35,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'divider' => [
			'label' => __('Divider', 'noorgfx'),
			'clone' => 5,
			'options' => [
				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 35,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'product_add_to_cart' => [
			'label' => __('Add to Cart', 'noorgfx'),
			'options' => [

				'add_to_cart_layer_title' => [
					'label' => __('Title', 'noorgfx'),
					'type' => 'text',
					'design' => 'block',
					'value' => '',
					'disableRevertButton' => true,
					'sync' => [
						'id' => 'woo_card_layout_skip'
					],
				],

				'add_to_cart_button_width' => [
					'label' => __('Button Width', 'noorgfx'),
					'type' => 'ct-slider',
					'value' => '100%',
					'units' => noorgfx_units_config([
						['unit' => '%', 'min' => 30, 'max' => 100],
					]),
					'responsive' => true,
					'setting' => ['transport' => 'postMessage'],
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],

				'add_to_cart_button_height' => [
					'label' => __('Button Height', 'noorgfx'),
					'type' => 'ct-slider',
					'min' => 20,
					'max' => 100,
					'value' => [
						'mobile' => 40,
						'tablet' => 55,
						'desktop' => 55,
					],
					'responsive' => true,
					'setting' => [ 'transport' => 'postMessage' ],
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],

				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 35,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'product_meta' => [
			'label' => __('Meta', 'noorgfx'),
			'options' => [
				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			],
		],

		'product_payment_methods' => [
			'label' => __('Payment Methods', 'noorgfx'),
			'sync' => [
				'id' => 'product_payment_methods',
			],
			'options' => [

				'payment_methods_title' => [
					'label' => __('Title', 'noorgfx'),
					'type' => 'text',
					'design' => 'block',
					'value' => __('Guaranteed Safe Checkout', 'noorgfx'),
					'disableRevertButton' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],

				'payment_items' => [
					'label' => false,
					'type' => 'ct-layers',
					'itemClass' => 'ct-inner-layer',
					'value' => [
						[
							'id' => 'item_visa',
							'enabled' => true,
							'label' => __('Visa', 'noorgfx'),
						],

						[
							'id' => 'item_mastercard',
							'enabled' => true,
							'label' => __('Mastercard', 'noorgfx'),
						],

						[
							'id' => 'item_amex',
							'enabled' => true,
							'label' => __('Amex', 'noorgfx'),
						],

						[
							'id' => 'item_discover',
							'enabled' => true,
							'label' => __('Discover', 'noorgfx'),
						],
					],
					'manageable' => true,
					'sync' => 'live',
					'settings' => $payment_method_options
				],

				'payment_icons_size' => [
					'label' => __( 'Icon Size', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 5,
					'max' => 100,
					'value' => 40,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],

				'payment_icons_color' => [
					'label' => __('Icons Color', 'noorgfx'),
					'type' => 'ct-radio',
					'value' => 'default',
					'view' => 'text',
					'design' => 'block',
					'choices' => [
						'default' => __( 'Default', 'noorgfx' ),
						'custom' => __( 'Custom', 'noorgfx' ),
					],
					'sync' => [
						'id' => 'product_payment_methods',
					],
				],

				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],

			],
		],

		'additional_info' => [
			'label' => __('Reasons to Buy', 'noorgfx'),
			'options' => [
				'product_additional_info_title' => [
					'label' => __('Title', 'noorgfx'),
					'type' => 'text',
					'design' => 'block',
					'value' => __('Extra Features', 'noorgfx'),
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
				'additional_info_items' => [
					'label' => __('Items', 'noorgfx'),
					'type' => 'ct-layers',
					'itemClass' => 'ct-inner-layer',
					'manageable' => false,
					'forcedRevertButton' => true,
					'value' => [
						[
							'id' => 'additional_info_item',
							'enabled' => true,
							'item_title' => __('Premium Quality', 'noorgfx')
						],
						[
							'id' => 'additional_info_item',
							'enabled' => true,
							'item_title' => __('Secure Payments', 'noorgfx')
						],
						[
							'id' => 'additional_info_item',
							'enabled' => true,
							'item_title' => __('Satisfaction Guarantee', 'noorgfx')
						],
						[
							'id' => 'additional_info_item',
							'enabled' => true,
							'item_title' => __('Worldwide Shipping', 'noorgfx')
						],
						[
							'id' => 'additional_info_item',
							'enabled' => true,
							'item_title' => __('Money Back Guarantee', 'noorgfx')
						],
					],
					'settings' => $additional_info_options
				],

				'spacing' => [
					'label' => __( 'Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'min' => 0,
					'max' => 100,
					'value' => 10,
					'responsive' => true,
					'sync' => [
						'id' => 'woo_single_layout_skip'
					],
				],
			]
		],
	]
);

