<?php

$page_title_options = noorgfx_get_options('general/page-title', [
	'prefix' => 'product',
	'is_single' => true,
	'enabled_label' => __('Product Title', 'noorgfx'),
	'location_name' => __('Single Product', 'noorgfx'),
]);

$options = [
	'woo_single_section_options' => [
		'type' => 'ct-options',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [
			noorgfx_manager()->get_prefix_title_actions([
				'prefix' => 'product',
				'areas' => [
					[
						'title' => __('Page Title', 'noorgfx'),
						'options' => $page_title_options,
						'sources' => array_merge(
							noorgfx_manager()
								->screen
								->get_archive_prefixes_with_human_labels([
									'has_categories' => true,
									'has_author' => true,
									'has_search' => true,
									'has_woocommerce' => true
								]),

								noorgfx_manager()
									->screen
									->get_single_prefixes_with_human_labels([
										'has_woocommerce' => true
									])
						)
					]
				]
			]),

			$page_title_options,

			[
				noorgfx_rand_md5() => [
					'type'  => 'ct-title',
					'label' => __( 'Page Structure', 'noorgfx' ),
				],

				noorgfx_rand_md5() => [
					'title' => __( 'General', 'noorgfx' ),
					'type' => 'tab',
					'options' => [
						noorgfx_get_options('single-elements/structure', [
							'prefix' => 'product',
							'default_structure' => 'type-4',
							'has_v_spacing' => true
						]),
					],
				],

				noorgfx_rand_md5() => [
					'title' => __( 'Design', 'noorgfx' ),
					'type' => 'tab',
					'options' => [
						noorgfx_get_options('single-elements/structure-design', [
							'prefix' => 'product',
						]),
					],
				],
			],

			apply_filters(
				'noorgfx:options:single_product:product-elements:end',
				[]
			),

			[
				noorgfx_rand_md5() => [
					'type'  => 'ct-title',
					'label' => __( 'Page Elements', 'noorgfx' ),
				],
			],

			noorgfx_get_options('woocommerce/single-product-gallery'),

			noorgfx_get_options('woocommerce/single-product-elements'),

			apply_filters(
				'noorgfx_single_product_floating_cart',
				[]
			),

			noorgfx_get_options('woocommerce/single-product-tabs'),

			noorgfx_get_options('woocommerce/related-upsells'),

			[
				noorgfx_rand_md5() => [
					'type'  => 'ct-title',
					'label' => __( 'Functionality Options', 'noorgfx' ),
				],

				'has_ajax_add_to_cart' => [
					'label' => __('AJAX Add To Cart', 'noorgfx'),
					'type' => 'ct-switch',
					'value' => 'yes',
				],
			],
		],
	],
];
