<?php

$options = [
	'has_shop_results_count' => [
		'label' => __( 'Results Count', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'yes',
		'sync' => noorgfx_sync_whole_page([
			'prefix' => 'woo_categories',
			'loader_selector' => '.woo-listing-top'
		]),
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'shop_results_count_visibility' => [
						'label' => __('Visibility', 'noorgfx'),
						'type' => 'ct-visibility',
						'design' => 'block',
						'divider' => 'top',
						'setting' => ['transport' => 'postMessage'],
						'allow_empty' => true,
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => false,
						]),

						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'shop_results_count_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Font', 'noorgfx' ),
						'value' => noorgfx_typography_default_values([
							'size' => '11px',
							'variation' => 'n5',
							'letter-spacing' => '0.05em',
							'text-transform' => 'uppercase'
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					'shop_results_count_color' => [
						'label' => __( 'Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],
						],
					],

				],
			],

		],
	],
];