<?php
/**
 * Messages options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	noorgfx_rand_md5() => [
		'label' => __('Messages', 'noorgfx'),
		'type' => 'ct-panel',
		'setting' => ['transport' => 'postMessage'],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Info Messages', 'noorgfx' ),
			],

			'info_message_text_color' => [
				'label' => __( 'Text Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => 'var(--theme-text-color)',
					],

					'hover' => [
						'color' => 'var(--theme-link-hover-color)',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
					],
				],
			],

			'info_message_background_color' => [
				'label' => __( 'Background Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => '#F0F1F3',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],
				],
			],

			'info_message_button_text_color' => [
				'label' => __( 'Button Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',
				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-button-text-initial-color)',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-button-text-hover-color)',
					],
				],
			],

			'info_message_button_background' => [
				'label' => __( 'Button Background Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',
				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-button-background-initial-color)'
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-button-background-hover-color)'
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Success Messages', 'noorgfx' ),
			],

			'success_message_text_color' => [
				'label' => __( 'Text Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-text-color)'
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

			'success_message_background_color' => [
				'label' => __( 'Background Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => '#F0F1F3',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],
				],
			],

			'success_message_button_text_color' => [
				'label' => __( 'Button Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',
				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-button-text-initial-color)',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-button-text-hover-color)',
					],
				],
			],

			'success_message_button_background' => [
				'label' => __( 'Button Background Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',
				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-button-background-initial-color)'
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-button-background-hover-color)'
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Error Messages', 'noorgfx' ),
			],

			'error_message_text_color' => [
				'label' => __( 'Text Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => '#ffffff',
					],

					'hover' => [
						'color' => '#ffffff',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
					],
				],
			],

			'error_message_background_color' => [
				'label' => __( 'Background Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],

				'value' => [
					'default' => [
						'color' => 'rgba(218, 0, 28, 0.7)',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],
				],
			],

			'error_message_button_text_color' => [
				'label' => __( 'Button Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',
				'value' => [
					'default' => [
						'color' => '#ffffff',
					],

					'hover' => [
						'color' => '#ffffff',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
					],
				],
			],

			'error_message_button_background' => [
				'label' => __( 'Button Background Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',
				'value' => [
					'default' => [
						'color' => '#b92c3e',
					],

					'hover' => [
						'color' => '#9c2131',
					],
				],

				'pickers' => [
					[
						'title' => __( 'Initial', 'noorgfx' ),
						'id' => 'default',
					],

					[
						'title' => __( 'Hover', 'noorgfx' ),
						'id' => 'hover',
					],
				],
			],

		],
	],

];