<?php
/**
 * Cart page options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	noorgfx_rand_md5() => [
		'label' => __('Cart Page', 'noorgfx'),
		'type' => 'ct-panel',
		'setting' => ['transport' => 'postMessage'],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					apply_filters(
						'noorgfx_customizer_options:woocommerce:cart_page:before',
						[]
					),

					'cart_page_image_ratio' => [
						'label' => __('Image Ratio', 'noorgfx'),
						'type' => 'ct-ratio',
						'view' => 'inline',
						'value' => '1/1',
						'divider' => 'top:full',
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-cart-form .woocommerce-cart-form'
						]),
					],

					'cart_page_image_size' => [
						'label' => __('Image Size', 'noorgfx'),
						'type' => 'ct-select',
						'value' => 'woocommerce_thumbnail',
						'view' => 'text',
						'design' => 'inline',
						'divider' => 'top',
						'choices' => noorgfx_ordered_keys(
							noorgfx_get_all_image_sizes()
						),
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-cart-form .woocommerce-cart-form'
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'cart_totals_border' => [
						'label' => __( 'Cart Totals Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'sync' => 'live',
						'value' => [
							'width' => 2,
							'style' => 'solid',
							'color' => [
								'color' => 'var(--theme-border-color)',
							],
						],
						'responsive' => true,
					],

					'cart_totals_border_radius' => [
						'label' => __( 'Cart Totals Border Radius', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => noorgfx_spacing_value(),
						'min' => 0,
						'responsive' => true,
					],

					'cart_totals_padding' => [
						'label' => __( 'Cart Totals Padding', 'noorgfx' ),
						'type' => 'ct-spacing',
						'divider' => 'top',
						'value' => [
							'desktop' => noorgfx_spacing_value([
								'top' => '30px',
								'left' => '30px',
								'right' => '30px',
								'bottom' => '30px',
							]),
							'tablet' => noorgfx_spacing_value([
								'top' => '25px',
								'left' => '25px',
								'right' => '25px',
								'bottom' => '25px',
							]),
							'mobile'=> noorgfx_spacing_value([
								'top' => '25px',
								'left' => '25px',
								'right' => '25px',
								'bottom' => '25px',
							]),
						],
						'min' => 0,
						'responsive' => true,
						'sync' => 'live',
					],

				],
			],

		]
	],

];