<?php
/**
 * Account page options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	noorgfx_rand_md5() => [
		'label' => __('Account Page', 'noorgfx'),
		'type' => 'ct-panel',
		'setting' => ['transport' => 'postMessage'],
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'has_account_page_avatar' => [
						'label' => __( 'User Avatar', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'sync' => noorgfx_sync_whole_page([
							'prefix' => 'single_page',
							'loader_selector' => '.ct-woo-account'
						]),
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'has_account_page_avatar' => 'yes' ],
						'options' => [

							'account_page_avatar_size' => [
								'label' => __( 'Avatar Size', 'noorgfx' ),
								'type' => 'ct-number',
								'design' => 'inline',
								'value' => 35,
								'min' => 20,
								'max' => 100,
								'divider' => 'bottom',
								'setting' => [ 'transport' => 'postMessage' ],
							],
						],
					],

					'has_account_page_name' => [
						'label' => __( 'User Name', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'sync' => noorgfx_sync_whole_page([
							'prefix' => 'single_page',
							'loader_selector' => '.ct-woo-account'
						]),
					],

					'has_account_page_quick_actions' => [
						'label' => __( 'Navigation Quick Links', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
						'sync' => noorgfx_sync_whole_page([
							'prefix' => 'single_page',
							'loader_selector' => '.ct-woo-account'
						]),
					],
				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					'account_nav_text_color' => [
						'label' => __( 'Navigation Text Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-palette-color-3)'
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => '#ffffff'
							],
						],
					],

					'account_nav_background_color' => [
						'label' => __( 'Navigation Background Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'active' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => '#ffffff'
							],

							[
								'title' => __( 'Active', 'noorgfx' ),
								'id' => 'active',
								'inherit' => 'var(--theme-palette-color-1)'
							],
						],
					],

					'account_nav_divider_color' => [
						'label' => __( 'Navigation Divider Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'inline',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'rgba(0, 0, 0, 0.05)'
							],
						],
					],

					'account_nav_shadow' => [
						'label' => __( 'Navigation Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'design' => 'inline',
						'sync' => 'live',
						// 'responsive' => true,
						'divider' => 'top',
						'value' => noorgfx_box_shadow_value([
							'enable' => false,
							'h_offset' => 0,
							'v_offset' => 10,
							'blur' => 20,
							'spread' => 0,
							'inset' => false,
							'color' => [
								'color' => 'rgba(0, 0, 0, 0.03)',
							],
						])
					],

				],
			],

		],
	],

];