<?php

if (! isset($structure_label)) {
	$structure_label = false;
}

if (! isset($has_v_spacing)) {
	$has_v_spacing = true;
}

if (! isset($has_content_style)) {
	$has_content_style = true;
}

if (! isset($default_structure)) {
	$default_structure = 'type-3';
}

if (! isset($default_content_style)) {
	$default_content_style = 'wide';
}

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

$structure_choices = [
	'type-3' => [
		'src' => noorgfx_image_picker_url('narrow.svg'),
		'title' => __('Narrow Width', 'noorgfx'),
	],

	'type-4' => [
		'src' => noorgfx_image_picker_url('normal.svg'),
		'title' => __('Normal Width', 'noorgfx'),
	],

	'type-2' => [
		'src' => noorgfx_image_picker_url('left-single-sidebar.svg'),
		'title' => __('Left Sidebar', 'noorgfx'),
	],

	'type-1' => [
		'src' => noorgfx_image_picker_url('right-single-sidebar.svg'),
		'title' => __('Right Sidebar', 'noorgfx'),
	]
];

if (! isset($skipped_structure)) {
	$skipped_structure = [];
}

foreach ($skipped_structure as $structure) {
	unset($structure_choices[$structure]);
}

$options = [
	[
		$prefix . 'structure' => [
			'label' => $structure_label,
			'type' => 'ct-image-picker',
			'value' => $default_structure,
			'choices' => $structure_choices,
			'sync' => noorgfx_sync_whole_page([
				'prefix' => $prefix,
				'prefix_custom' => 'single-structure',
				'loader_selector' => '[class*="ct-container"]'
			]),
		],

	],

	$has_content_style ? [
		$prefix . 'content_style' => [
			'label' => __('Content Area Style', 'noorgfx'),
			'type' => 'ct-radio',
			'value' => $default_content_style,
			'view' => 'text',
			'design' => 'block',
			'divider' => 'top',
			'responsive' => true,
			'choices' => [
				'wide' => __( 'Wide', 'noorgfx' ),
				'boxed' => __( 'Boxed', 'noorgfx' ),
			],
			'sync' => 'live'
		],
	] : [],

	$has_v_spacing ? [
		$prefix . 'content_area_spacing' => [
			'label' => __( 'Content Area Vertical Spacing', 'noorgfx' ),
			'type' => 'ct-radio',
			'value' => 'both',
			'view' => 'text',
			'design' => $has_v_spacing ? 'block' : 'inline',
			'divider' => 'top',
			'attr' => [ 'data-type' => 'content-spacing' ],
			'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
			'sync' => "live",
			'choices' => [
				'both'   => '<span></span>
				<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx' ) . '</i>',

				'top'    => '<span></span>
				<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx' ) . '</i>',

				'bottom' => '<span></span>
				<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx' ) . '</i>',

				'none'   => '<span></span>
				<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx' ) . '</i>',
			],
			'desc' => noorgfx_safe_sprintf(
				// translators: placeholder here means the actual URL.
				__( 'You can customize the global spacing value in General ➝ Layout ➝ %sContent Area Spacing%s.', 'noorgfx' ),
				noorgfx_safe_sprintf(
					'<a data-trigger-section="general:layout_panel" href="%s">',
					admin_url('/customize.php?autofocus[section]=general&ct_autofocus=general:layout_panel')
				),
				'</a>'
			),
		],
	] : []
];

