<?php

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

$options = [
	$prefix . 'has_author_box' => [
		'label' => __( 'Author Box', 'noorgfx' ),
		'type' => 'ct-panel',
		'switch' => true,
		'value' => 'no',
		'sync' => noorgfx_sync_single_post_container([
			'prefix' => $prefix
		]),
		'inner-options' => [

			noorgfx_rand_md5() => [
				'title' => __( 'General', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					$prefix . 'single_author_box_type' => [
						'label' => __('Box Type', 'noorgfx'),
						'type' => 'ct-image-picker',
						'value' => 'type-2',
						'attr' => ['data-type' => 'background'],
						'sync' => [
							'prefix' => $prefix,
							'selector' => '.author-box',
							'render' => function () {
								if (have_posts()) {
									the_post();
								}

								noorgfx_author_box();
							}
						],
						'choices' => [
							'type-1' => [
								'src' => noorgfx_image_picker_url('author-box-type-1.svg'),
								'title' => __('Type 1', 'noorgfx'),
							],

							'type-2' => [
								'src' => noorgfx_image_picker_url('author-box-type-2.svg'),
								'title' => __('Type 2', 'noorgfx'),
							],
						],
					],

					$prefix . 'single_author_box_name_heading' => [
						'label' => __( 'Author Name Tag', 'noorgfx' ),
						'type' => 'ct-select',
						'value' => 'h5',
						'view' => 'text',
						'design' => 'inline',
						'divider' => 'top',
						'choices' => noorgfx_ordered_keys(
							[
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'div' => 'div',
							]
						),
						'sync' => [
							'prefix' => $prefix,
							'selector' => '.author-box',
							'loader_selector' => '.author-box-name',
							'render' => function () {
								if (have_posts()) {
									the_post();
								}

								noorgfx_author_box();
							}
						],
					],

					$prefix . 'single_author_box_posts_count' => [
						'label' => __( 'Posts Count', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'divider' => 'top',
						'sync' => [
							'prefix' => $prefix,
							'selector' => '.author-box',
							'render' => function () {
								if (have_posts()) {
									the_post();
								}

								noorgfx_author_box();
							}
						],
					],

					$prefix . 'single_author_box_archive_link' => [
						'label' => __( 'Author Archive Link', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'divider' => 'top',
						'sync' => [
							'prefix' => $prefix,
							'selector' => '.author-box',
							'render' => function () {
								if (have_posts()) {
									the_post();
								}

								noorgfx_author_box();
							}
						],
					],

					$prefix . 'single_author_box_social' => [
						'label' => __( 'Social Icons', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'desc' => noorgfx_safe_sprintf(
							// translators: placeholder here is the link URL.
							__(
								'You can set the author social channels %shere%s.',
								'noorgfx'
							),
							noorgfx_safe_sprintf(
								'<a href="%s" target="_blank">',
								admin_url('/profile.php')
							),
							'</a>'
						),
						'divider' => 'top:full',
						'sync' => [
							'prefix' => $prefix,
							'selector' => '.author-box',
							'render' => function () {
								if (have_posts()) {
									the_post();
								}

								noorgfx_author_box();
							}
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ $prefix . 'single_author_box_social' => 'yes' ],
						'options' => [

							$prefix . 'single_author_box_social_link_target' => [
								'type'  => 'ct-switch',
								'label' => __( 'Open links in new tab', 'noorgfx' ),
								'value' => 'no',
								'sync' => [
									'prefix' => $prefix,
									'selector' => '.author-box',
									'render' => function () {
										if (have_posts()) {
											the_post();
										}

										noorgfx_author_box();
									}
								],
							],

							$prefix . 'single_author_box_social_link_nofollow' => [
								'type'  => 'ct-switch',
								'label' => __( 'Set links to nofollow', 'noorgfx' ),
								'value' => 'no',
								'sync' => [
									'prefix' => $prefix,
									'selector' => '.author-box',
									'render' => function () {
										if (have_posts()) {
											the_post();
										}

										noorgfx_author_box();
									}
								],
							],

						],
					],

					$prefix . 'single_author_box_spacing' => [
						'label' => __( 'Container Inner Spacing', 'noorgfx' ),
						'type' => 'ct-slider',
						'value' => '40px',
						'units' => noorgfx_units_config([
							[ 'unit' => 'px', 'min' => 0, 'max' => 100],
							['unit' => '', 'type' => 'custom'],
						]),
						'responsive' => true,
						'divider' => 'top:full',
						'sync' => 'live'
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					$prefix . 'author_box_visibility' => [
						'label' => __( 'Visibility', 'noorgfx' ),
						'type' => 'ct-visibility',
						'design' => 'block',
						'sync' => 'live',
						'value' => noorgfx_default_responsive_value([
							'desktop' => true,
							'tablet' => true,
							'mobile' => false,
						]),
						'choices' => noorgfx_ordered_keys([
							'desktop' => __( 'Desktop', 'noorgfx' ),
							'tablet' => __( 'Tablet', 'noorgfx' ),
							'mobile' => __( 'Mobile', 'noorgfx' ),
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'title' => __( 'Design', 'noorgfx' ),
				'type' => 'tab',
				'options' => [

					$prefix . 'single_author_box_name_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Author Name Font', 'noorgfx' ),
						'sync' => 'live',
						'value' => noorgfx_typography_default_values([]),
					],

					$prefix . 'single_author_box_name_color' => [
						'label' => __( 'Author Name Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'noorgfx' ),
								'id' => 'default',
								'inherit' => [
									'var(--theme-heading-1-color, var(--theme-headings-color))' => [
										$prefix . 'single_author_box_name_heading' => 'h1'
									],

									'var(--theme-heading-2-color, var(--theme-headings-color))' => [
										$prefix . 'single_author_box_name_heading' => 'h2'
									],

									'var(--theme-heading-3-color, var(--theme-headings-color))' => [
										$prefix . 'single_author_box_name_heading' => 'h3'
									],

									'var(--theme-heading-4-color, var(--theme-headings-color))' => [
										$prefix . 'single_author_box_name_heading' => 'h4'
									],

									'var(--theme-heading-5-color, var(--theme-headings-color))' => [
										$prefix . 'single_author_box_name_heading' => 'h5'
									],

									'var(--theme-heading-6-color, var(--theme-headings-color))' => [
										$prefix . 'single_author_box_name_heading' => 'h6'
									]
								]
							],
						],
					],

					$prefix . 'single_author_box_font' => [
						'type' => 'ct-typography',
						'label' => __( 'Author Bio Font', 'noorgfx' ),
						'sync' => 'live',
						'value' => noorgfx_typography_default_values([]),
					],

					$prefix . 'single_author_box_font_color' => [
						'label' => __( 'Author Bio Font Color', 'noorgfx' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'divider' => 'bottom',
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => [
							'default' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'initial' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Text', 'noorgfx' ),
								'id' => 'default',
								'inherit' => 'var(--theme-text-color)'
							],

							[
								'title' => __( 'Link Initial', 'noorgfx' ),
								'id' => 'initial',
								'inherit' => 'var(--theme-link-initial-color)'
							],

							[
								'title' => __( 'Link Hover', 'noorgfx' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-link-hover-color)'
							],
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ $prefix . 'single_author_box_social' => 'yes' ],
						'options' => [

							$prefix . 'single_author_box_social_icons_color' => [
								'label' => __( 'Icons Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								// 'divider' => 'bottom',
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => '#fff'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => '#fff'
									],
								],
							],

							$prefix . 'single_author_box_social_icons_background' => [
								'label' => __( 'Icons Background Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'divider' => 'bottom',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => 'var(--theme-palette-color-1)'
									],

									[
										'title' => __( 'Hover', 'noorgfx' ),
										'id' => 'hover',
										'inherit' => 'var(--theme-palette-color-2)'
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'single_author_box_type' => 'type-2'
						],
						'options' => [

							$prefix . 'single_author_box_border' => [
								'label' => __( 'Border Color', 'noorgfx' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'divider' => 'bottom',
								'responsive' => true,
								'setting' => [ 'transport' => 'postMessage' ],

								'value' => [
									'default' => [
										'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'noorgfx' ),
										'id' => 'default',
										'inherit' => '#e8ebf0'
									],
								],
							],

						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'single_author_box_type' => 'type-1'
						],
						'options' => [

							$prefix . 'single_author_box_container_background' => [
								'label' => __( 'Background Color', 'noorgfx' ),
								'type'  => 'ct-background',
								'design' => 'block:right',
								'responsive' => true,
								// 'divider' => 'bottom',
								'activeTabs' => ['color', 'gradient'],
								'sync' => 'live',
								'value' => noorgfx_background_default_value([
									'backgroundColor' => [
										'default' => [
											'color' => 'var(--theme-palette-color-8)',
										],
									],
								]),
							],

							$prefix . 'single_author_box_shadow' => [
								'label' => __( 'Shadow', 'noorgfx' ),
								'type' => 'ct-box-shadow',
								'responsive' => true,
								'divider' => 'top',
								'sync' => 'live',
								'value' => noorgfx_box_shadow_value([
									'enable' => true,
									'h_offset' => 0,
									'v_offset' => 50,
									'blur' => 90,
									'spread' => 0,
									'inset' => false,
									'color' => [
										'color' => 'rgba(210, 213, 218, 0.4)',
									],
								])
							],

							$prefix . 'single_author_box_container_border' => [
								'label' => __( 'Border', 'noorgfx' ),
								'type' => 'ct-border',
								'design' => 'block',
								'sync' => 'live',
								'divider' => 'top',
								'responsive' => true,
								'value' => [
									'width' => 1,
									'style' => 'none',
									'color' => [
										'color' => 'rgba(44,62,80,0.2)',
									],
								]
							],

							$prefix . 'single_author_box_border_radius' => [
								'label' => __( 'Border Radius', 'noorgfx' ),
								'sync' => 'live',
								'type' => 'ct-spacing',
								'divider' => 'top',
								'value' => noorgfx_spacing_value(),
								'min' => 0,
								'responsive' => true
							],
						],
					],
				],
			],
		],
	],
];

