<?php

/**
 * Page options.
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$page_title_options = noorgfx_get_options('general/page-title', [
	'prefix' => 'single_page',
	'is_single' => true,
	'is_page' => true
]);

$page_structure_options = [
	noorgfx_rand_md5() => [
		'label' => __( 'Page Structure', 'noorgfx' ),
		'type' => 'ct-title',
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			noorgfx_get_options('single-elements/structure', [
				'default_structure' => 'type-4',
				'prefix' => 'single_page',
			]),
		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [
			noorgfx_get_options('single-elements/structure-design', [
				'prefix' => 'single_page',
			])
		],
	]
];

$maybe_taxonomy = noorgfx_maybe_get_matching_taxonomy('page', false);

$page_elements_options = [
	[
		[
			noorgfx_rand_md5() => [
				'type' => 'ct-title',
				'label' => __( 'Page Elements', 'noorgfx' ),
			],
		],

		noorgfx_get_options('single-elements/featured-image', [
			'prefix' => 'single_page',
		]),

		noorgfx_get_options('single-elements/post-share-box', [
			'prefix' => 'single_page'
		]),
	],

	$maybe_taxonomy ? [
		'single_page_has_post_tags' => [
			'label' => noorgfx_safe_sprintf(
				__('Page %s', 'noorgfx'),
				get_taxonomy($maybe_taxonomy)->label
			),
			'type' => 'ct-switch',
			'value' => 'no',
			'sync' => noorgfx_sync_single_post_container([
				'prefix' => 'single_page'
			]),
		],
	] : [],

	[
		noorgfx_get_options('general/comments-single', [
			'prefix' => 'single_page',
		]),

		apply_filters(
			'noorgfx_single_posts_end_customizer_options',
			[],
			'single_page'
		),
	]
];


$inner_options = [
	[
		noorgfx_manager()->get_prefix_title_actions([
			'prefix' => 'single_page',
			'areas' => [
				[
					'title' => __('Page Title', 'noorgfx'),
					'options' => $page_title_options,
					'sources' => array_merge(
						noorgfx_manager()
							->screen
							->get_archive_prefixes_with_human_labels([
								'has_categories' => true,
								'has_author' => true,
								'has_search' => true,
								'has_woocommerce' => true
							]),

						noorgfx_manager()
							->screen
							->get_single_prefixes_with_human_labels([
								'has_woocommerce' => true
							])
					)
				],

				[
					'id' => 'page_structure',
					'title' => __('Page Structure', 'noorgfx'),
					'options' => $page_structure_options,
					'sources' => noorgfx_manager()
							->screen
							->get_single_prefixes_with_human_labels()
				],

				[
					'title' => __('Page Elements', 'noorgfx'),
					'options' => $page_elements_options,
					'sources' => noorgfx_manager()
							->screen
							->get_single_prefixes_with_human_labels()
				]
			]
		]),

		$page_title_options,
		$page_structure_options,
		$page_elements_options
	]
];

if (
	function_exists('blc_get_content_block_that_matches')
	&&
	blc_get_content_block_that_matches([
		'template_type' => 'single',
		'template_subtype' => 'canvas',
		'match_conditions_strategy' => 'single_page'
	])
) {
	$inner_options = [
		noorgfx_rand_md5() => [
			'type' => 'ct-notification',
			'attr' => [ 'data-type' => 'background:white' ],
			'text' => noorgfx_safe_sprintf(
				__('This single page is overrided by a custom template, to edit it please access %sthis page%s.', 'noorgfx'),
				'<a href="' . get_edit_post_link(blc_get_content_block_that_matches([
					'template_type' => 'single',
					'template_subtype' => 'canvas',
					'match_conditions_strategy' => 'single_page'
				])) . '" target="_blank">',
				'</a>'
			)
		],
	];
}

$options = [
	'page_section_options' => [
		'type' => 'ct-options',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => $inner_options
	],
];
