<?php

$maybe_taxonomy = noorgfx_maybe_get_matching_taxonomy('page', false);

$options = [
	[
		'page_title_panel' => [
			'label' => __( 'Page Title', 'noorgfx' ),
			'type' => 'ct-panel',
			'wrapperAttr' => [ 'data-label' => 'heading-label' ],
			'setting' => [ 'transport' => 'postMessage' ],
			'inner-options' => [
				noorgfx_get_options('general/page-title', [
					'has_default' => true,
					'is_single' => true,
					'is_page' => true
				])
			]
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Page Structure', 'noorgfx' ),
		],

		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx' ),
			'type' => 'tab',
			'options' => [
				'page_structure_type' => [
					'label' => false,
					'type' => 'ct-image-picker',
					'value' => 'default',
					'design' => 'block',
					'attr' => [
						'data-type' => 'background',
						'data-state' => 'sync',
					],
					'setting' => [ 'transport' => 'postMessage' ],
					'choices' => [

						'default' => [
							'src'   => noorgfx_image_picker_url( 'default.svg' ),
							'title' => __( 'Inherit from customizer', 'noorgfx' ),
						],

						'type-3' => [
							'src' => noorgfx_image_picker_url('narrow.svg'),
							'title' => __('Narrow Width', 'noorgfx'),
						],

						'type-4' => [
							'src' => noorgfx_image_picker_url('normal.svg'),
							'title' => __('Normal Width', 'noorgfx'),
						],

						'type-2' => [
							'src' => noorgfx_image_picker_url('left-single-sidebar.svg'),
							'title' => __('Left Sidebar', 'noorgfx'),
						],

						'type-1' => [
							'src' => noorgfx_image_picker_url('right-single-sidebar.svg'),
							'title' => __('Right Sidebar', 'noorgfx'),
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				'content_style_source' => [
					'label' => __('Content Area Style Source', 'noorgfx'),
					'type' => 'ct-radio',
					'value' => 'inherit',
					'view' => 'text',
					'choices' => [
						'inherit' => __('Inherit', 'noorgfx'),
						'custom' => __('Custom', 'noorgfx'),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['content_style_source' => 'custom'],
					'options' => [
						'content_style' => [
							'label' => __('Content Area Style', 'noorgfx'),
							'type' => 'ct-radio',
							'value' => 'wide',
							'view' => 'text',
							'design' => 'block',
							'responsive' => true,
							'choices' => [
								'wide' => __( 'Wide', 'noorgfx' ),
								'boxed' => __( 'Boxed', 'noorgfx' ),
							],
						],
					]
				],

				'vertical_spacing_source' => [
					'label' => __('Content Area Vertical Spacing', 'noorgfx'),
					'type' => 'ct-radio',
					'value' => 'inherit',
					'view' => 'text',
					'divider' => 'top',
					'choices' => [
						'inherit' => __('Inherit', 'noorgfx'),
						'custom' => __('Custom', 'noorgfx'),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'vertical_spacing_source' => 'custom' ],
					'options' => [

						'content_area_spacing' => [
							'label' => false,
							'desc' => __( 'You can customize the spacing value in general settings panel.', 'noorgfx' ),
							'type' => 'ct-radio',
							'value' => 'both',
							'view' => 'text',
							'design' => 'block',
							'disableRevertButton' => true,
							'attr' => [ 'data-type' => 'content-spacing' ],
							'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'choices' => [
								'both'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx' ) . '</i>',

								'top'    => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx' ) . '</i>',

								'bottom' => '<span></span>
								<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx' ) . '</i>',

								'none'   => '<span></span>
								<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx' ) . '</i>',
							],
							'desc' => noorgfx_safe_sprintf(
								// translators: placeholder here means the actual URL.
								__( 'You can customize the global spacing value in General ➝ Layout ➝ %sContent Area Spacing%s.', 'noorgfx' ),
								noorgfx_safe_sprintf(
									'<a data-trigger-section="general" href="%s">',
                                    admin_url('/customize.php?autofocus[section]=general&ct_autofocus=general:layout_panel')
								),
								'</a>'
							),
						],
					],
				],
			]
		],

		noorgfx_rand_md5() => [
			'title' => __('Design', 'noorgfx'),
			'type' => 'tab',
			'options' => [
				noorgfx_get_options('single-elements/structure-design', [
					'options_conditions' => [
						'content_style_source' => 'custom'
					]
				])
			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-title',
			'label' => __( 'Page Elements', 'noorgfx' ),
		],

		'disable_featured_image' => [
			'label' => __( 'Disable Featured Image', 'noorgfx' ),
			'type' => 'ct-switch',
			'value' => 'no',
		],

		'disable_share_box' => [
			'label' => __( 'Disable Share Box', 'noorgfx' ),
			'type' => 'ct-switch',
			'value' => 'no',
		],
	],

	$maybe_taxonomy ? [
		'disable_post_tags' => [
			'label' => noorgfx_safe_sprintf(
				__('Disable Page %s', 'noorgfx'),
				get_taxonomy($maybe_taxonomy)->label
			),
			'type' => 'ct-switch',
			'value' => 'no',
		],
	] : [],

	[
		'disable_header' => [
			'label' => __( 'Disable Header', 'noorgfx' ),
			'type' => 'ct-switch',
			'value' => 'no',
		],

		'disable_footer' => [
			'label' => __( 'Disable Footer', 'noorgfx' ),
			'type' => 'ct-switch',
			'value' => 'no',
		],
	],

	apply_filters(
		'noorgfx_extensions_metabox_page_bottom',
		[]
	)
];
