<?php

if (! isset($is_cpt)) {
	$is_cpt = false;
}

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

if (! isset($title)) {
	$title = __('Blog', 'noorgfx');
}

$has_card_matching_template = (
	function_exists('blc_get_content_block_that_matches')
	&&
	blc_get_content_block_that_matches([
		'template_type' => 'archive',
		'template_subtype' => 'card',
		'match_conditions_strategy' => rtrim($prefix, '_')
	])
);

$overridable_card_options = [
	noorgfx_rand_md5() => [
		'title' => __('General', 'noorgfx'),
		'type' => 'tab',
		'options' => [
			[
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'structure' => '!gutenberg'
					],
					'perform_replace' => $has_card_matching_template ? [
						[
							'condition' => [
								$prefix . 'structure' => '!__never__'
							],
							'key' => $prefix . 'structure',
							'from' => 'simple',
							'to' => 'grid'
						],

						[
							'condition' => [
								$prefix . 'structure' => '!__never__'
							],
							'key' => $prefix . 'structure',
							'from' => 'gutenberg',
							'to' => 'grid'
						]
					] : [],

					'options' => [
						$prefix . 'card_type' => [
							'label' => __('Card Type', 'noorgfx'),
							'type' => 'ct-radio',
							'value' => 'boxed',
							'view' => 'text',
							'divider' => 'bottom:full',
							'choices' => [
								'simple' => __('Simple', 'noorgfx'),
								'boxed' => __('Boxed', 'noorgfx'),
								'cover' => __('Cover', 'noorgfx'),
							],
							'conditions' => [
								'cover' => $has_card_matching_template ? [
									$prefix . 'structure' => '__never__'
								] : [
									$prefix . 'structure' => '!simple'
								]
							],
							'sync' => noorgfx_sync_whole_page([
								'prefix' => $prefix,
								'loader_selector' => '.entries > article[id]'
							])
						],
					],
				],
			],

			[
				$prefix . 'archive_order' => apply_filters('noorgfx:options:posts-listing-archive-order', [
					'label' => __('Card Elements', 'noorgfx'),
					'type' => $has_card_matching_template ? 'hidden' : 'ct-layers',

					'sync' => [
						noorgfx_sync_whole_page([
							'prefix' => $prefix,
							'loader_selector' => '.entries .entry-card'
						]),

						noorgfx_sync_whole_page([
							'id' => $prefix . 'dynamic_data_sync',
							'prefix' => $prefix,
							'loader_selector' => '.entries .ct-dynamic-data-layer'
						]),

						[
							'prefix' => $prefix,
							'id' => $prefix . 'archive_order_heading_tag',
							'loader_selector' => '.entry-title',
							'container_inclusive' => false
						],

						[
							'prefix' => $prefix,
							'id' => $prefix . 'archive_order_image',
							'loader_selector' => '.ct-media-container',
							'container_inclusive' => false
						],

						[
							'prefix' => $prefix,
							'id' => $prefix . 'archive_order_button',
							'loader_selector' => '.entry-button',
							'container_inclusive' => false
						],

						[
							'prefix' => $prefix,
							'id' => $prefix . 'archive_order_skip',
							'loader_selector' => 'skip',
							'container_inclusive' => false
						],

						[
							'prefix' => $prefix,
							'id' => $prefix . 'archive_order_meta_first',
							'loader_selector' => '.entries .entry-meta:1',
							'container_inclusive' => false
						],

						[
							'prefix' => $prefix,
							'id' => $prefix . 'archive_order_meta_second',
							'loader_selector' => '.entries .entry-meta:2',
							'container_inclusive' => false
						],
					],

					'value' => [
						[
							'id' => 'post_meta',
							'enabled' => true,
							'meta_elements' => noorgfx_post_meta_defaults([
								[
									'id' => 'categories',
									'enabled' => true,
								],
							]),
							'meta_type' => 'simple',
							'meta_divider' => 'slash',
							'__id' => 'meta_1',
						],

						[
							'id' => 'title',
							'heading_tag' => 'h2',
							'enabled' => true,
							'has_link' => 'yes',
						],

						[
							'id' => 'featured_image',
							'thumb_ratio' => '4/3',
							'is_boundless' => 'yes',
							'image_size' => 'medium_large',
							'enabled' => true,
							'has_link' => 'yes',
						],

						[
							'id' => 'excerpt',
							'excerpt_length' => '40',
							'enabled' => true,
						],

						[
							'id' => 'read_more',
							'button_type' => 'background',
							'enabled' => false,
						],

						[
							'id' => 'post_meta',
							'enabled' => true,
							'meta_elements' => noorgfx_post_meta_defaults([
								[
									'id' => 'author',
									'enabled' => true,
								],

								[
									'id' => 'post_date',
									'enabled' => true,
								],

								[
									'id' => 'comments',
									'enabled' => true,
								],
							]),
							'meta_type' => 'simple',
							'meta_divider' => 'slash',
							'__id' => 'meta_2',
						],

						[
							'id' => 'divider',
							'enabled' => false
						]
					],

					'settings' => [
						'title' => [
							'label' => __('Title', 'noorgfx'),
							'options' => [

								'heading_tag' => [
									'label' => __('Heading Tag', 'noorgfx'),
									'type' => 'ct-select',
									'value' => 'h2',
									'view' => 'text',
									'design' => 'block',
									'sync' => [
										'id' => $prefix . 'archive_order_heading_tag',
									],
									'choices' => noorgfx_ordered_keys(
										[
											'h1' => 'H1',
											'h2' => 'H2',
											'h3' => 'H3',
											'h4' => 'H4',
											'h5' => 'H5',
											'h6' => 'H6',
										]
									),
								],

								'has_link' => [
									'label' => __('Link To Post', 'noorgfx'),
									'type' => 'ct-switch',
									'value' => 'yes',
									'sync' => [
										'id' => $prefix . 'archive_order_heading_tag',
									],
								],

								'spacing' => [
									'label' => __('Bottom Spacing', 'noorgfx'),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 100,
									'value' => 20,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'archive_order_skip'
									],
								],

							],
						],

						'featured_image' => [
							'label' => __('Featured Image', 'noorgfx'),
							'options' => [
								[

									noorgfx_rand_md5() => [
										'type' => 'ct-condition',
										'condition' => [
											$prefix . 'card_type' => '!cover',
										],
										'values_source' => 'global',
										'perform_replace' => [
											'condition' => $has_card_matching_template ? [
												$prefix . 'structure' => '!__never__'
											] : [
												$prefix . 'structure' => 'simple|gutenberg'
											],
											'key' => $prefix . 'card_type',
											'from' => 'cover',
											'to' => 'boxed'
										],
										'options' => [
											'thumb_ratio' => [
												'label' => __('Image Ratio', 'noorgfx'),
												'type' => 'ct-ratio',
												'view' => 'inline',
												'value' => '4/3',
												'sync' => [
													'id' => $prefix . 'archive_order_skip',
												],
											],
										],
									],

									noorgfx_rand_md5() => [
										'type' => 'ct-condition',
										'condition' => [
											$prefix . 'structure' => 'simple'
										],
										'values_source' => 'global',
										'options' => [

											'image_width' => [
												'label' => __( 'Image Width', 'noorgfx' ),
												'type' => 'ct-slider',
												'value' => 40,
												'min' => 10,
												'max' => 70,
												'defaultUnit' => '%',
												'sync' => [
													'id' => $prefix . 'archive_order_skip',
												],
											],

										],
									],

									'image_size' => [
										'label' => __('Image Size', 'noorgfx'),
										'type' => 'ct-select',
										'value' => 'medium_large',
										'view' => 'text',
										'design' => 'block',
										'sync' => [
											'id' => $prefix . 'archive_order_image',
										],
										'choices' => noorgfx_ordered_keys(
											noorgfx_get_all_image_sizes()
										),
									],

									'image_hover_effect' => [
										'label' => __( 'Hover Effect', 'noorgfx' ),
										'type' => 'ct-select',
										'value' => 'none',
										'view' => 'text',
										'design' => 'block',
										'setting' => [ 'transport' => 'postMessage' ],
										'choices' => noorgfx_ordered_keys(
											[
												'none' => __( 'None', 'noorgfx' ),
												'zoom-in' => __( 'Zoom In', 'noorgfx' ),
												'zoom-out' => __( 'Zoom Out', 'noorgfx' ),
											]
										),

										'sync' => noorgfx_sync_whole_page([
											'prefix' => $prefix,
											'loader_selector' => '.entries > article'
										]),
									],
								],

								[
									(
										function_exists('blc_site_has_feature')
										&&
										blc_site_has_feature('base_pro')
									) ? [
										'has_archive_video_thumbnail' => [
											'label' => __( 'Video Thumbnail', 'noorgfx' ),
											'type' => 'ct-switch',
											'value' => 'no',
											'sync' => noorgfx_sync_whole_page([
												'prefix' => $prefix,
												'loader_selector' => '.entries > article'
											]),
										],
									] : []
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => [
										$prefix . 'card_type' => 'boxed',
										$prefix . 'structure' => '!gutenberg'
									],
									'values_source' => 'global',
									'perform_replace' => $has_card_matching_template ? [
										[
											'condition' => [
												$prefix . 'structure' => '!__never__'
											],
											'key' => $prefix . 'structure',
											'from' => 'simple',
											'to' => 'grid'
										],

										[
											'condition' => [
												$prefix . 'structure' => '!__never__'
											],
											'key' => $prefix . 'structure',
											'from' => 'gutenberg',
											'to' => 'grid'
										]
									] : [],
									'options' => [
										'is_boundless' => [
											'label' => __('Boundless Image', 'noorgfx'),
											'type' => 'ct-switch',
											'sync' => [
												'id' => $prefix . 'archive_order_skip',
											],
											'value' => 'yes',
										],
									],
								],

								'has_link' => [
									'label' => __('Link To Post', 'noorgfx'),
									'type' => 'ct-switch',
									'value' => 'yes',
									'sync' => [
										'id' => $prefix . 'archive_order_image',
									],
								],

								'spacing' => [
									'label' => __('Bottom Spacing', 'noorgfx'),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 100,
									'value' => 30,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'archive_order_skip'
									],
								],
							],
						],

						'excerpt' => [
							'label' => __('Excerpt', 'noorgfx'),
							'options' => [
								'excerpt_source' => [
									'label' => false,
									'type' => 'ct-radio',
									'value' => 'excerpt',
									'view' => 'text',
									'choices' => [
										'excerpt' => __('Default', 'noorgfx'),
										'full' => __('Full Post', 'noorgfx'),
									],
								],

								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => [ 'excerpt_source' => 'excerpt' ],
									'options' => [

										'excerpt_length' => [
											'label' => __('Length', 'noorgfx'),
											'type' => 'ct-number',
											'design' => 'inline',
											'value' => 40,
											'min' => 1,
											'max' => 300,
										],

									],
								],

								'spacing' => [
									'label' => __('Bottom Spacing', 'noorgfx'),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 100,
									'value' => 20,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'archive_order_skip'
									],
								],
							],
						],

						'read_more' => [
							'label' => __('Read More Button', 'noorgfx'),
							'options' => [
								'button_type' => [
									'label' => __('Button Type', 'noorgfx'),
									'type' => 'ct-radio',
									'value' => 'background',
									'view' => 'text',
									'choices' => [
										'simple' => __('Simple', 'noorgfx'),
										'background' => __('Background', 'noorgfx'),
										'outline' => __('Outline', 'noorgfx'),
									],

									'sync' => [
										'id' => $prefix . 'archive_order_skip',
									]
								],

								'read_more_text' => [
									'label' => __('Text', 'noorgfx'),
									'type' => 'text',
									'design' => 'inline',
									'value' => __('Read More', 'noorgfx'),
									'sync' => [
										'id' => $prefix . 'archive_order_skip',
									]
								],

								'read_more_arrow' => [
									'label' => __('Show Arrow', 'noorgfx'),
									'type' => 'ct-switch',
									'value' => 'no',
									'sync' => [
										'id' => $prefix . 'archive_order_button',
									]
								],

								'spacing' => [
									'label' => __('Bottom Spacing', 'noorgfx'),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 100,
									'value' => 20,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'archive_order_skip'
									],
								],
							],
						],

						'post_meta' => [
							'label' => __('Post Meta', 'noorgfx'),
							'clone' => true,
							'sync' => [
								'id' => $prefix . 'archive_order_meta'
							],
							'options' => [
								noorgfx_get_options('general/meta', [
									'is_cpt' => $is_cpt,
									'computed_cpt' => $is_cpt ? trim(
										$prefix, '_'
									) : false,
									'skip_sync_id' => [
										'id' => $prefix . 'archive_order_skip'
									],
									'meta_elements' => noorgfx_post_meta_defaults([
										[
											'id' => 'author',
											'enabled' => true,
										],

										[
											'id' => 'post_date',
											'enabled' => true,
										],

										[
											'id' => 'comments',
											'enabled' => true,
										],
									]),
								]),

								'spacing' => [
									'label' => __('Bottom Spacing', 'noorgfx'),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 100,
									'value' => 15,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'archive_order_skip'
									],
								],
							]
						],

						'divider' => [
							'label' => __('Divider', 'noorgfx'),
							'clone' => true,
							'sync' => [
								'id' => $prefix . 'archive_order_meta'
							],
							'options' => [
								'spacing' => [
									'label' => __('Bottom Spacing', 'noorgfx'),
									'type' => 'ct-slider',
									'min' => 0,
									'max' => 100,
									'value' => 20,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'archive_order_skip'
									],
								],
							]
						]
					],
				], trim($prefix, '_'), $prefix . 'archive_order_skip'),
			],

			$has_card_matching_template ? [] : [
				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],
			],

			[
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'card_type' => 'cover',
						$prefix . 'structure' => '!gutenberg'
					],
					'perform_replace' => array_merge([
						'condition' => $has_card_matching_template ? [
							$prefix . 'structure' => '!__never__'
						] : [
							$prefix . 'structure' => 'simple'
						],
						'key' => $prefix . 'card_type',
						'from' => 'cover',
						'to' => 'boxed'
					], $has_card_matching_template ? [
						[
							'condition' => [
								$prefix . 'structure' => '!__never__'
							],
							'key' => $prefix . 'structure',
							'from' => 'simple',
							'to' => 'grid'
						],

						[
							'condition' => [
								$prefix . 'structure' => '!__never__'
							],
							'key' => $prefix . 'structure',
							'from' => 'gutenberg',
							'to' => 'grid'
						]
					] : []),
					'options' => [
						$prefix . 'card_min_height' => [
							'label' => __( 'Card Min Height', 'noorgfx' ),
							'type' => 'ct-slider',
							'min' => 0,
							'max' => 1000,
							'responsive' => true,
							'sync' => 'live',
							'value' => 400,
							'divider' => 'bottom',
						],
					],
				],

				$prefix . 'cardsGap' => [
					'label' => __( 'Cards Gap', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => '30px',
					'units' => [
						['unit' => 'px', 'min' => 0, 'max' => 100],
						['unit' => 'em', 'min' => 0, 'max' => 100],
						['unit' => 'rem', 'min' => 0, 'max' => 100],
						['unit' => 'vw', 'min' => 0, 'max' => 100],
						['unit' => 'vh', 'min' => 0, 'max' => 100],
						['unit' => '', 'type' => 'custom'],
					],
					'responsive' => true,
					'sync' => 'live',
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'structure' => '!gutenberg',
						$prefix . 'card_type' => 'cover|boxed',
					],
					'perform_replace' => array_merge([
						'condition' => $has_card_matching_template ? [
							$prefix . 'structure' => '!__never__'
						] : [
							$prefix . 'structure' => 'simple'
						],
						'key' => $prefix . 'card_type',
						'from' => 'cover',
						'to' => 'boxed'
					], $has_card_matching_template ? [
						[
							'condition' => [
								$prefix . 'structure' => '!__never__'
							],
							'key' => $prefix . 'structure',
							'from' => 'simple',
							'to' => 'grid'
						],

						[
							'condition' => [
								$prefix . 'structure' => '!__never__'
							],
							'key' => $prefix . 'structure',
							'from' => 'gutenberg',
							'to' => 'grid'
						]
					] : []),
					'options' => $has_card_matching_template ? [] : [
						$prefix . 'card_spacing' => [
							'label' => __( 'Card Inner Spacing', 'noorgfx' ),
							'type' => 'ct-slider',
							'value' => '30px',
							'units' => [
								['unit' => 'px', 'min' => 0, 'max' => 100],
								['unit' => 'em', 'min' => 0, 'max' => 100],
								['unit' => 'rem', 'min' => 0, 'max' => 100],
								['unit' => 'vw', 'min' => 0, 'max' => 100],
								['unit' => 'vh', 'min' => 0, 'max' => 100],
								['unit' => '', 'type' => 'custom'],
							],
							'responsive' => true,
							'sync' => 'live',
							'divider' => 'top',
						],
					],
				],
			],

			$has_card_matching_template ? [] : [
				$prefix . 'content_horizontal_alignment' => [
					'type' => $has_card_matching_template ? 'hidden' : 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'start' => '',
						'center' => '',
						'end' => '',
					],
				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					$prefix . 'structure' => '!gutenberg',
					$prefix . 'card_type' => 'cover',
				],
				'perform_replace' => array_merge([
					'condition' => $has_card_matching_template ? [
						$prefix . 'structure' => '!__never__'
					] : [
						$prefix . 'structure' => 'simple'
					],
					'key' => $prefix . 'card_type',
					'from' => 'cover',
					'to' => 'boxed'
				], $has_card_matching_template ? [
					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'simple',
						'to' => 'grid'
					],

					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'gutenberg',
						'to' => 'grid'
					]
				] : []),
				'options' => $has_card_matching_template ? [] : [
					$prefix . 'content_vertical_alignment' => [
						'type' => 'ct-radio',
						'label' => __( 'Vertical Alignment', 'noorgfx' ),
						'view' => 'text',
						'design' => 'block',
						'divider' => 'top',
						'responsive' => true,
						'attr' => [ 'data-type' => 'vertical-alignment' ],
						'setting' => [ 'transport' => 'postMessage' ],
						'value' => 'CT_CSS_SKIP_RULE',
						'choices' => [
							'flex-start' => '',
							'center' => '',
							'flex-end' => '',
						],
					],
				],
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => apply_filters('noorgfx:options:posts-listing:design', [
			[
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:title:enabled' => '!no'
					],
					'options' => [
						$prefix . 'cardTitleFont' => [
							'type' => 'ct-typography',
							'label' => __( 'Title Font', 'noorgfx' ),
							'sync' => 'live',
							'value' => noorgfx_typography_default_values([
								'size' => [
									'desktop' => '20px',
									'tablet'  => '20px',
									'mobile'  => '18px'
								],
								'line-height' => '1.3'
							]),
						],

						$prefix . 'cardTitleColor' => [
							'label' => __( 'Title Font Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'sync' => 'live',
							'design' => 'inline',

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => [
										'var(--theme-heading-1-color, var(--theme-headings-color))' => [
											$prefix . 'archive_order:array-ids:title:heading_tag' => 'h1'
										],

										'var(--theme-heading-2-color, var(--theme-headings-color))' => [
											$prefix . 'archive_order:array-ids:title:heading_tag' => 'h2'
										],

										'var(--theme-heading-3-color, var(--theme-headings-color))' => [
											$prefix . 'archive_order:array-ids:title:heading_tag' => 'h3'
										],

										'var(--theme-heading-4-color, var(--theme-headings-color))' => [
											$prefix . 'archive_order:array-ids:title:heading_tag' => 'h4'
										],

										'var(--theme-heading-5-color, var(--theme-headings-color))' => [
											$prefix . 'archive_order:array-ids:title:heading_tag' => 'h5'
										],

										'var(--theme-heading-6-color, var(--theme-headings-color))' => [
											$prefix . 'archive_order:array-ids:title:heading_tag' => 'h6'
										]
									]
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-link-hover-color)'
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:excerpt:enabled' => '!no'
					],
					'options' => [

						$prefix . 'cardExcerptFont' => [
							'type' => 'ct-typography',
							'label' => __( 'Excerpt Font', 'noorgfx' ),
							'sync' => 'live',
							'value' => noorgfx_typography_default_values([]),
						],

						$prefix . 'cardExcerptColor' => [
							'label' => __( 'Excerpt Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'noColor' => [ 'background' => 'var(--theme-text-color)'],
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-text-color)'
								],
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

					],
				],

				$prefix . 'cardMetaFont' => [
					'type' => 'ct-typography',
					'label' => __( 'Meta Font', 'noorgfx' ),
					'sync' => 'live',
					'value' => noorgfx_typography_default_values([
						'size' => [
							'desktop' => '12px',
							'tablet'  => '12px',
							'mobile'  => '12px'
						],
						'variation' => 'n6',
						'text-transform' => 'uppercase',
					]),
				],

				$prefix . 'cardMetaColor' => [
					'label' => __( 'Meta Font Color', 'noorgfx' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'noColor' => [ 'background' => 'var(--theme-text-color)'],
					'sync' => 'live',
					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],

						[
							'title' => __( 'Hover', 'noorgfx' ),
							'id' => 'hover',
							'inherit' => 'var(--theme-link-hover-color)'
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-has-meta-category-button',
					'optionId' => $prefix . 'archive_order',
					'options' => [
						$prefix . 'card_meta_button_type_font_colors' => [
							'label' => __( 'Meta Button Font Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'divider' => 'top',
							'noColor' => [ 'background' => 'var(--theme-text-color)'],
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-text-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-text-hover-color)'
								],
							],
						],

						$prefix . 'card_meta_button_type_background_colors' => [
							'label' => __( 'Meta Button Background', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'noColor' => [ 'background' => 'var(--theme-text-color)'],
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-background-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-background-hover-color)'
								],
							],
						],
					]
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:read_more:button_type' => 'simple',
						$prefix . 'archive_order:array-ids:read_more:enabled' => '!no'
					],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						$prefix . 'cardButtonSimpleTextColor' => [
							'label' => __( 'Button Font Color', 'noorgfx' ),
							'sync' => 'live',
							'type'  => 'ct-color-picker',
							'design' => 'inline',

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-link-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-link-hover-color)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:read_more:button_type' => 'background',
						$prefix . 'archive_order:array-ids:read_more:enabled' => '!no'
					],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						$prefix . 'cardButtonBackgroundTextColor' => [
							'label' => __( 'Button Font Color', 'noorgfx' ),
							'sync' => 'live',
							'type'  => 'ct-color-picker',
							'design' => 'inline',

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-text-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-text-hover-color)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:read_more:button_type' => 'outline',
						$prefix . 'archive_order:array-ids:read_more:enabled' => '!no'
					],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						$prefix . 'cardButtonOutlineTextColor' => [
							'label' => __( 'Button Font Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'sync' => 'live',
							'design' => 'inline',

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-background-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-text-hover-color)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:read_more:button_type' => '!simple',
						$prefix . 'archive_order:array-ids:read_more:enabled' => '!no'
					],
					'options' => [

						$prefix . 'cardButtonColor' => [
							'label' => __( 'Button Color', 'noorgfx' ),
							'sync' => 'live',
							'type'  => 'ct-color-picker',
							'design' => 'inline',

							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-background-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-background-hover-color)'
								],
							],
						],

					],
				],

				noorgfx_rand_md5() =>  [
					'type' => 'ct-condition',
					'condition' => [
						'any' => [
							$prefix . 'card_type' => 'simple',
							$prefix . 'structure' => 'gutenberg'
						],
						$prefix . 'archive_order:array-ids:featured_image:enabled' => '!no'
					],
					'options' => [

						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						$prefix . 'cardThumbRadius' => [
							'label' => __( 'Featured Image Radius', 'noorgfx' ),
							'type' => 'ct-spacing',
							'sync' => 'live',
							'value' => noorgfx_spacing_value(),
							'min' => 0,
							'responsive' => true
						],

						$prefix . 'cardThumbShadow' => [
							'label' => __( 'Featured Image Shadow', 'noorgfx' ),
							'type' => 'ct-box-shadow',
							'sync' => 'live',
							'responsive' => true,
							'divider' => 'top',
							'value' => noorgfx_box_shadow_value([
								'enable' => false,
								'h_offset' => 0,
								'v_offset' => 12,
								'blur' => 18,
								'spread' => -6,
								'inset' => false,
								'color' => [
									'color' => 'rgba(34, 56, 101, 0.04)',
								],
							])
						],
					],
				],

				noorgfx_rand_md5() =>  [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'structure' => 'simple',
						$prefix . 'card_type' => 'simple',
					],
					'options' => [

						$prefix . 'cardDivider' => [
							'label' => __( 'Card Bottom Divider', 'noorgfx' ),
							'type' => 'ct-border',
							'sync' => 'live',
							'design' => 'inline',
							'divider' => 'top',
							'value' => [
								'width' => 1,
								'style' => 'dashed',
								'color' => [
									'color' => 'rgba(224, 229, 235, 0.8)',
								],
							]
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'archive_order:array-ids:divider:enabled' => '!no'

					],
					'options' => [
						noorgfx_rand_md5() => [
							'type' => 'ct-divider',
						],

						$prefix . 'entryDivider' => [
							'label' => __( 'Card Divider', 'noorgfx' ),
							'type' => 'ct-border',
							'sync' => 'live',
							'design' => 'inline',
							'value' => [
								'width' => 1,
								'style' => 'solid',
								'color' => [
									'color' => 'rgba(224, 229, 235, 0.8)',
								],
							]
						],
					],
				],
			],

			apply_filters(
				'noorgfx:options:posts-listing:design:before_card_background',
				[],
				trim($prefix, '_')
			),

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					$prefix . 'card_type' => 'boxed|cover',
					$prefix . 'structure' => '!gutenberg'
				],
				'perform_replace' => array_merge([
					'condition' => $has_card_matching_template ? [
						$prefix . 'structure' => '!__never__'
					] : [
						$prefix . 'structure' => 'simple'
					],
					'key' => $prefix . 'card_type',
					'from' => 'cover',
					'to' => 'boxed'
				], $has_card_matching_template ? [
					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'simple',
						'to' => 'grid'
					],

					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'gutenberg',
						'to' => 'grid'
					]
				] : []),
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-divider',
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							$prefix . 'card_type' => 'cover',
						],
						'perform_replace' => [
							'condition' => $has_card_matching_template ? [
								$prefix . 'structure' => '!__never__'
							] : [
								$prefix . 'structure' => 'simple'
							],
							'key' => $prefix . 'card_type',
							'from' => 'cover',
							'to' => 'boxed'
						],
						'options' => [

							$prefix . 'card_overlay_background' => [
								'label' => __( 'Card Overlay Color', 'noorgfx' ),
								'type'  => 'ct-background',
								'design' => 'block:right',
								'responsive' => true,
								'divider' => 'bottom',
								'activeTabs' => ['color', 'gradient'],
								'sync' => 'live',
								'value' => noorgfx_background_default_value([
									'backgroundColor' => [
										'default' => [
											'color' => 'rgba(0,0,0,0.5)',
										],
									],
								]),
							],
						],
					],

					$prefix . 'cardBackground' => [
						'label' => __( 'Card Background Color', 'noorgfx' ),
						'type'  => 'ct-background',
						'design' => 'block:right',
						'responsive' => true,
						'activeTabs' => ['color', 'gradient'],
						'sync' => 'live',
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => 'var(--theme-palette-color-8)',
								],
							],
						]),
					],

					$prefix . 'cardBorder' => [
						'label' => __( 'Card Border', 'noorgfx' ),
						'type' => 'ct-border',
						'design' => 'block',
						'sync' => 'live',
						'divider' => 'top',
						'responsive' => true,
						'value' => [
							'width' => 1,
							'style' => 'none',
							'color' => [
								'color' => 'rgba(44,62,80,0.2)',
							],
						]
					],

					$prefix . 'cardShadow' => [
						'label' => __( 'Card Shadow', 'noorgfx' ),
						'type' => 'ct-box-shadow',
						'sync' => 'live',
						'responsive' => true,
						'divider' => 'top',
						'value' => noorgfx_box_shadow_value([
							'enable' => true,
							'h_offset' => 0,
							'v_offset' => 12,
							'blur' => 18,
							'spread' => -6,
							'inset' => false,
							'color' => [
								'color' => 'rgba(34, 56, 101, 0.04)',
							],
						])
					],

					$prefix . 'cardRadius' => [
						'label' => __( 'Border Radius', 'noorgfx' ),
						'sync' => 'live',
						'type' => 'ct-spacing',
						'divider' => 'top',
						'value' => noorgfx_spacing_value(),
						'min' => 0,
						'responsive' => true
					],

				],
			],
		], trim($prefix, '_'))
	]
];


$options = [
	noorgfx_rand_md5() => [
		'type'  => 'ct-title',
		'label' => noorgfx_safe_sprintf(
			// translators: placeholder here means the actual structure title.
			__('%s Structure', 'noorgfx'),
			$title
		),
		'desc' => noorgfx_safe_sprintf(
			// translators: placeholder here means the actual structure title.
			__('Set the %s entries default structure.', 'noorgfx'),
			$title
		),
	],

	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			$prefix . 'structure' => [
				'label' => false,
				'type' => 'ct-image-picker',
				'value' => 'grid',
				'divider' => 'bottom',
				'sync' => noorgfx_sync_whole_page([
					'prefix' => $prefix,
					'loader_selector' => '.entries > article'
				]),
				'choices' => [
					'simple' => [
						'src' => noorgfx_image_picker_url('simple.svg'),
						'title' => __('Simple', 'noorgfx'),
					],

					'classic' => [
						'src' => noorgfx_image_picker_url('classic.svg'),
						'title' => __('Classic', 'noorgfx'),
					],

					'grid' => [
						'src' => noorgfx_image_picker_url('grid.svg'),
						'title' => __('Grid', 'noorgfx'),
					],

					'enhanced-grid' => [
						'src' => noorgfx_image_picker_url('enhanced-grid.svg'),
						'title' => __('Enhanced Grid', 'noorgfx'),
					],

					'gutenberg' => [
						'src' => noorgfx_image_picker_url('gutenberg.svg'),
						'title' => __('Gutenberg', 'noorgfx'),
					],
				],

				'conditions' => $has_card_matching_template ? [
					'simple' => [
						$prefix . 'structure' => '__never__'
					],

					'gutenberg' => [
						$prefix . 'structure' => '__never__'
					],
				] : [],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ $prefix . 'structure' => '!grid' ],
				'perform_replace' => $has_card_matching_template ? [
					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'simple',
						'to' => 'grid'
					],

					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'gutenberg',
						'to' => 'grid'
					]
				] : [],
				'options' => [

					$prefix . 'archive_per_page' => [
						'label' => __( 'Number of Posts', 'noorgfx' ),
						'type' => 'ct-number',
						'value' => get_option('posts_per_page', 10),
						'min' => 1,
						'max' => 500,
						'design' => 'inline',
						'sync' => noorgfx_sync_whole_page([
							'prefix' => $prefix,
							'loader_selector' => '.entries > article'
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ $prefix . 'structure' => 'grid' ],
				'perform_replace' => $has_card_matching_template ? [
					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'simple',
						'to' => 'grid'
					],

					[
						'condition' => [
							$prefix . 'structure' => '!__never__'
						],
						'key' => $prefix . 'structure',
						'from' => 'gutenberg',
						'to' => 'grid'
					]
				] : [],
				'options' => [

					noorgfx_rand_md5() => [
						'type' => 'ct-group',
						'label' => __( 'Columns & Posts', 'noorgfx' ),
						'attr' => [ 'data-columns' => '2:medium' ],
						'responsive' => true,
						'hasGroupRevertButton' => true,
						'options' => [

							$prefix . 'columns' => [
								'label' => false,
								'desc' => __( 'Number of columns', 'noorgfx' ),
								'type' => 'ct-number',
								'value' => [
									'desktop' => 3,
									'tablet' => 2,
									'mobile' => 1,
									'__changed' => ['tablet', 'mobile']
								],
								'min' => 1,
								'max' => 6,
								'design' => 'block',
								'attr' => [ 'data-width' => 'full' ],
								'sync' => 'live',
								'responsive' => true,
								'skipResponsiveControls' => true
							],

							$prefix . 'archive_per_page' => [
								'label' => false,
								'desc' => __( 'Number of posts', 'noorgfx' ),
								'type' => 'ct-number',
								'value' => get_option('posts_per_page', 10),
								'min' => 1,
								'max' => 500,
								'markAsAutoFor' => ['tablet', 'mobile'],
								'design' => 'block',
								'attr' => [ 'data-width' => 'full' ],
								'sync' => noorgfx_sync_whole_page([
									'prefix' => $prefix,
									'loader_selector' => '.entries > article'
								]),
							]
						],
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
				'attr' => ['data-type' => 'small']
			],

			$prefix . 'archive_listing_panel' => [
				'label' => __('Card Options', 'noorgfx'),
				'type' => 'ct-panel',
				'value' => 'yes',
				'wrapperAttr' => ['data-panel' => 'only-arrow'],
				'inner-options' => $overridable_card_options
			],

			$prefix . 'content_area_spacing' => [
				'label' => __( 'Content Area Vertical Spacing', 'noorgfx' ),
				'type' => 'ct-radio',
				'value' => 'both',
				'view' => 'text',
				'design' => 'block',
				'divider' => 'top:full',
				'attr' => [ 'data-type' => 'content-spacing' ],
				'choice_attr' => [ 'data-tooltip-reveal' => 'top' ],
				'sync' => "live",
				'choices' => [
					'both'   => '<span></span>
					<i class="ct-tooltip">' . __( 'Top & Bottom', 'noorgfx' ) . '</i>',

					'top'    => '<span></span>
					<i class="ct-tooltip">' . __( 'Only Top', 'noorgfx' ) . '</i>',

					'bottom' => '<span></span>
					<i class="ct-tooltip">' . __( 'Only Bottom', 'noorgfx' ) . '</i>',

					'none'   => '<span></span>
					<i class="ct-tooltip">' . __( 'Disabled', 'noorgfx' ) . '</i>',
				],
				'desc' => noorgfx_safe_sprintf(
					// translators: placeholder here means the actual URL.
					__( 'You can customize the global spacing value in General ➝ Layout ➝ %sContent Area Spacing%s.', 'noorgfx' ),
					noorgfx_safe_sprintf(
						'<a data-trigger-section="general:layout_panel" href="%s">',
						admin_url('/customize.php?autofocus[section]=general&ct_autofocus=general:layout_panel')
					),
					'</a>'
				),
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			$prefix . 'background' => [
				'label' => __('Page Background', 'noorgfx'),
				'type' => 'ct-background',
				'design' => 'block:right',
				'responsive' => true,
				'sync' => 'live',
				'divider' => 'bottom',
				'value' => noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword(),
						],
					],
				]),
				'desc' => noorgfx_safe_sprintf(
					// translators: placeholder here means the actual URL.
					__( 'Please note, by default this option is inherited from Colors ➝ %sSite Background%s.', 'noorgfx' ),
					noorgfx_safe_sprintf(
						'<a data-trigger-section="color" href="%s">',
						admin_url('/customize.php?autofocus[section]=color')
					),
					'</a>'
				),
			],

		],
	]

];
