<?php
/**
 * Performance options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [
	'performance_section_options' => [
		'type' => 'ct-options',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [
			apply_filters(
				'noorgfx_performance_end_customizer_options',
				[]
			),

			[
				[
					'emoji_scripts' => [
						'label' => __( 'Disable Emojis Script', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'yes',
						'setting' => [ 'transport' => 'postMessage' ],
						'desc' => __( 'Enable this option if you want to remove WordPress emojis script in order to improve the performance.', 'noorgfx' )
					],
	
					noorgfx_rand_md5() => [
						'type' => 'ct-divider'
					]
				],

				apply_filters(
					'noorgfx_performance_after_emojis_customizer_options',
					[]
				),

				'has_lazy_load' => [
					'label' => __( 'Lazy Load Images', 'noorgfx' ),
					'type' => 'ct-switch',
					'value' => 'yes',
					'setting' => [ 'transport' => 'postMessage' ],
					'desc' => __( 'Enable lazy loading to improve performance.', 'noorgfx' ),
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_lazy_load' => 'yes' ],
					'options' => [

						[
							'has_lazy_load_page_title_image' => [
								'label' => __( 'Post/Page Title Featured Image', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'setting' => [ 'transport' => 'postMessage' ],
							],

							'has_lazy_load_single_featured_image' => [
								'label' => __( 'Single Post/Page Featured Image', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'setting' => [ 'transport' => 'postMessage' ],
							],

							'has_lazy_load_archives_image' => [
								'label' => __( 'Archives Featured Image', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'setting' => [ 'transport' => 'postMessage' ],
							],

							'has_lazy_load_related_posts_image' => [
								'label' => __( 'Related Posts Featured Image', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'setting' => [ 'transport' => 'postMessage' ],
							],
						],

						function_exists('is_shop') ? [
							'has_lazy_load_single_product_image' => [
								'label' => __( 'Single Product Image', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'setting' => [ 'transport' => 'postMessage' ],
							],

							'has_lazy_load_shop_card_image' => [
								'label' => __( 'Shop Archive Featured Image', 'noorgfx' ),
								'type' => 'ct-switch',
								'value' => 'yes',
								'setting' => [ 'transport' => 'postMessage' ],
							],
						] : []
					],
				],
			],
		],
	],
];