<?php
/**
 * Page title options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

if (! isset($has_hero_type)) {
	$has_hero_type = true;
}

if (! isset($location_name)) {
	$location_name = '';
}

if (! isset($enabled_label)) {
	$enabled_label = __('Page Title', 'noorgfx');
}

if (! isset($design_options)) {
	$design_options = [];
}

if (! isset($enabled_default)) {
	$enabled_default = 'yes';
}

if (! isset($is_cpt)) {
	$is_cpt = false;
}

if (! isset($has_hero_elements)) {
	$has_hero_elements = true;
}

if (! isset($is_bbpress)) {
	$is_bbpress = false;
}

if (! isset($is_tutorlms)) {
	$is_tutorlms = false;
}

if (! isset($is_tribe_events)) {
	$is_tribe_events = false;
}

if (! isset($is_woo)) {
	$is_woo = false;
}

if (! isset($is_page)) {
	$is_page = false;
}

if (! isset($is_author)) {
	$is_author = false;
}

if (! isset($has_default)) {
	$has_default = false;
}

if (! isset($is_home)) {
	$is_home = false;
}

if (! isset($is_single)) {
	$is_single = false;
}

if (! isset($is_search)) {
	$is_search = false;
}

if (! isset($is_archive)) {
	$is_archive = false;
}

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

$computed_cpt = $is_cpt || $prefix === 'product_' ? trim( $prefix, '_') : false;

if ($is_cpt && ! $prefix) {
	$computed_cpt = $is_cpt;
}

$archives_have_hero = apply_filters(
	'noorgfx:options:page-title:archives-have-hero',
	false
);

$custom_description_layer_name = __('Description', 'noorgfx');

if ($is_author) {
	$custom_description_layer_name = __('Bio', 'noorgfx');
}

if (
	(
		$is_single || $is_home
	) && ! $is_bbpress
) {
	$custom_description_layer_name = __('Excerpt', 'noorgfx');
}

if ($is_search) {
	$custom_description_layer_name = __('Subtitle', 'noorgfx');
}

$default_hero_elements = [];

$default_hero_elements[] = array_merge([
	'id' => 'custom_title',
	'enabled' => $prefix !== 'product_',
	'heading_tag' => 'h1',
	'title' => __('Home', 'noorgfx')
], (
	$is_author ? [
		'has_author_avatar' => 'yes',
		'author_avatar_size' => 60
	] : []
));

if (! $is_tutorlms && ! $is_tribe_events) {
	$default_hero_elements[] = [
		'id' => 'custom_description',
		'enabled' => $prefix !== 'product_',
		'description_visibility' => [
			'desktop' => true,
			'tablet' => true,
			'mobile' => false,
		]
	];
}

if (
	(
		$is_single || $is_author
	) && !$is_bbpress && !$is_tutorlms && !$is_tribe_events
) {
	$default_hero_elements[] = [
		'id' => 'custom_meta',
		'enabled' => ! $is_page && $prefix !== 'product_',
		'meta_elements' => noorgfx_post_meta_defaults([
			[
				'id' => 'author',
				'has_author_avatar' => 'yes',
				'enabled' => true,
			],

			[
				'id' => 'post_date',
				'enabled' => true,
			],

			[
				'id' => 'comments',
				'enabled' => true,
			],

			[
				'id' => 'categories',
				'enabled' => ! $is_page,
			],
		]),
		'page_meta_elements' => [
			'joined' => true,
			'articles_count' => true,
			'comments' => true
		]
	];
}

if ($is_author) {
	$default_hero_elements[] = [
		'id' => 'author_social_channels',
		'enabled' => true
	];
}

$default_hero_elements[] = [
	'id' => 'breadcrumbs',
	'enabled' => $prefix === 'product_',
];

$when_enabled_general_settings = [
	$has_hero_type ? [
		$prefix . 'hero_section' => [
			'label' => $has_default ? __('Type', 'noorgfx') : false,
			'type' => 'ct-image-picker',
			'value' => ($is_woo || $is_author) ? 'type-2' : 'type-1',
			'design' => 'block',
			'sync' => noorgfx_sync_whole_page([
				'prefix' => $prefix,
				'prefix_custom' => 'hero'
			]),
			'choices' => [
				'type-1' => [
					'src' => noorgfx_image_picker_url('hero-type-1.svg'),
					'title' => __('Type 1', 'noorgfx'),
				],

				'type-2' => [
					'src' => noorgfx_image_picker_url('hero-type-2.svg'),
					'title' => __('Type 2', 'noorgfx'),
				],
			],
		],
	] : [
		$prefix . 'hero_section' => [
			'type' => 'hidden',
			'value' => ($is_woo || $is_author) ? 'type-2' : 'type-1',
		]
	],

	[
		$prefix . 'hero_elements' => apply_filters('noorgfx:options:page-title:hero-elements', [
			'label' => __('Elements', 'noorgfx'),
			'type' => $has_hero_elements ? 'ct-layers' : 'hidden',
			'design' => 'block',
			'value' => $default_hero_elements,
			'sync' => [
				[
					'selector' => noorgfx_prefix_custom_selector('.hero-section', 'hero'),
					'container_inclusive' => true,
					'prefix' => $prefix,
					'render' => function ($args) {
						echo noorgfx_output_hero_section([
							'type' => noorgfx_get_theme_mod(
								$args['prefix'] . '_hero_section',
								'type-1'
							)
						]);
					},
					'prefix_custom' => 'hero'
				],

				[
					'prefix' => $prefix,
					'id' => $prefix . 'hero_elements_heading_tag',
					'loader_selector' => '.page-title',
					'prefix_custom' => 'hero'
				],

				[
					'prefix' => $prefix,
					'id' => $prefix . 'hero_elements_meta_first',
					'loader_selector' => '.entry-meta:1',
					'prefix_custom' => 'hero'
				],

				[
					'prefix' => $prefix,
					'id' => $prefix . 'hero_elements_meta_second',
					'loader_selector' => '.entry-meta:2',
					'prefix_custom' => 'hero'
				],

				[
					'prefix' => $prefix,
					'id' => $prefix . 'hero_elements_spacing',
					'loader_selector' => 'skip',
					'prefix_custom' => 'hero'
				],

				[
					'prefix' => $prefix,
					'id' => $prefix . 'hero_elements_author_avatar',
					'loader_selector' => '.ct-author-name',
					'prefix_custom' => 'hero'
				]
			],

			'settings' => [
				'breadcrumbs' => [
					'label' => __('Breadcrumbs', 'noorgfx'),
					'options' => [
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['itemIndex' => '!0'],
							'options' => [

								'hero_item_spacing' => [
									'label' => __( 'Top Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'value' => 20,
									'min' => 0,
									'max' => 100,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
								],

							]
						],

						'breadcrumbs_visibility' => [
							'label' => __( 'Visibility', 'noorgfx' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'value' => noorgfx_default_responsive_value([
								'desktop' => true,
								'tablet' => true,
								'mobile' => true,
							]),
							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx' ),
								'tablet' => __( 'Tablet', 'noorgfx' ),
								'mobile' => __( 'Mobile', 'noorgfx' ),
							]),

							'sync' => [
								'id' => $prefix . 'hero_elements_spacing',
							],
						],

					],
				],

				'custom_title' => [
					'label' => $is_author ? __( 'Name & Avatar', 'noorgfx' ) : __('Title', 'noorgfx'),
					'options' => [
						[
							'heading_tag' => [
								'label' => __('Heading tag', 'noorgfx'),
								'type' => 'ct-select',
								'value' => 'h1',
								'view' => 'text',
								'design' => 'inline',
								'sync' => [
									'id' => $prefix . 'hero_elements_heading_tag',
								],
								'choices' => noorgfx_ordered_keys(
									[
										'h1' => 'H1',
										'h2' => 'H2',
										'h3' => 'H3',
										'h4' => 'H4',
										'h5' => 'H5',
										'h6' => 'H6',
									]
								),
							],
						],

						[
							$is_home ? [
								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => ['show_on_front' => 'posts'],
									'values_source' => 'global',
									'options' => [
										'title' => [
											'label' => __('Title', 'noorgfx'),
											'type' => 'text',
											'value' => __('Home', 'noorgfx'),
											'disableRevertButton' => true,
											'design' => 'inline',
										],
									]
								],
							] : []
						],

						[
							($is_archive || $is_bbpress || $is_home) ? [
								'has_category_label' => [
									'label' => __('Archive Label', 'noorgfx'),
									'type' => 'ct-switch',
									'value' => 'yes',
								]
							] : []
						],

						[
							$is_author ? [
								noorgfx_rand_md5() => [
									'type' => 'ct-group',
									'attr' => [ 'data-columns' => '1' ],
									'options' => [
										'has_author_avatar' => [
											'label' => __('Author avatar', 'noorgfx'),
											'type' => 'ct-switch',
											'value' => 'yes',
											'sync' => [
												'id' => $prefix . 'hero_elements_author_avatar',
											],
										],

										noorgfx_rand_md5() => [
											'type' => 'ct-condition',
											'condition' => [ 'has_author_avatar' => 'yes' ],
											'options' => [
												'author_avatar_size' => [
													'label' => __( 'Avatar Size', 'noorgfx' ),
													'type' => 'ct-number',
													'design' => 'inline',
													'value' => 60,
													'min' => 15,
													'max' => 300,
													'sync' => [
														'id' => $prefix . 'hero_elements_spacing',
													],
												],
											],
										],

									],
								],
							] : []
						],

						'custom_attribute' => [
							'label' => __('Custom Attribute', 'noorgfx'),
							'type' => 'text',
							'value' => ''
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['itemIndex' => '!0'],
							'options' => [
								'hero_item_spacing' => [
									'label' => __( 'Top Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'value' => 20,
									'min' => 0,
									'max' => 100,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
								],
							]
						]

					],
				],

				'custom_description' => [
					'label' => $custom_description_layer_name,
					'options' => [
						[
							$is_home ? [
								noorgfx_rand_md5() => [
									'type' => 'ct-condition',
									'condition' => [ 'show_on_front' => 'posts' ],
									'values_source' => 'global',
									'options' => [
										'description' => [
											'label' => false,
											'type' => 'textarea',
											'value' => '',
											'disableRevertButton' => true,
											'design' => 'block',
										],
									]
								],
							] : []
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ $prefix . 'hero_section' => 'type-1' ],
							'values_source' => 'parent',
							'options' => [

								'hero_item_max_width' => [
									'label' => __('Max Width', 'noorgfx'),
									'type' => 'ct-slider',
									'value' => 100,
									'min' => 10,
									'max' => 100,
									'defaultUnit' => '%',
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
								],

							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['itemIndex' => '!0'],
							'options' => [
								'hero_item_spacing' => [
									'label' => __( 'Top Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'value' => 20,
									'min' => 0,
									'max' => 100,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
								],
							]
						],

						'description_visibility' => [
							'label' => __( 'Visibility', 'noorgfx' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'value' => noorgfx_default_responsive_value([
								'desktop' => true,
								'tablet' => true,
								'mobile' => false,
							]),
							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx' ),
								'tablet' => __( 'Tablet', 'noorgfx' ),
								'mobile' => __( 'Mobile', 'noorgfx' ),
							]),

							'sync' => [
								'id' => $prefix . 'hero_elements_spacing',
							],
						],
					],
				],

				'custom_meta' => [
					// 'label' => __('Post Meta', 'noorgfx'),
					'label' => $is_author ? __( 'Author Meta', 'noorgfx' ) : __('Post Meta', 'noorgfx'),
					'clone' => true,
					'sync' => [
						'id' => $prefix . 'hero_elements_meta'
					],
					'options' => [
						$is_author ? [
							'page_meta_elements' => [
								'label' => __( 'Meta Elements', 'noorgfx' ),
								'type' => 'ct-checkboxes',
								'design' => 'block',
								'attr' => [ 'data-columns' => '2' ],
								'allow_empty' => true,
								'choices' => noorgfx_ordered_keys(
									[
										'joined' => __( 'Joined Date', 'noorgfx' ),
										'articles_count' => __( 'Articles', 'noorgfx' ),
										'comments' => __( 'Comments', 'noorgfx' ),
									]
								),

								'value' => [
									'joined' => true,
									'articles_count' => true,
									'comments' => true
								],
							],
						] : [],

						[
							$is_single ? [
								noorgfx_get_options('general/meta', [
									'skip_sync_id' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
									'is_page' => $is_page,
									'is_cpt' => $is_cpt,
									'computed_cpt' => $computed_cpt
								])
							] : []
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['itemIndex' => '!0'],
							'options' => [
								'hero_item_spacing' => [
									'label' => __( 'Top Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'value' => 20,
									'min' => 0,
									'max' => 100,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
								],
							]
						]
					],
				],

				'author_social_channels' => [
					'label' => __('Social Channels', 'noorgfx'),
					'options' => [
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => ['itemIndex' => '!0'],
							'options' => [
								'hero_item_spacing' => [
									'label' => __( 'Top Spacing', 'noorgfx' ),
									'type' => 'ct-slider',
									'value' => 20,
									'min' => 0,
									'max' => 100,
									'responsive' => true,
									'sync' => [
										'id' => $prefix . 'hero_elements_spacing',
									],
								],
							]
						],

						'link_target' => [
							'type'  => 'ct-switch',
							'label' => __( 'Open links in new tab', 'noorgfx' ),
							'value' => 'no',
						],

						'link_nofollow' => [
							'type'  => 'ct-switch',
							'label' => __( 'Set links to nofollow', 'noorgfx' ),
							'value' => 'no',
						],
					],
				],
			]
		], trim($prefix, '_')),

		noorgfx_rand_md5() => [
			'type' => 'ct-divider',
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ $prefix . 'hero_section' => 'type-1' ],
			'options' => [

				$prefix . 'hero_alignment1' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx' ),
					'value' => apply_filters(
						'noorgfx:hero:type-1:default-alignment',
						'CT_CSS_SKIP_RULE',
						trim($prefix, '_')
					),
					'view' => 'text',
					'attr' => [ 'data-type' => 'alignment' ],
					'responsive' => true,
					'design' => 'block',
					'sync' => 'live',
					'choices' => [
						'left' => '',
						'center' => '',
						'right' => '',
					],
				],

				$prefix . 'hero_margin' => [
					'label' => __( 'Container Bottom Spacing', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => '40px',
					'units' => noorgfx_units_config([
						[ 'unit' => 'px', 'min' => 0, 'max' => 300 ],
						['unit' => '', 'type' => 'custom'],
					]),
					'responsive' => true,
					'sync' => 'live',
					'divider' => 'top',
				],
			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ $prefix . 'hero_section' => 'type-2' ],
			'options' => array_merge([

				$prefix . 'hero_alignment2' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'noorgfx' ),
					'value' => 'center',
					'view' => 'text',
					'attr' => [ 'data-type' => 'alignment' ],
					'responsive' => true,
					'design' => 'block',
					'sync' => 'live',
					'choices' => [
						'start' => '',
						'center' => '',
						'end' => '',
					],
				],

				$prefix . 'hero_vertical_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Vertical Alignment', 'noorgfx' ),
					'value' => 'center',
					'view' => 'text',
					'design' => 'block',
					'responsive' => true,
					'attr' => [ 'data-type' => 'vertical-alignment' ],
					'sync' => 'live',

					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],
			]),
		],

	],

	[

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ $prefix . 'hero_section' => 'type-2' ],
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				$prefix . 'hero_structure' => [
					'label' => __( 'Container Width', 'noorgfx' ),
					'type' => 'ct-radio',
					'value' => 'narrow',
					'view' => 'text',
					'design' => 'block',
					'sync' => 'live',
					'choices' => [
						'normal' => __( 'Default', 'noorgfx' ),
						'narrow' => __( 'Narrow', 'noorgfx' ),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				$prefix . 'page_title_bg_type' => [
					'label' => __( 'Container Background Image', 'noorgfx' ),
					'type' => 'ct-radio',
					'value' => ($is_archive && ! $archives_have_hero || $is_author || $is_search) ? 'color' : 'featured_image',
					'view' => 'text',
					'design' => 'block',
					'attr' => [ 'data-radio-text' => 'small' ],
					'choices' => array_merge(($is_author || $is_search || $is_archive && ! $archives_have_hero) ? [] : [
						'featured_image' => __( 'Featured', 'noorgfx' ),
					], [
						'custom_image' => __( 'Custom', 'noorgfx' ),
						'color' => __( 'None', 'noorgfx' ),
					]),
					'sync' => [
						'id' => $prefix . 'hero_elements',
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'page_title_bg_type' => 'custom_image'
					],
					'options' => [
						$prefix . 'custom_hero_background' => [
							'label' => __('Custom Image', 'noorgfx'),
							'type' => 'ct-image-uploader',
							'design' => false,
							'divider' => 'top',
							'value' => [ 'attachment_id' => null ],
							'emptyLabel' => __('Select Image', 'noorgfx'),
							'filledLabel' => __('Change Image', 'noorgfx'),
							'sync' => [
								'id' => $prefix . 'hero_elements',
							],
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [
						$prefix . 'page_title_bg_type' => 'custom_image | featured_image',
					],
					'options' => [

						$prefix . 'page_title_image_size' => [
							'label' => __('Image Size', 'noorgfx'),
							'type' => 'ct-select',
							'value' => 'full',
							'view' => 'text',
							'design' => 'inline',
							'divider' => 'top',
							'choices' => noorgfx_ordered_keys(noorgfx_get_all_image_sizes()),
							'sync' => [
								'id' => $prefix . 'hero_elements',
							],
						],

						$prefix . 'parallax' => [
							'label' => __( 'Image Parallax Effect', 'noorgfx' ),
							'desc' => __( 'Choose for which devices you want to enable the parallax effect.', 'noorgfx' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'divider' => 'top',
							'allow_empty' => true,
							'sync' => 'live',
							'value' => noorgfx_default_responsive_value([
								'desktop' => false,
								'tablet' => false,
								'mobile' => false,
							]),
							'choices' => noorgfx_ordered_keys([
								'desktop' => __( 'Desktop', 'noorgfx' ),
								'tablet' => __( 'Tablet', 'noorgfx' ),
								'mobile' => __( 'Mobile', 'noorgfx' ),
							]),
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider',
				],

				$prefix . 'hero_height' => [
					'label' => __( 'Container Min Height', 'noorgfx' ),
					'type' => 'ct-slider',
					'value' => '250px',
					'design' => 'block',
					'units' => [
						[ 'unit' => 'px','min' => 0, 'max' => 1000 ],
						['unit' => '', 'type' => 'custom'],
					],
					'responsive' => true,
					'sync' => 'live'
				],
			],
		],
	],
];

$when_enabled_design_settings = [
	$design_options ? $design_options : [
		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				$prefix . 'hero_elements:array-ids:custom_title:enabled' => 'true',
			],
			'options' => [
				$prefix . 'pageTitleFont' => [
					'type' => 'ct-typography',
					'label' => __( 'Title Font', 'noorgfx' ),
					'value' => noorgfx_typography_default_values([
						'size' => '30px'
					]),
					'design' => 'block',
					'sync' => 'live'
				],

				$prefix . 'pageTitleFontColor' => [
					'label' => __( 'Title Font Color', 'noorgfx' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx' ),
							'id' => 'default',
							'inherit' => [
								'var(--theme-heading-1-color, var(--theme-headings-color))' => [
									$prefix . 'hero_elements:array-ids:custom_title:heading_tag' => 'h1'
								],

								'var(--theme-heading-2-color, var(--theme-headings-color))' => [
									$prefix . 'hero_elements:array-ids:custom_title:heading_tag' => 'h2'
								],

								'var(--theme-heading-3-color, var(--theme-headings-color))' => [
									$prefix . 'hero_elements:array-ids:custom_title:heading_tag' => 'h3'
								],

								'var(--theme-heading-4-color, var(--theme-headings-color))' => [
									$prefix . 'hero_elements:array-ids:custom_title:heading_tag' => 'h4'
								],

								'var(--theme-heading-5-color, var(--theme-headings-color))' => [
									$prefix . 'hero_elements:array-ids:custom_title:heading_tag' => 'h5'
								],

								'var(--theme-heading-6-color, var(--theme-headings-color))' => [
									$prefix . 'hero_elements:array-ids:custom_title:heading_tag' => 'h6'
								]
							]
						],
					],
				],
			]
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				'all' => [
					$prefix . 'hero_elements:array-ids-true:custom_meta:enabled' => 'true',
					'any' => [
						$prefix . 'hero_elements:array-ids:custom_meta:single_meta_elements/author' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:single_meta_elements/comments' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:single_meta_elements/date' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:single_meta_elements/updated' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:single_meta_elements/categories' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:single_meta_elements/tags' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:page_meta_elements/joined' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:page_meta_elements/articles_count' => 'true',
						$prefix . 'hero_elements:array-ids:custom_meta:page_meta_elements/comments' => 'true',
					]
				],
			],

			'options' => [
				$prefix . 'pageMetaFont' => [
					'type' => 'ct-typography',
					'label' => __( 'Meta Font', 'noorgfx' ),
					'value' => noorgfx_typography_default_values([
						'size' => '12px',
						'variation' => 'n6',
						'line-height' => '1.3',
						'text-transform' => 'uppercase',
					]),
					'design' => 'block',
					'sync' => 'live',
					'divider' => 'top:full',
				],

				$prefix . 'pageMetaFontColor' => [
					'label' => __( 'Meta Font Color', 'noorgfx' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],

						[
							'title' => __( 'Hover', 'noorgfx' ),
							'id' => 'hover',
							'inherit' => 'var(--theme-link-hover-color)'
						],
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-has-meta-category-button',
					'optionId' => $prefix . 'hero_elements',
					'options' => [
						$prefix . 'page_meta_button_type_font_colors' => [
							'label' => __( 'Meta Button Font', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'divider' => 'top',
							'noColor' => [ 'background' => 'var(--theme-text-color)'],
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-text-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-text-hover-color)'
								],
							],
						],

						$prefix . 'page_meta_button_type_background_colors' => [
							'label' => __( 'Meta Button Background', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'noColor' => [ 'background' => 'var(--theme-text-color)'],
							'sync' => 'live',
							'value' => [
								'default' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],

								'hover' => [
									'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
									'inherit' => 'var(--theme-button-background-initial-color)'
								],

								[
									'title' => __( 'Hover', 'noorgfx' ),
									'id' => 'hover',
									'inherit' => 'var(--theme-button-background-hover-color)'
								],
							],
						],
					]
				],

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				'all' => [
					$prefix . 'hero_elements:array-ids:custom_description:enabled' => 'true',
					'any' => [
						$prefix . 'hero_elements:array-ids:custom_description:description_visibility/desktop' => 'true',
						$prefix . 'hero_elements:array-ids:custom_description:description_visibility/tablet' => 'true',
						$prefix . 'hero_elements:array-ids:custom_description:description_visibility/mobile' => 'true',
					]
				]
			],
			'options' => [
				$prefix . 'pageExcerptFont' => [
					'type' => 'ct-typography',
					'label' => $is_single ? __( 'Excerpt Font', 'noorgfx' ) : noorgfx_safe_sprintf(
						// translators: %s entity of font
						__('%s Font', 'noorgfx'),
						$custom_description_layer_name
					),
					'value' => noorgfx_typography_default_values([]),
					'design' => 'block',
					'sync' => 'live',
					'divider' => 'top:full',
				],

				$prefix . 'pageExcerptColor' => [
					'label' => $is_single ? __('Excerpt Font Color', 'noorgfx' ) : noorgfx_safe_sprintf(
						// translators: %s entity of font color
						__('%s Font Color', 'noorgfx'),
						$custom_description_layer_name
					),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],
					],
				],
			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				$prefix . 'hero_elements:array-ids:author_social_channels:enabled' => 'true',
			],
			'options' => [

				$prefix . 'page_social_icons_color' => [
					'label' => __( 'Icons Color', 'noorgfx' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'divider' => 'top:full',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx' ),
							'id' => 'default',
							'inherit' => '#fff'
						],

						[
							'title' => __( 'Hover', 'noorgfx' ),
							'id' => 'hover',
							'inherit' => '#fff'
						],
					],
				],

				$prefix . 'page_social_icons_background' => [
					'label' => __( 'Icons Background Color', 'noorgfx' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'setting' => [ 'transport' => 'postMessage' ],

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Initial', 'noorgfx' ),
							'id' => 'default',
							'inherit' => 'var(--theme-palette-color-1)'
						],

						[
							'title' => __( 'Hover', 'noorgfx' ),
							'id' => 'hover',
							'inherit' => 'var(--theme-palette-color-2)'
						],
					],
				],

			],
		],

		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [
				$prefix . 'hero_elements:array-ids:breadcrumbs:enabled' => 'true',
			],
			'options' => [
				$prefix . 'breadcrumbsFont' => [
					'type' => 'ct-typography',
					'label' => __( 'Breadcrumbs Font', 'noorgfx' ),
					'value' => noorgfx_typography_default_values([]),
					'design' => 'block',
					'sync' => 'live',
					'divider' => 'top:full',
				],

				$prefix . 'breadcrumbsFontColor' => [
					'label' => __( 'Breadcrumbs Font Color', 'noorgfx' ),
					'type'  => 'ct-color-picker',
					'design' => 'inline',
					'sync' => 'live',

					'value' => [
						'default' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'initial' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],

						'hover' => [
							'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
						],
					],

					'pickers' => [
						[
							'title' => __( 'Text', 'noorgfx' ),
							'id' => 'default',
							'inherit' => 'var(--theme-text-color)'
						],

						[
							'title' => __( 'Link Initial', 'noorgfx' ),
							'id' => 'initial',
							'inherit' => 'var(--theme-link-initial-color)'
						],

						[
							'title' => __( 'Link Hover', 'noorgfx' ),
							'id' => 'hover',
							'inherit' => 'var(--theme-link-hover-color)'
						],
					],
				],
			]
		],
	],

	apply_filters(
		'noorgfx:options:page-title:design:before_breadcrumbs',
		[],
		trim($prefix, '_')
	),

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			$prefix . 'hero_section' => 'type-2'
		],
		'options' => [

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ $prefix . 'page_title_bg_type' => '!color' ],
				'options' => [

					$prefix . 'pageTitleOverlay' => [
						'label' => __( 'Image Overlay Color', 'noorgfx' ),
						'type' => 'ct-background',
						'design' => 'inline',
						'sync' => 'live',
						'divider' => 'top:full',
						'has_no_color' => true,
						'default_inherit_color' => 'rgba(18, 21, 25, 0.5)',
						'activeTabs' => ['color', 'gradient'],
						'value' => noorgfx_background_default_value([
							'backgroundColor' => [
								'default' => [
									'color' => 'CT_CSS_SKIP_RULE',
								],
							],
						])
					],
				],
			],

			$prefix . 'pageTitleBackground' => [
				'label' => __( 'Container Background', 'noorgfx' ),
				'type' => 'ct-background',
				'design' => 'inline',
				'sync' => 'live',
				'divider' => 'top:full',
				'value' => noorgfx_background_default_value([
					'backgroundColor' => [
						'default' => [
							'color' => 'var(--theme-palette-color-6)'
						],
					],
				])
			],

			$prefix . 'pageTitlePadding' => [
				'label' => __( 'Container Padding', 'noorgfx' ),
				'type' => 'ct-spacing',
				'divider' => 'top:full',
				'setting' => [ 'transport' => 'postMessage' ],
				'value' => noorgfx_spacing_value([
					'top' => '50px',
					'left' => 'auto',
					'right' => 'auto',
					'bottom' => '50px',
				]),
				'responsive' => true
			],

		],
	],
];

$when_enabled_settings = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => $when_enabled_general_settings
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => $when_enabled_design_settings
	],
];

$options_when_not_default = [
	$prefix . 'hero_enabled' => [
		'label' => $enabled_label,
		'type' => 'ct-panel',
		'switch' => true,
		'value' => $enabled_default,
		'wrapperAttr' => ['data-label' => 'heading-label'],
		'sync' => noorgfx_sync_whole_page([
			'prefix' => $prefix,
			'prefix_custom' => 'hero'
		]),
		'inner-options' => $when_enabled_settings,

		// 'disabled_notice' => empty($location_name) ? __(
		// 	'This page may not fully meet accessibility requirements, consider manually adding a heading tag to ensure compliance.',
		// 	'noorgfx'
		// ) : noorgfx_safe_sprintf(
		// 	__(
		// 		'The "%s" page may not fully meet accessibility requirements, consider manually adding a heading tag to ensure compliance.',
		// 		'noorgfx'
		// 	),
		// 	$location_name
		// )
	]
];

// options output for posts/pages
$options_when_default = [
	$prefix . 'has_hero_section' => [
		// 'label' => $is_page ? __('Page Title', 'noorgfx') : __(
		// 	'Post Title', 'noorgfx'
		// ),
		'label' => false,
		'type' => 'ct-radio',
		'value' => 'default',
		'view' => 'text',
		'disableRevertButton' => true,
		'design' => $is_single ? 'block' : 'inline',
		'wrapperAttr' => [ 'data-spacing' => 'custom' ],
		'choices' => [
			'default' => __( 'Inherit', 'noorgfx' ),
			'enabled' => __( 'Custom', 'noorgfx' ),
			'disabled' => __( 'Disabled', 'noorgfx' ),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [ $prefix . 'has_hero_section' => 'default' ],
		'options' => [
			noorgfx_rand_md5() => [
				'type' => 'ct-notification',
				'attr' => [ 'data-spacing' => 'custom' ],
				'text' => __( 'By default these options are inherited from Customizer options.', 'noorgfx' ),
			],
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [$prefix . 'has_hero_section' => 'enabled'],
		'options' => $when_enabled_settings
	],
];

// options output for taxonomies
if (! $is_single) {
	$options_when_default = [
		noorgfx_rand_md5() => [
			'title' => __( 'General', 'noorgfx' ),
			'type' => 'tab',
			'options' => [
				$prefix . 'has_hero_section' => [
					'label' => __('Page Title', 'noorgfx'),
					'type' => 'ct-radio',
					'value' => 'default',
					'view' => 'text',
					'disableRevertButton' => true,
					'design' => $is_single ? 'block' : 'inline',
					'wrapperAttr' => [ 'data-spacing' => 'custom' ],
					'choices' => [
						'default' => __( 'Inherit', 'noorgfx' ),
						'enabled' => __( 'Custom', 'noorgfx' ),
						'disabled' => __( 'Disabled', 'noorgfx' ),
					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [$prefix . 'has_hero_section' => 'enabled'],
					'options' => $when_enabled_general_settings
				],
			]
		],

		noorgfx_rand_md5() => [
			'title' => __( 'Design', 'noorgfx' ),
			'type' => 'tab',
			'options' => [

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [$prefix . 'has_hero_section' => 'enabled'],
					'options' => $when_enabled_design_settings
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [$prefix . 'has_hero_section' => '!enabled'],
					'options' => [
						noorgfx_rand_md5() => [
							'type' => 'ct-notification',
							'attr' => ['data-label' => 'no-label'],
							'text' => __('Options will appear here only if you will set Custom in Page Title option.', 'noorgfx')
						]
					]
				],
			]
		],
	];
}

$options = $has_default ? $options_when_default : $options_when_not_default;

