<?php

if (! isset($skip_sync_id)) {
	$skip_sync_id = null;
}

if (! isset($has_meta_elements_wrapper_attr)) {
	$has_meta_elements_wrapper_attr = true;
}

if (! isset($sync_id)) {
	$sync_id = null;
}

if (! isset($is_cpt)) {
	$is_cpt = false;
}

if (! isset($has_label)) {
	$has_label = false;
}

if (! isset($prefix)) {
	$prefix = '';
} else {
	$prefix = $prefix . '_';
}

if (! isset($is_page)) {
	$is_page = false;
}

if (! isset($item_style_type)) {
	$item_style_type = 'ct-radio';
}

if (! isset($item_divider_type)) {
	$item_divider_type = 'ct-radio';
}

if (! isset($computed_cpt) || ! $computed_cpt) {
	$computed_cpt = 'single_blog_post';

	if ($is_page) {
		$computed_cpt = 'single_page';
	}

	if (isset($post_type)) {
		if ($post_type !== 'post' && $post_type !== 'page') {
			$computed_cpt = $post_type . '_single';
		}
	}
}

if (! isset($post_type)) {
	$post_type = 'post';

	if ($computed_cpt === 'product') {
		$post_type = 'product';
	}

	if ($computed_cpt === 'single_page') {
		$post_type = 'page';
	}

	$post_types = noorgfx_manager()->post_types->get_supported_post_types();

	foreach ($post_types as $single_post_type) {
		if (
			$computed_cpt === $single_post_type . '_archive'
			||
			$computed_cpt === $single_post_type . '_single'
		) {
			$post_type = $single_post_type;
		}
	}
}

$taxonomies = array_values(array_diff(
	get_object_taxonomies($post_type),
	['post_format']
));

$taxonomies_options = [];

foreach ($taxonomies as $taxonomy) {
	$taxonomy_object = get_taxonomy($taxonomy);

	if (! $taxonomy_object->public) {
		continue;
	}

	$taxonomies_options[$taxonomy] = $taxonomy_object->label;
}

if (! isset($meta_elements)) {
	$meta_elements = noorgfx_post_meta_defaults([
		[
			'id' => 'author',
			'enabled' => true,
		],

		[
			'id' => 'post_date',
			'enabled' => true,
		],

		[
			'id' => 'updated_date',
			'enabled' => false,
		],

		[
			'id' => 'categories',
			'enabled' => true,
		],

		[
			'id' => 'comments',
			'enabled' => true,
		]
	]);
}

$comments_options = apply_filters(
	'noorgfx:general:card:options:icon',
	[],
	'blc blc-comments'
);

$comments_options_conditions = null;

if (! empty($comments_options)) {
	$comments_options_conditions = [
		'meta_type' => 'icons',
	];

	$comments_options = [
		noorgfx_rand_md5() => [
			'type' => 'ct-condition',
			'condition' => [ 'meta_type' => 'icons' ],
			'values_source' => 'parent',
			'options' => $comments_options
		]
	];
}

$meta_elements = apply_filters(
	'noorgfx:options:meta:meta_default_elements',
	$meta_elements,
	$prefix,
	$computed_cpt
);

$date_format_options = [
	'date_format_source' => [
		'label' => __('Date Format', 'noorgfx'),
		'type' => 'ct-radio',
		'value' => 'default',
		'view' => 'text',
		'design' => 'block',
		'choices' => [
			'default' => __( 'Default', 'noorgfx' ),
			'custom' => __( 'Custom', 'noorgfx' ),
		],
	],

	noorgfx_rand_md5() => [
		'type' => 'ct-condition',
		'condition' => [
			'date_format_source' => 'custom'
		],
		'options' => [
			'date_format' => [
				'label' => false,
				'type' => 'text',
				'design' => 'block',
				'value' => 'M j, Y',
				// translators: The interpolations addes a html link around the word.
				'desc' => noorgfx_safe_sprintf(
					__('Date format %sinstructions%s.', 'noorgfx'),
					'<a href="https://wordpress.org/support/article/formatting-date-and-time/#format-string-examples" target="_blank">',
					'</a>'
				),
				'disableRevertButton' => true,
			],
		],
	],
];

$options = [
	$prefix . 'meta_elements' => [
		'label' => $has_label ? __( 'Meta Elements', 'noorgfx' ) : false,
		'type' => 'ct-layers',
		'itemClass' => $has_meta_elements_wrapper_attr ? 'ct-inner-layer' : '',
		// 'manageable' => true,
		'value' => $meta_elements,
		'sync' => $sync_id ? $sync_id : 'refresh',

		'settings' => array_merge([
			'author' => [
				'label' => __('Author', 'noorgfx'),
				'options' => [
					'has_author_avatar' => [
						'label' => __( 'Author Avatar', 'noorgfx' ),
						'type' => 'ct-switch',
						'value' => 'no',
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => ['has_author_avatar' => 'yes'],
						'options' => [
							'avatar_size' => array_merge([
								'label' => __('Avatar Size', 'noorgfx'),
								'type' => 'ct-number',
								'design' => 'inline',
								'value' => 25,
								'min' => 15,
								'max' => 50,
							], $skip_sync_id ? [
								'sync' => $skip_sync_id
							] : []),
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [ 'meta_type' => 'label' ],
						'values_source' => 'parent',
						'options' => [
							'label' => array_merge([
								'label' => __('Label', 'noorgfx'),
								'type' => 'text',
								'design' => 'inline',
								'value' => __('By', 'noorgfx')
							], $skip_sync_id ? [
								'sync' => $skip_sync_id
							] : []),
						],
					],

					noorgfx_rand_md5() => [
						'type' => 'ct-condition',
						'condition' => [
							'meta_type' => 'icons',
						],
						'values_source' => 'parent',
						'options' => [

							noorgfx_rand_md5() => [
								'type' => 'ct-condition',
								'condition' => [
									'has_author_avatar' => 'no',
								],
								'options' => apply_filters(
									'noorgfx:general:card:options:icon',
									[],
									'blc blc-feather'
								)
							],

						]
					],

				],
			],

			'comments' => [
				'label' => __('Comments', 'noorgfx'),
				'options' => $comments_options,
				'options_condition' => $comments_options_conditions,
			],

			'post_date' => [
				'label' => __('Published Date', 'noorgfx'),
				'options' => [
					$date_format_options,

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'meta_type' => 'label' ],
							'values_source' => 'parent',
							'options' => [
								'label' => array_merge([
									'label' => __('Label', 'noorgfx'),
									'type' => 'text',
									'design' => 'inline',
									'value' => __('On', 'noorgfx')
								], $skip_sync_id ? [
									'sync' => $skip_sync_id
								] : [])
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'meta_type' => 'icons' ],
							'values_source' => 'parent',
							'options' => apply_filters(
								'noorgfx:general:card:options:icon',
								[],
								'blc blc-clock'
							)
						],
					],

				],
			],

			'updated_date' => [
				'label' => __('Updated Date', 'noorgfx'),
				'options' => [
					$date_format_options,

					[
						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'meta_type' => 'label' ],
							'values_source' => 'parent',
							'options' => [
								'label' => array_merge([
									'label' => __('Label', 'noorgfx'),
									'type' => 'text',
									'design' => 'inline',
									'value' => __('On', 'noorgfx'),	
								], $skip_sync_id ? [
									'sync' => $skip_sync_id
								] : [])
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'meta_type' => 'icons' ],
							'values_source' => 'parent',
							'options' => apply_filters(
								'noorgfx:general:card:options:icon',
								[],
								'blc blc-clock'
							)
						],
					],
				],
			],
		], ! empty($taxonomies_options) ? [
			'categories' => [
				'label' => __('Taxonomies', 'noorgfx'),
				'clone' => 5,
				'options' => [
					[
						'taxonomy' => [
							'label' => __( 'Taxonomy Source', 'noorgfx' ),
							'type' => 'ct-select',
							'design' => 'block',
							'setting' => [ 'transport' => 'postMessage' ],
							'view' => 'text',
							'choices' => noorgfx_ordered_keys($taxonomies_options),
							'value' => noorgfx_maybe_get_matching_taxonomy($post_type),
						],

						'style' => [
							'label' => __( 'Style', 'noorgfx' ),
							'type' => 'ct-select',
							'value' => 'simple',
							'design' => 'block',
							'setting' => [ 'transport' => 'postMessage' ],
							'view' => 'text',
							'choices' => noorgfx_ordered_keys(
								[
									'simple' => __( 'Default', 'noorgfx' ),
									'pill' => __( 'Button', 'noorgfx' ),
									'underline' => __( 'Underline', 'noorgfx' ),
								]
							),
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'meta_type' => 'label' ],
							'values_source' => 'parent',
							'options' => [
								'label' => array_merge([
									'label' => __('Label', 'noorgfx'),
									'type' => 'text',
									'design' => 'inline',
									'value' => __('In', 'noorgfx')
								], $skip_sync_id ? [
									'sync' => $skip_sync_id
								] : []),
							],
						],

						noorgfx_rand_md5() => [
							'type' => 'ct-condition',
							'condition' => [ 'meta_type' => 'icons' ],
							'values_source' => 'parent',
							'options' => apply_filters(
								'noorgfx:general:card:options:icon',
								[],
								'blc blc-box'
							)
						],
					],

					(
						function_exists('blc_get_ext')
						&&
						blc_get_ext('post-types-extra')
						&&
						isset(blc_get_ext('post-types-extra')->taxonomies_customization)
						&&
						blc_get_ext('post-types-extra')->taxonomies_customization
					) ? [
						'has_term_accent_color' => [
							'type'  => 'ct-switch',
							'label' => __('Terms accent color', 'noorgfx'),
							'value' => 'yes',
						]
					] : []
				],
			]
		] : [], apply_filters(
			'noorgfx:options:meta:meta_elements',
			[],
			$prefix,
			$computed_cpt
		)),
	],

	$prefix . 'meta_type' => array_merge([
		'label' => __('Items Style', 'noorgfx'),
		'type' => $item_style_type,
		'value' => 'simple',
		'view' => 'text',
		'choices' => [
			'simple' => __('Simple', 'noorgfx'),
			'label' => __('Labels', 'noorgfx'),
			'icons' => __('Icons', 'noorgfx'),
		],
	], $sync_id ? [
		'sync' => $sync_id
	] : []),

	$prefix . 'meta_divider' => array_merge([
		'label' => __('Items Divider', 'noorgfx'),
		'type' => $item_divider_type,
		'value' => 'slash',
		'view' => 'text',
		'attr' => [ 'data-type' => 'meta-divider' ],
		'choices' => [
			'none' => __('none', 'noorgfx'),
			'slash' => '',
			'line' => '',
			'circle' => '',
		],
	], $skip_sync_id ? [
		'sync' => $skip_sync_id
	] : [
		'sync' => 'live'
	]),
];

