<?php
/**
 * General options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [
	'general_section_options' => [
		'type' => 'ct-options',
		'setting' => [ 'transport' => 'postMessage' ],
		'customizer_section' => 'layout',
		'inner-options' => [

			noorgfx_get_options('general/layout'),

			noorgfx_get_options('general/buttons'),

			noorgfx_get_options('general/breadcrumbs'),

			noorgfx_get_options('general/form-elements'),

			noorgfx_get_options('general/content-elements'),

			noorgfx_get_options('engagement/social-accounts'),

			noorgfx_get_options('engagement/general'),

			noorgfx_get_options('general/back-to-top'),

			[
				'has_passepartout' => [
					'label' => __( 'Website Frame', 'noorgfx' ),
					'type' => 'ct-panel',
					'switch' => true,
					'value' => 'no',
					'setting' => [ 'transport' => 'postMessage' ],
					'inner-options' => [

						'passepartoutSize' => [
							'label' => __( 'Frame Size', 'noorgfx' ),
							'type' => 'ct-slider',
							'min' => 0,
							'max' => 50,
							'responsive' => true,
							'value' => 10,
							'setting' => [ 'transport' => 'postMessage' ],
						],

						'passepartoutColor' => [
							'label' => __( 'Frame Color', 'noorgfx' ),
							'type'  => 'ct-color-picker',
							'design' => 'inline',
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => [
								'default' => [
									'color' => 'var(--theme-palette-color-1)',
								],
							],

							'pickers' => [
								[
									'title' => __( 'Initial', 'noorgfx' ),
									'id' => 'default',
								],
							],
						],

					],
				],

				noorgfx_rand_md5() => [
					'type' => 'ct-divider'
				],

				noorgfx_rand_md5() => [
					'label' => __('Manage Options', 'noorgfx'),
					'type' => 'ct-panel',
					'setting' => ['transport' => 'postMessage'],
					'inner-options' => [
						apply_filters('noorgfx:options:manage-options:top', []),

						[
							noorgfx_rand_md5() => [
								'type' => 'ct-title',
								'label' => __( 'Reset Options', 'noorgfx' ),
								'desc' => __( 'Click this button if you want to reset all settings to their default values.', 'noorgfx' ),
							],

							'noorgfx-reset-customizer-options' => [
								'label' => false,
								'disableRevertButton' => true,
								'type' => 'ct-customizer-reset-options',
								'value' => ''
							]
						]
					],
				]
			],

			apply_filters('noorgfx:options:general:bottom', [])
		],
	],

	'customizer_color_scheme' => [
		'label' => __( 'Color scheme', 'noorgfx' ),
		'type' => 'hidden',
		'label' => '',
		'value' => 'no',
		'setting' => [ 'transport' => 'postMessage' ],
	],
];
