<?php
/**
 * Content elements options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$options = [

	'content_elements_panel' => [
		'label' => __( 'Entry Content', 'noorgfx' ),
		'type' => 'ct-panel',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => [

			'contentSpacing' => [
				'label' => __( 'Content Spacing', 'noorgfx' ),
				'type' => 'ct-select',
				'value' => 'comfortable',
				'view' => 'text',
				'design' => 'inline',
				'choices' => noorgfx_ordered_keys([
					'none' => __( 'None', 'noorgfx' ),
					'compact' => __( 'Compact', 'noorgfx' ),
					'comfortable' => __( 'Comfortable', 'noorgfx' ),
					'spacious' => __( 'Spacious', 'noorgfx' ),
				]),
				'setting' => [ 'transport' => 'postMessage' ],
				'desc' => __( 'Adjusts the spacing between the Gutenberg blocks.', 'noorgfx' ),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-divider',
			],

			'content_link_type' => [
				'label' => __( 'Links Type', 'noorgfx' ),
				'type' => 'ct-select',
				'value' => 'type-2',
				'view' => 'text',
				'design' => 'inline',
				'setting' => [ 'transport' => 'postMessage' ],
				'choices' => noorgfx_ordered_keys(
					[
						'type-1' => __( 'Type 1', 'noorgfx' ),
						'type-2' => __( 'Type 2', 'noorgfx' ),
						'type-3' => __( 'Type 3', 'noorgfx' ),
						'type-4' => __( 'Type 4', 'noorgfx' ),
						'type-5' => __( 'Type 5', 'noorgfx' ),
					]
				),
			],
		],
	],

];
