<?php

/**
 * Breadcrumbs options
 *
 * @copyright 2019-present Norgroup Themes
 * @license   http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @package   Noorgfx
 */

$source_options = [
	'default' => __('Default', 'noorgfx')
];

$is_shop = class_exists( 'woocommerce' );
$is_pro = function_exists('blc_site_has_feature') && blc_site_has_feature();

if (function_exists('rank_math_the_breadcrumbs')) {
	ob_start();
	rank_math_the_breadcrumbs();
	$content = ob_get_clean();

	if (! empty($content)) {
		$source_options['rankmath'] = __('RankMath', 'noorgfx');
	}
}

if (function_exists('yoast_breadcrumb')) {
	ob_start();
	yoast_breadcrumb('<div>', '</div>');
	$content = ob_get_clean();

	if (! empty($content)) {
		$source_options['yoast'] = __('Yoast', 'noorgfx');
	}
}

if (function_exists('seopress_display_breadcrumbs')) {
	$source_options['seopress'] = __('SeoPress', 'noorgfx');
}

if (function_exists('bcn_display')) {
	$source_options['bcnxt'] = __('Breadcrumb NavXT', 'noorgfx');
}

if (class_exists('\SlimSEO\Breadcrumbs')) {
	$source_options['slimseo'] = __('SlimSEO', 'noorgfx');
}

$breadcrumbs_options = [
	noorgfx_rand_md5() => [
		'title' => __( 'General', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			$is_pro ? [
				'breadcrumb_separator_icon_source' => [
					'label' => __('Separator Icon Source', 'noorgfx'),
					'type' => 'ct-radio',
					'value' => 'default',
					'view' => 'text',
					'design' => 'block',
					'divider' => 'bottom',
					'choices' => [
						'default' => __('Default', 'noorgfx'),
						'custom' => __('Custom', 'noorgfx'),
					],
					'sync' => noorgfx_sync_whole_page([
						'loader_selector' => '.ct-breadcrumbs'
					]),
				],
			] : [],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => $is_pro
					? [
						'breadcrumb_separator_icon_source' => 'default',
					]
					: [
						'breadcrumb_separator_icon_source' => '! not_existing',
					],
				'options' => [
					'breadcrumb_separator' => [
						'label' => __('Separator Icon', 'noorgfx'),
						'type' => 'ct-image-picker',
						'value' => 'type-1',
						'attr' => [ 'data-columns' => '3' ],
						'choices' => [
							'type-1' => [
								'src'   => noorgfx_image_picker_file( 'breadcrumb-sep-1' ),
								'title' => __( 'Type 1', 'noorgfx' ),
							],

							'type-2' => [
								'src'   => noorgfx_image_picker_file( 'breadcrumb-sep-2' ),
								'title' => __( 'Type 2', 'noorgfx' ),
							],

							'type-3' => [
								'src'   => noorgfx_image_picker_file( 'breadcrumb-sep-3' ),
								'title' => __( 'Type 3', 'noorgfx' ),
							],
						],
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-breadcrumbs'
						]),
					],
				],
			],

			$is_pro ? [
				noorgfx_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => ['breadcrumb_separator_icon_source' => 'custom'],
					'options' => [
	
						'breadcrumb_custom_separator' => [
							'type' => 'icon-picker',
							'label' => __('Icon', 'noorgfx'),
							'design' => 'inline',
							'value' => [
								'icon' => 'blc blc-arrow-right',
							],
							'sync' => noorgfx_sync_whole_page([
								'loader_selector' => '.ct-breadcrumbs'
							]),
						],
	
						'breadcrumbs_separator_size' => [
							'label' => __( 'Icon Size', 'noorgfx' ),
							'type' => 'ct-slider',
							'min' => 5,
							'max' => 50,
							'value' => 8,
							'responsive' => true,
							'divider' => 'top',
							'setting' => [ 'transport' => 'postMessage' ],
						],
					],
				],
			] : [],

			'breadcrumb_home_item' => [
				'label' => __('Home Item', 'noorgfx'),
				'type' => 'ct-radio',
				'value' => 'text',
				'view' => 'text',
				'divider' => 'top:full',
				'choices' => [
					'text' => __('Text', 'noorgfx'),
					'icon' => __('Icon', 'noorgfx'),
				],
				'sync' => noorgfx_sync_whole_page([
					'loader_selector' => '.ct-breadcrumbs'
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'breadcrumb_home_item' => 'text' ],
				'options' => [

					'breadcrumb_home_text' => [
						'label' => __( 'Home Page Text', 'noorgfx' ),
						'type' => 'text',
						'design' => 'block',
						'value' => __( 'Home', 'noorgfx' ),
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-breadcrumbs'
						]),
					],

				],
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'breadcrumb_home_item' => 'icon' ],
				'options' => $is_pro ? [

					'breadcrumb_home_icon' => [
						'type' => 'icon-picker',
						'label' => __(
							'Icon',
							'noorgfx'
						),
						'design' => 'inline',
						'divider' => 'top',
						'value' => [
							'icon' => 'blc blc-home-alt',
						],
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-breadcrumbs'
						]),
					],

					'breadcrumbs_home_icon_size' => [
						'label' => __( 'Icon Size', 'noorgfx' ),
						'type' => 'ct-slider',
						'min' => 5,
						'max' => 50,
						'value' => 15,
						'responsive' => true,
						'divider' => 'top',
						'setting' => [ 'transport' => 'postMessage' ],
					],
				] : []
			],

			'breadcrumb_page_title' => [
				'label' => __( 'Single Page/Post Title', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'yes',
				'divider' => 'top:full',
				'sync' => noorgfx_sync_whole_page([
					'loader_selector' => '.ct-breadcrumbs'
				]),
			],

			'breadcrumb_single_taxonomy_title' => [
				'label' => __( 'Single Page/Post Taxonomy Title', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'yes',
				'divider' => 'top:full',
				'sync' => noorgfx_sync_whole_page([
					'loader_selector' => '.ct-breadcrumbs'
				]),
			],

			'breadcrumb_taxonomy_title' => [
				'label' => __( 'Archive Taxonomy Title', 'noorgfx' ),
				'type' => 'ct-switch',
				'value' => 'yes',
				'sync' => noorgfx_sync_whole_page([
					'loader_selector' => '.ct-breadcrumbs'
				]),
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => ['show_on_front' => '!posts'],
				'values_source' => 'global',
				'options' => [
					'breadcrumb_blog_item' => [
						'label' => __('Blog Page in Breadcrumbs', 'noorgfx'),
						'type' => 'ct-switch',
						'value' => 'no',
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-breadcrumbs'
						]),
					],
				]
			],

			noorgfx_rand_md5() => [
				'options' => $is_shop ? [
						'breadcrumb_shop_item' => [
						'label' => __('Shop Page in Breadcrumbs', 'noorgfx'),
						'type' => 'ct-switch',
						'value' => 'no',
						'sync' => noorgfx_sync_whole_page([
							'loader_selector' => '.ct-breadcrumbs'
						]),
					]
				] : []
			],

		],
	],

	noorgfx_rand_md5() => [
		'title' => __( 'Design', 'noorgfx' ),
		'type' => 'tab',
		'options' => [

			'breadcrumbsFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Breadcrumbs Font', 'noorgfx' ),
				'value' => noorgfx_typography_default_values([
					'size' => '12px',
					'variation' => 'n6',
					'text-transform' => 'uppercase',
				]),
				'design' => 'block',
				'sync' => 'live',
				'divider' => 'top:full',
			],

			'breadcrumbsFontColor' => [
				'label' => __( 'Breadcrumbs Font Color', 'noorgfx' ),
				'type'  => 'ct-color-picker',
				'design' => 'inline',
				'sync' => 'live',

				'value' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'initial' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],

					'hover' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT'),
					],
				],

				'pickers' => [
					[
						'title' => __( 'Text', 'noorgfx' ),
						'id' => 'default',
						'inherit' => 'var(--theme-text-color)'
					],

					[
						'title' => __( 'Link Initial', 'noorgfx' ),
						'id' => 'initial',
						'inherit' => 'var(--theme-link-initial-color)'
					],

					[
						'title' => __( 'Link Hover', 'noorgfx' ),
						'id' => 'hover',
						'inherit' => 'var(--theme-link-hover-color)'
					],
				],
			],

		],
	],
];

$options = [

	'breadcrumbs_panel' => [
		'label' => __( 'Breadcrumbs', 'noorgfx' ),
		'type' => 'ct-panel',
		'setting' => [ 'transport' => 'postMessage' ],
		'inner-options' => array_merge(count($source_options) > 1 ? [
			'breadcrumbs_source' => [
				'label' => __('Breadcrumbs Source', 'noorgfx'),
				'type' => 'ct-select',
				'value' => 'default',
				'choices' => $source_options,
				'divider' => 'bottom:full'
			],

			noorgfx_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [
					'breadcrumbs_source' => 'default'
				],
				'options' => $breadcrumbs_options
			]
		] : $breadcrumbs_options)
	],

];
