<?php

if (! function_exists('noorgfx_output_header')) {
	function noorgfx_output_header() {
		global $noorgfx_has_default_header;

		$show_header = apply_filters('noorgfx:builder:header:enabled', true);

		if (! $show_header) {
			return;
		}

		if (
			function_exists('blc_get_content_block_that_matches')
			&&
			blc_get_content_block_that_matches([
				'template_type' => 'header'
			])
		) {
			echo noorgfx_html_tag(
				'header',
				array_merge(
					[
						'id' => 'header',
					],
					noorgfx_schema_org_definitions('header', ['array' => true])
				),
				blc_render_content_block(
					blc_get_content_block_that_matches([
						'template_type' => 'header'
					])
				)
			);

			return;
		}

		if (
			function_exists('boostify_header_active')
			&&
			boostify_header_active()
		) {
			boostify_get_header_template();
			return;
		}

		if (function_exists('hfe_render_header') && hfe_header_enabled()) {
			hfe_render_header();
			return;
		}

		if (
			function_exists('elementor_theme_do_location')
			&&
			elementor_theme_do_location('header')
		) {
			return;
		}

		if (class_exists('FLThemeBuilderLayoutData')) {
			$header_ids = FLThemeBuilderLayoutData::get_current_page_header_ids();

			if (! empty($header_ids)) {
				FLThemeBuilderLayoutRenderer::render_header();
			}
		}

		$header_result = Noorgfx_Manager::instance()->header_builder->render();

		if (! empty($header_result)) {
			$noorgfx_has_default_header = true;
			echo $header_result;
		}
	}
}

if (! function_exists('noorgfx_output_footer')) {
	function noorgfx_output_footer() {
		$show_footer = apply_filters('noorgfx:builder:footer:enabled', true);

		if (! $show_footer) {
			return;
		}

		if (
			function_exists('blc_get_content_block_that_matches')
			&&
			blc_get_content_block_that_matches([
				'template_type' => 'footer'
			])
		) {
			echo noorgfx_html_tag(
				'footer',
				array_merge([
					'id' => 'footer'
				], noorgfx_schema_org_definitions('footer', [
					'array' => true
				])),
				blc_render_content_block(
					blc_get_content_block_that_matches([
						'template_type' => 'footer'
					])
				)
			);
			return;
		}

		if (
			function_exists('boostify_footer_active')
			&&
			boostify_footer_active()
		) {
			boostify_get_footer_template();
			return;
		}

		if (function_exists('hfe_footer_enabled') && hfe_footer_enabled()) {
			hfe_render_footer();
			return;
		}

		if (
			function_exists('elementor_theme_do_location')
			&&
			elementor_theme_do_location('footer')
		) {
			return;
		}

		if (class_exists('FLThemeBuilderLayoutData')) {
			$footer_ids = FLThemeBuilderLayoutData::get_current_page_footer_ids();

			if (! empty($footer_ids)) {
				FLThemeBuilderLayoutRenderer::render_footer();
			}
		}

		echo noorgfx_manager()->footer_builder->render();
	}
}
