<?php

add_filter(
	'fl_theme_builder_part_hooks',
	function () {
		return [
			[
				'label' => __('Header', 'noorgfx'),
				'hooks' => [
					'noorgfx:header:before' => __('Before Header', 'noorgfx'),
					'noorgfx:header:after'  => __('After Header', 'noorgfx'),
				]
			],

			[
				'label' => __('Content', 'noorgfx'),
				'hooks' => [
					'noorgfx:content:before' => __('Before Content', 'noorgfx'),
					'noorgfx:content:top' => __('Top Content', 'noorgfx'),
					'noorgfx:content:bottom' => __('Bottom Content', 'noorgfx'),
					'noorgfx:content:after' => __('After Content', 'noorgfx'),
				]
			],

			[

				'label' => __('Footer', 'noorgfx'),
				'hooks' => [
					'noorgfx:footer:before' => __('Before Footer', 'noorgfx'),
					'noorgfx:footer:after' => __('After Footer', 'noorgfx'),
				]
			]
		];
	}
);

add_filter('fl_builder_settings_form_defaults', function ($defaults, $form_type) {
	if ('global' === $form_type) {
		$defaults->row_padding_top = '0';
		$defaults->row_padding_right = '0';
		$defaults->row_padding_bottom = '0';
		$defaults->row_padding_left = '0';
		$defaults->row_width = '1290';
		$defaults->medium_breakpoint = '1000';
		$defaults->responsive_breakpoint = '690';
	}

	return $defaults;
}, 10, 2);