<?php


$product_view_type = noorgfx_get_product_view_type();

$woo_single_layout = [];

if (
	$product_view_type === 'default-gallery'
	||
	$product_view_type === 'stacked-gallery'
) {
	$default_product_layout = noorgfx_get_woo_single_layout_defaults();

	$woo_single_layout = noorgfx_get_theme_mod(
		'woo_single_layout',
		$default_product_layout
	);
} else {
	$woo_single_split_layout = noorgfx_get_theme_mod(
		'woo_single_split_layout',
		[
			'left' => noorgfx_get_woo_single_layout_defaults('left'),

			'right' => noorgfx_get_woo_single_layout_defaults('right')
		]
	);

	$woo_single_layout_left = $woo_single_split_layout['left'];
	$woo_single_layout_right = $woo_single_split_layout['right'];

	$woo_single_layout = array_merge(
		$woo_single_layout_left,
		$woo_single_layout_right
	);
}

foreach ($woo_single_layout as $layer) {
	if (! $layer['enabled'] ) {
		continue;
	}

	$selectors_map = [
		'product_title' => '.entry-summary-items > .entry-title',
		'product_rating' => '.entry-summary-items > .woocommerce-product-rating',
		'product_price' => '.entry-summary-items > .price',
		'product_desc' => '.entry-summary-items > .woocommerce-product-details__short-description',
		'product_add_to_cart' => '.entry-summary-items > .ct-product-add-to-cart',
		'product_meta' => '.entry-summary-items > .product_meta',
		'product_payment_methods' => '.entry-summary-items > .ct-payment-methods',
		'additional_info' => '.entry-summary-items > .ct-product-additional-info',
		'product_tabs' => '.entry-summary-items > .woocommerce-tabs',
		'product_breadcrumbs' => '.entry-summary-items > .ct-breadcrumbs',

		// component
		'product_brands' => '.entry-summary-items > .ct-product-brands-single',
		'product_sharebox' => '.entry-summary-items > .ct-share-box',
		'free_shipping' => '.entry-summary-items > .ct-shipping-progress',
		'product_actions' => '.entry-summary-items > .ct-product-additional-actions',
		'product_countdown' => '.entry-summary-items > .ct-product-sale-countdown',
		'product_stock_scarcity' => '.entry-summary-items > .ct-product-stock-scarcity',
		'product_waitlist' => '.entry-summary-items > .ct-product-waitlist',
		'product_attributes' => '.entry-summary-items > .ct-product-attributes',
	];

	$spacing_default = 10;

	if (
		$layer['id'] === 'product_price'
		||
		$layer['id'] === 'product_desc'
		||
		$layer['id'] === 'product_add_to_cart'
		||
		$layer['id'] === 'divider'
		||
		$layer['id'] === 'product_actions'
		||
		$layer['id'] === 'product_countdown'
		||
		$layer['id'] === 'product_waitlist'
	) {
		$spacing_default = 35;
	}

	$spacing = noorgfx_akg('spacing', $layer, $spacing_default);

	if (
		isset($selectors_map[$layer['id']])
		&&
		(
			intval($spacing) !== $spacing_default
			||
			$spacing_default === 35
		)
	) {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => $selectors_map[$layer['id']],
			'variableName' => 'product-element-spacing',
			'value' => $spacing
		]);
	}

	if ( $layer['id'] === 'product_sharebox' ) {
		$share_icons_size = noorgfx_akg('share_box_icon_size', $layer, '15px');
		$share_box_icons_spacing = noorgfx_akg('share_box_icons_spacing', $layer, '15px');

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => $selectors_map[$layer['id']],
			'variableName' => 'theme-icon-size',
			'value' => $share_icons_size,
			'unit' => ''
		]);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => $selectors_map[$layer['id']],
			'variableName' => 'items-spacing',
			'value' => $share_box_icons_spacing,
			'unit' => ''
		]);
	}

	if ($layer['id'] === 'product_payment_methods') {
		$payment_icons_size = noorgfx_akg('payment_icons_size', $layer, 40);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => $selectors_map[$layer['id']],
			'variableName' => 'theme-icon-size',
			'value' => $payment_icons_size,
			'unit' => 'px'
		]);
	}

	if ($layer['id'] === 'product_add_to_cart') {
		$add_to_cart_button_width = noorgfx_akg(
			'add_to_cart_button_width',
			$layer,
			noorgfx_get_theme_mod('add_to_cart_button_width', '100%')
		);

		if ($add_to_cart_button_width !== '100%') {
			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => $selectors_map[$layer['id']] . ' > .cart',
				'variableName' => 'theme-button-max-width',
				'unit' => '',
				'value' => $add_to_cart_button_width,
			]);
		}

		$add_to_cart_button_height = noorgfx_akg(
			'add_to_cart_button_height',
			$layer,
			noorgfx_get_theme_mod('add_to_cart_button_height', [
				'mobile' => 40,
				'tablet' => 55,
				'desktop' => 55,
			])
		);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => $selectors_map[$layer['id']] . ' > .cart',
			'variableName' => 'theme-button-min-height',
			'unit' => 'px',
			'value' => $add_to_cart_button_height,
		]);
	}

	if ($layer['id'] === 'product_brands') {
		$brand_logo_size = noorgfx_akg('brand_logo_size', $layer, 60);

		if ($brand_logo_size !== 60) {
			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => $selectors_map[$layer['id']],
				'variableName' => 'product-brand-logo-size',
				'value' => $brand_logo_size,
			]);
		}

		$brand_logo_gap = noorgfx_akg('brand_logo_gap', $layer, 10);

		if ($brand_logo_gap !== 10) {
			noorgfx_output_responsive([
				'css' => $css,
				'tablet_css' => $tablet_css,
				'mobile_css' => $mobile_css,
				'selector' => $selectors_map[$layer['id']],
				'variableName' => 'product-brands-gap',
				'value' => $brand_logo_gap,
			]);
		}
	}

	if ($layer['id'] === 'divider') {
		$id = isset($layer["__id"]) ? $layer["__id"] : 'default';

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => '.entry-summary-items > .ct-product-divider[data-id="' . $id . '"]',
			'variableName' => 'product-element-spacing',
			'value' => $spacing,
		]);
	}

	if ($layer['id'] === 'content-block') {
		$id = isset($layer["__id"]) ? $layer["__id"] : 'default';

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => '.entry-summary-items > .ct-product-content-block[data-id="' . $id . '"]',
			'variableName' => 'product-element-spacing',
			'value' => $spacing,
			'unit' => 'px'
		]);
	}

	if (in_array(
		$layer['id'],
		[
			'acf_field',
			'metabox_field',
			'toolset_field',
			'jetengine_field',
			'custom_field',
			'pods_field',
		]
	)) {
		$id = substr(isset($layer["__id"]) ? $layer["__id"] : 'default', 0, 6);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => '.entry-summary-items > .ct-dynamic-data-layer[data-field*=":' . $id . '"]',
			'variableName' => 'product-element-spacing',
			'value' => $spacing,
			'unit' => 'px'
		]);
	
	}
}


// breadcrumbs
noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod(
		'singleProductBreadcrumbsFont',
		noorgfx_typography_default_values([])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.entry-summary .ct-breadcrumbs'
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('singleProductBreadcrumbsFontColor'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'initial' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .ct-breadcrumbs',
			'variable' => 'theme-text-color'
		],

		'initial' => [
			'selector' => '.entry-summary .ct-breadcrumbs',
			'variable' => 'theme-link-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .ct-breadcrumbs',
			'variable' => 'theme-link-hover-color'
		],
	],
]);


// product title
noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod(
		'singleProductTitleFont',
		noorgfx_typography_default_values([
			'size' => '30px',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.entry-summary .entry-title'
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('singleProductTitleColor'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .entry-title',
			'variable' => 'theme-heading-color'
		],
	],
]);


// product price
noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod(
		'singleProductPriceFont',
		noorgfx_typography_default_values([
			'size' => '20px',
			'variation' => 'n7',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.entry-summary .price'
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('singleProductPriceColor'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .price',
			'variable' => 'theme-text-color'
		],
	],
]);


// quantity input
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('quantity_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .quantity',
			'variable' => 'quantity-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .quantity',
			'variable' => 'quantity-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('quantity_arrows'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'default_type_2' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .quantity[data-type="type-1"]',
			'variable' => 'quantity-arrows-initial-color'
		],

		'default_type_2' => [
			'selector' => '.entry-summary .quantity[data-type="type-2"]',
			'variable' => 'quantity-arrows-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .quantity',
			'variable' => 'quantity-arrows-hover-color'
		],
	],
]);


// add to cart & view cart buttons
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('add_to_cart_text'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .single_add_to_cart_button',
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .single_add_to_cart_button',
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('add_to_cart_background'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .single_add_to_cart_button',
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .single_add_to_cart_button',
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('view_cart_button_text'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .ct-cart-actions .added_to_cart',
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .ct-cart-actions .added_to_cart',
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('view_cart_button_background'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .ct-cart-actions .added_to_cart',
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => '.entry-summary .ct-cart-actions .added_to_cart',
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);


// divider
noorgfx_output_border([
	'css' => $css,
	'selector' => '.entry-summary .ct-product-divider',
	'variableName' => 'single-product-layer-divider',
	'value' => noorgfx_get_theme_mod('woo_single_layers_divider'),
	'default' => [
		'width' => 1,
		'style' => 'solid',
		'color' => [
			'color' => 'var(--theme-border-color)',
		],
	],
]);


// payment methods
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('payment_method_icons_color'),
	'default' => [
		'default' => [ 'color' => '#4B4F58' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.entry-summary .ct-payment-methods[data-color="custom"]',
			'variable' => 'theme-icon-color'
		],
	],
]);


if (
	$product_view_type === 'top-gallery'
	||
	$product_view_type === 'columns-top-gallery'
) {

	noorgfx_output_border([
		'css' => $css,
		'selector' => '.product[class*=top-gallery] .entry-summary',
		'variableName' => 'container-border',
		'value' => noorgfx_get_theme_mod('entry_summary_container_border'),
		'default' => [
			'width' => 1,
			'style' => 'solid',
			'color' => [
				'color' => 'var(--theme-border-color)',
			],
		],
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.product[class*=top-gallery] .entry-summary',
		'property' => 'container-border-radius',
		'value' => noorgfx_get_theme_mod('entry_summary_container_border_radius',
			noorgfx_spacing_value()
		)
	]);
}