<?php

// quantity input colors
$has_custom_quantity = noorgfx_get_theme_mod('has_custom_quantity', 'yes');

if ($has_custom_quantity === 'yes') {
	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod('global_quantity_color'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => '.quantity',
				'variable' => 'quantity-initial-color'
			],

			'hover' => [
				'selector' => '.quantity',
				'variable' => 'quantity-hover-color'
			],
		],
	]);

	noorgfx_output_colors([
		'value' => noorgfx_get_theme_mod('global_quantity_arrows'),
		'default' => [
			'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			'default_type_2' => [ 'color' => 'var(--theme-text-color)' ],
			'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		],
		'css' => $css,
		'variables' => [
			'default' => [
				'selector' => '.quantity[data-type="type-1"]',
				'variable' => 'quantity-arrows-initial-color'
			],

			'default_type_2' => [
				'selector' => '.quantity[data-type="type-2"]',
				'variable' => 'quantity-arrows-initial-color'
			],

			'hover' => [
				'selector' => '.quantity',
				'variable' => 'quantity-arrows-hover-color'
			],
		],
	]);
}


// sale badge
noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod('product_badge_font',
		noorgfx_typography_default_values([
			'size' => '12px',
			'variation' => 'n6',
			'line-height' => '1.1'
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.onsale, .out-of-stock-badge, [class*="ct-woo-badge-"]'
]);
	
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('saleBadgeColor'),
	'default' => [
		'text' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'background' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'text' => [
			'selector' => ':root',
			'variable' => 'badge-text-color'
		],

		'background' => [
			'selector' => ':root',
			'variable' => 'badge-background-color'
		],
	],
]);


// out of stock badge
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('outOfStockBadgeColor'),
	'default' => [
		'text' => [ 'color' => '#ffffff' ],
		'background' => [ 'color' => '#24292E' ],
	],
	'css' => $css,
	'variables' => [
		'text' => [
			'selector' => '.out-of-stock-badge',
			'variable' => 'badge-text-color'
		],

		'background' => [
			'selector' => '.out-of-stock-badge',
			'variable' => 'badge-background-color'
		],
	],
]);


// store notice
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('wooNoticeContent'),
	'default' => [
		'default' => ['color' => '#ffffff']
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.demo_store',
			'variable' => 'theme-text-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('wooNoticeBackground'),
	'default' => [
		'default' => ['color' => 'var(--theme-palette-color-1)']
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.demo_store',
			'variable' => 'background-color'
		],
	],
]);


// info message
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('info_message_text_color'),
	'default' => [
		'default' => ['color' => 'var(--theme-text-color)'],
		'hover' => ['color' => 'var(--theme-link-hover-color)'],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-info, .woocommerce-thankyou-order-received, .wc-block-components-notice-banner.is-info',
			'variable' => 'theme-text-color'
		],

		'hover' => [
			'selector' => '.woocommerce-info, .woocommerce-thankyou-order-received, .wc-block-components-notice-banner.is-info',
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('info_message_background_color'),
	'default' => [
		'default' => ['color' => '#F0F1F3'],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-info, .woocommerce-thankyou-order-received, .wc-block-components-notice-banner.is-info',
			'variable' => 'background-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('info_message_button_text_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-info, .wc-block-components-notice-banner.is-info',
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => '.woocommerce-info, .wc-block-components-notice-banner.is-info',
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('info_message_button_background'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-info, .wc-block-components-notice-banner.is-info',
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => '.woocommerce-info, .wc-block-components-notice-banner.is-info',
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);


// success message
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('success_message_text_color'),
	'default' => [
		'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')],
		'hover' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'theme-text-color'
		],

		'hover' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('success_message_background_color'),
	'default' => [
		'default' => ['color' => '#F0F1F3'],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'background-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('success_message_button_text_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('success_message_button_background'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => '.woocommerce-message, .wc-block-components-notice-banner.is-success',
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);


// error message
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('error_message_text_color'),
	'default' => [
		'default' => ['color' => '#ffffff'],
		'hover' => ['color' => '#ffffff'],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'theme-text-color'
		],

		'hover' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('error_message_background_color'),
	'default' => [
		'default' => ['color' => 'rgba(218, 0, 28, 0.7)'],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'background-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('error_message_button_text_color'),
	'default' => [
		'default' => [ 'color' => '#ffffff' ],
		'hover' => [ 'color' => '#ffffff' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('error_message_button_background'),
	'default' => [
		'default' => [ 'color' => '#b92c3e' ],
		'hover' => [ 'color' => '#9c2131' ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => '.woocommerce-error, .wc-block-components-notice-banner.is-error',
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);


// account page
noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('account_nav_text_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-acount-nav',
			'variable' => 'account-nav-text-initial-color'
		],

		'active' => [
			'selector' => '.ct-acount-nav',
			'variable' => 'account-nav-text-active-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('account_nav_background_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
		'active' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-acount-nav',
			'variable' => 'account-nav-background-initial-color'
		],

		'active' => [
			'selector' => '.ct-acount-nav',
			'variable' => 'account-nav-background-active-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('account_nav_divider_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword() ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.ct-acount-nav',
			'variable' => 'account-nav-divider-color'
		],
	],
]);

noorgfx_output_box_shadow([
	'css' => $css,
	'selector' => '.ct-acount-nav',
	'value' => noorgfx_get_theme_mod('account_nav_shadow', noorgfx_box_shadow_value([
		'enable' => false,
		'h_offset' => 0,
		'v_offset' => 10,
		'blur' => 20,
		'spread' => 0,
		'inset' => false,
		'color' => [
			'color' => 'rgba(0, 0, 0, 0.03)',
		],
	])),
]);


// cart page
noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-woocommerce-cart-form .cart_totals',
	'variableName' => 'cart-totals-border',
	'value' => noorgfx_get_theme_mod('cart_totals_border'),
	'default' => [
		'width' => 2,
		'style' => 'solid',
		'color' => [
			'color' => 'var(--theme-border-color)',
		],
	],
	'responsive' => true,
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-woocommerce-cart-form .cart_totals',
	'property' => 'cart-totals-border-radius',
	'value' => noorgfx_get_theme_mod( 'cart_totals_border_radius',
		noorgfx_spacing_value()
	)
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-woocommerce-cart-form .cart_totals',
	'property' => 'cart-totals-padding',
	'value' => noorgfx_get_theme_mod(
		'cart_totals_padding',
		[
			'desktop' => noorgfx_spacing_value([
				'top' => '30px',
				'left' => '30px',
				'right' => '30px',
				'bottom' => '30px',
			]),
			'tablet' => noorgfx_spacing_value([
				'top' => '25px',
				'left' => '25px',
				'right' => '25px',
				'bottom' => '25px',
			]),
			'mobile'=> noorgfx_spacing_value([
				'top' => '25px',
				'left' => '25px',
				'right' => '25px',
				'bottom' => '25px',
			]),
		]
	)
]);


// checkout page
noorgfx_output_border([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-order-review',
	'variableName' => 'order-review-border',
	'value' => noorgfx_get_theme_mod('checkout_order_border'),
	'default' => [
		'width' => 2,
		'style' => 'solid',
		'color' => [
			'color' => 'var(--theme-border-color)',
		],
	],
	'responsive' => true,
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-order-review',
	'property' => 'order-review-border-radius',
	'value' => noorgfx_get_theme_mod( 'checkout_order_border_radius',
		noorgfx_spacing_value()
	)
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-order-review',
	'property' => 'order-review-padding',
	'value' => noorgfx_get_theme_mod(
		'checkout_order_padding',
		[
			'desktop' => noorgfx_spacing_value([
				'top' => '35px',
				'left' => '35px',
				'right' => '35px',
				'bottom' => '35px',
			]),
			'tablet' => noorgfx_spacing_value([
				'top' => '30px',
				'left' => '30px',
				'right' => '30px',
				'bottom' => '30px',
			]),
			'mobile'=> noorgfx_spacing_value([
				'top' => '25px',
				'left' => '25px',
				'right' => '25px',
				'bottom' => '25px',
			]),
		]
	)
]);

noorgfx_output_spacing([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.ct-checkout-cart-item',
	'property' => 'theme-border-radius',
	'value' => noorgfx_get_theme_mod( 'checkout_product_image_border_radius',
		noorgfx_spacing_value()
	),
	'empty_value' => 3,
]);


// woo listing top
noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod( 'shop_results_count_font',
		noorgfx_typography_default_values([
			'size' => '11px',
			'variation' => 'n5',
			'letter-spacing' => '0.05em',
			'text-transform' => 'uppercase',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => '.woo-listing-top .woocommerce-result-count',
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod('shop_results_count_color'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => '.woo-listing-top .woocommerce-result-count',
			'variable' => 'theme-text-color'
		],
	],
]);