<?php

$structure = noorgfx_get_theme_mod($prefix . '_structure', 'grid');

if ($structure === 'grid') {
	$grid_columns = noorgfx_expand_responsive_value(noorgfx_get_theme_mod(
		$prefix . '_columns',
		[
			'desktop' => 3,
			'tablet' => 2,
			'mobile' => 1
		]
	));

	$columns_for_output = [
		'desktop' => 'repeat(' . $grid_columns['desktop'] . ', minmax(0, 1fr))',
		'tablet' => 'repeat(' . $grid_columns['tablet'] . ', minmax(0, 1fr))',
		'mobile' => 'repeat(' . $grid_columns['mobile'] . ', minmax(0, 1fr))'
	];

	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entries', $prefix),
		'variableName' => 'grid-template-columns',
		'value' => $columns_for_output,
		'unit' => ''
	]);
}

$card_type = noorgfx_get_listing_card_type([
	'prefix' => $prefix
]);

noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod(
		$prefix . '_cardTitleFont',
		noorgfx_typography_default_values([
			'size' => [
				'desktop' => '20px',
				'tablet'  => '20px',
				'mobile'  => '18px'
			],
			'line-height' => '1.3'
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('.entry-card .entry-title', $prefix)
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_cardTitleColor'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.entry-card .entry-title', $prefix),
			'variable' => 'theme-heading-color'
		],
		'hover' => [
			'selector' => noorgfx_prefix_selector('.entry-card .entry-title', $prefix),
			'variable' => 'theme-link-hover-color'
		],
	],
]);

noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod(
		$prefix . '_cardExcerptFont',
		noorgfx_typography_default_values([])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('.entry-excerpt', $prefix)
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_cardExcerptColor'),
	'default' => [
		'default' => ['color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT')]
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.entry-excerpt', $prefix),
			'variable' => 'theme-text-color'
		]
	],
]);

noorgfx_output_font_css([
	'font_value' => noorgfx_get_theme_mod(
		$prefix . '_cardMetaFont',
		noorgfx_typography_default_values([
			'size' => [
				'desktop' => '12px',
				'tablet'  => '12px',
				'mobile'  => '12px'
			],
			'variation' => 'n6',
			'text-transform' => 'uppercase',
		])
	),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('.entry-card .entry-meta', $prefix)
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_cardMetaColor'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.entry-card .entry-meta', $prefix),
			'variable' => 'theme-text-color'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector('.entry-card .entry-meta', $prefix),
			'variable' => 'theme-link-hover-color'
		],
	],
]);


noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_card_meta_button_type_font_colors'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.entry-card [data-type="pill"]', $prefix),
			'variable' => 'theme-button-text-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector('.entry-card [data-type="pill"]', $prefix),
			'variable' => 'theme-button-text-hover-color'
		],
	],
]);

noorgfx_output_colors([
	'value' => noorgfx_get_theme_mod($prefix . '_card_meta_button_type_background_colors'),
	'default' => [
		'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
		'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
	],
	'css' => $css,
	'variables' => [
		'default' => [
			'selector' => noorgfx_prefix_selector('.entry-card [data-type="pill"]', $prefix),
			'variable' => 'theme-button-background-initial-color'
		],

		'hover' => [
			'selector' => noorgfx_prefix_selector('.entry-card [data-type="pill"]', $prefix),
			'variable' => 'theme-button-background-hover-color'
		],
	],
]);



// simple card
if ($structure === 'simple' && $card_type === 'simple' ) {
	noorgfx_output_border([
		'css' => $css,
		'selector' => noorgfx_prefix_selector('[data-cards="simple"] .entry-card', $prefix),
		'variableName' => 'card-border',
		'value' => noorgfx_get_theme_mod($prefix . '_cardDivider'),
		'default' => [
			'width' => 1,
			'style' => 'dashed',
			'color' => [
				'color' => 'rgba(224, 229, 235, 0.8)',
			],
		],
	]);
}

// boxed card
if ($card_type === 'boxed' || $card_type === 'cover') {
	$card_spacing = noorgfx_get_theme_mod($prefix . '_card_spacing', '30px');
	$card_spacing_expanded = noorgfx_expand_responsive_value($card_spacing);

	if ($card_spacing !== '30px') {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
			'variableName' => 'card-inner-spacing',
			'value' => $card_spacing,
			'unit' => '',
			'previousUnit' => 'px'
		]);
	}

	noorgfx_output_background_css([
		'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => noorgfx_get_theme_mod(
			$prefix . '_cardBackground',
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'var(--theme-palette-color-8)'
					],
				],
			])
		),
		'responsive' => true,
	]);

	$cardBorder = noorgfx_expand_responsive_value(
		noorgfx_get_theme_mod($prefix . '_cardBorder')
	);

	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
		'variableName' => 'card-border',
		'value' => $cardBorder,
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(44,62,80,0.2)',
			],
		],
		'responsive' => true,
		'skip_none' => true
	]);

	// Border radius
	$cardRadius = noorgfx_expand_responsive_value(noorgfx_get_theme_mod(
		$prefix . '_cardRadius',
		noorgfx_spacing_value()
	));

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
		'property' => 'theme-border-radius',
		'value' => $cardRadius
	]);

	$archive_order = apply_filters(
		'noorgfx:posts-listing:archive-order',
		noorgfx_get_theme_mod(
			$prefix . '_archive_order',
			[]
		)
	);

	$featured_image_settings = null;

	foreach (array_reverse($archive_order) as $index => $value) {
		if ($value['id'] === 'featured_image') {
			$featured_image_settings = $value;
		}
	}

	$devices = ['desktop', 'tablet', 'mobile'];
	$should_apply = false;
	$is_boundles = noorgfx_default_akg(
		'is_boundless',
		$featured_image_settings,
		'yes'
	);

	$image_border_radius = [];

	foreach ($devices as $device) {
		$image_border_radius[$device] = noorgfx_spacing_prepare_for_device(
			$cardRadius[$device],
			[
				'format' => 'array'
			]
		);

		$maybeWidth = 0;

		if (
			$cardBorder[$device]
			&&
			$cardBorder[$device]['style'] !== 'none'
			&&
			$cardBorder[$device]['width'] > 0
		) {
			$maybeWidth = $cardBorder[$device]['width'] . 'px';
		}

		if ($card_type === 'boxed' && $is_boundles !== 'yes') {
			$maybeWidth = $card_spacing_expanded[$device];
		}

		if ($maybeWidth !== 0) {
			$result = [];

			if (is_array($image_border_radius[$device])) {
				foreach ($image_border_radius[$device] as $value) {
					$result[] = 'calc(' . $value . ' - ' . $maybeWidth . ')';
				}
			}

			$image_border_radius[$device] = $result;
			$should_apply = true;
		}

		if ($image_border_radius[$device] === 'CT_CSS_SKIP_RULE') {
			$image_border_radius[$device] = 'CT_CSS_SKIP_RULE';
		} else {
			$image_border_radius[$device] = implode(
				' ',
				$image_border_radius[$device]
			);
		}

	}

	if ($should_apply) {
		noorgfx_output_css_vars([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
			'variableName' => 'theme-image-border-radius',
			'value' => $image_border_radius,
			'responsive' => true
		]);
	}

	// Box shadow
	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
		'value' => noorgfx_get_theme_mod($prefix . '_cardShadow', noorgfx_box_shadow_value([
			'enable' => true,
			'h_offset' => 0,
			'v_offset' => 12,
			'blur' => 18,
			'spread' => -6,
			'inset' => false,
			'color' => [
				'color' => 'rgba(34, 56, 101, 0.04)',
			],
		])),
		'responsive' => true
	]);
}

// cover card
if ($card_type === 'cover') {
	$card_min_height = noorgfx_get_theme_mod($prefix. '_card_min_height', 400);

	if ($card_min_height !== 400) {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('.entries', $prefix),
			'variableName' => 'card-min-height',
			'value' => $card_min_height
		]);
	}

	noorgfx_output_background_css([
		'selector' => noorgfx_prefix_selector('.entry-card .ct-media-container:after', $prefix),
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => noorgfx_get_theme_mod(
			$prefix . '_card_overlay_background',
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'rgba(0,0,0,0.5)'
					],
				],
			])
		),
		'responsive' => true,
	]);
}

foreach (noorgfx_get_theme_mod($prefix . '_archive_order', []) as $layer) {
	if (! $layer['enabled']) {
		continue;
	}

	// featured image
	if ($layer['id'] === 'featured_image') {
		if ($structure === 'simple') {
			$image_width = noorgfx_akg('image_width', $layer, 40);

			if ($image_width !== 40) {
				$css->put(
					noorgfx_prefix_selector('.entry-card', $prefix),
					'--card-media-max-width: ' . $image_width . '%'
				);
			}
		}
	}

	// divider
	if ($layer['id'] === 'divider') {
		noorgfx_output_border([
			'css' => $css,
			'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
			'variableName' => 'entry-divider',
			'value' => noorgfx_get_theme_mod($prefix . '_entryDivider'),
			'default' => [
				'width' => 1,
				'style' => 'solid',
				'color' => [
					'color' => 'rgba(224, 229, 235, 0.8)',
				],
			]
		]);
	}

	// entry button
	if ($layer['id'] === 'read_more') {

		$button_type = noorgfx_akg('button_type', $layer, 'background');

		if ($button_type === 'simple') {
			noorgfx_output_colors([
				'value' => noorgfx_get_theme_mod($prefix . '_cardButtonSimpleTextColor'),
				'default' => [
					'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
					'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				],
				'css' => $css,
				'variables' => [
					'default' => [
						'selector' => noorgfx_prefix_selector('.entry-button', $prefix),
						'variable' => 'theme-link-initial-color'
					],

					'hover' => [
						'selector' => noorgfx_prefix_selector('.entry-button', $prefix),
						'variable' => 'theme-link-hover-color'
					],
				],
			]);
		}

		if ($button_type === 'background') {
			noorgfx_output_colors([
				'value' => noorgfx_get_theme_mod($prefix . '_cardButtonBackgroundTextColor'),
				'default' => [
					'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
					'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				],
				'css' => $css,
				'variables' => [
					'default' => [
						'selector' => noorgfx_prefix_selector('.entry-button.ct-button', $prefix),
						'variable' => 'theme-button-text-initial-color'
					],

					'hover' => [
						'selector' => noorgfx_prefix_selector('.entry-button.ct-button', $prefix),
						'variable' => 'theme-button-text-hover-color'
					],
				],
			]);
		}

		if ($button_type === 'outline') {
			noorgfx_output_colors([
				'value' => noorgfx_get_theme_mod($prefix . '_cardButtonOutlineTextColor'),
				'default' => [
					'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
					'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				],
				'css' => $css,
				'variables' => [
					'default' => [
						'selector' => noorgfx_prefix_selector('.entry-button.ct-button-ghost', $prefix),
						'variable' => 'theme-button-text-initial-color'
					],

					'hover' => [
						'selector' => noorgfx_prefix_selector('.entry-button.ct-button-ghost', $prefix),
						'variable' => 'theme-button-text-hover-color'
					],
				],
			]);
		}

		if ($button_type !== 'simple') {
			noorgfx_output_colors([
				'value' => noorgfx_get_theme_mod($prefix . '_cardButtonColor'),
				'default' => [
					'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
					'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				],
				'css' => $css,
				'variables' => [
					'default' => [
						'selector' => noorgfx_prefix_selector('.entry-button', $prefix),
						'variable' => 'theme-button-background-initial-color'
					],

					'hover' => [
						'selector' => noorgfx_prefix_selector('.entry-button', $prefix),
						'variable' => 'theme-button-background-hover-color'
					],
				],
			]);
		}
	}

	if (isset($layer['typography'])) {
		noorgfx_output_font_css([
			'font_value' => noorgfx_akg(
				'typography',
				$layer,
				noorgfx_typography_default_values([])
			),
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector('[data-field*="' . substr(
				$layer['__id'],
				0, 6
			) . '"]', $prefix)
		]);
	}

	if (isset($layer['color'])) {
		noorgfx_output_colors([
			'value' => noorgfx_akg('color', $layer),
			'default' => [
				'default' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
				'hover' => [ 'color' => Noorgfx_Css_Injector::get_skip_rule_keyword('DEFAULT') ],
			],
			'css' => $css,
			'variables' => [
				'default' => [
					'selector' => noorgfx_prefix_selector('[data-field*="' . substr(
						$layer['__id'],
						0, 6
					) . '"]', $prefix),
					'variable' => 'theme-text-color'
				],

				'hover' => [
					'selector' => noorgfx_prefix_selector('[data-field*="' . substr(
						$layer['__id'],
						0, 6
					) . '"]', $prefix),
					'variable' => 'theme-link-hover-color'
				],
			],
		]);
	}


	// bottom spacing
	$selectors_map = [
		'title' => '[data-archive="default"] .card-content .entry-title',
		'featured_image' => '[data-archive="default"] .card-content .ct-media-container',
		'excerpt' => '[data-archive="default"] .card-content .entry-excerpt',
		'read_more' => '[data-archive="default"] .card-content :is(.entry-button, .entry-button-container)',
		'overall_score' => '[data-archive="default"] .card-content .ct-overall-score-layer',
	];

	$spacing_default = 20;

	if ($layer['id'] === 'post_meta') {
		$spacing_default = 15;
	}

	if ($layer['id'] === 'featured_image') {
		$spacing_default = 30;
	}

	$spacing = noorgfx_akg('spacing', $layer, $spacing_default);

	if (
		isset($selectors_map[$layer['id']])
		&&
		(
			intval($spacing) !== $spacing_default
			||
			$spacing_default === 30
		)
	) {
		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector(
				$selectors_map[$layer['id']],
				$prefix
			),
			'variableName' => 'card-element-spacing',
			'value' => $spacing
		]);
	}

	if ($layer['id'] === 'divider') {
		$id = substr(isset($layer["__id"]) ? $layer["__id"] : 'default', 0, 6);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector(
				'[data-archive="default"] .card-content .entry-divider[data-id="' . $id . '"]',
				$prefix
			),
			'variableName' => 'card-element-spacing',
			'value' => $spacing,
			'unit' => 'px'
		]);
	}

	if ($layer['id'] === 'post_meta') {
		$id = substr(isset($layer["__id"]) ? $layer["__id"] : 'default', 0, 6);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector(
				'[data-archive="default"] .card-content .entry-meta[data-id="' . $id . '"]',
				$prefix
			),
			'variableName' => 'card-element-spacing',
			'value' => $spacing,
			'unit' => 'px'
		]);
	}

	if ($layer['id'] === 'content-block') {
		$id = isset($layer["__id"]) ? $layer["__id"] : 'default';

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector(
				'[data-archive="default"] .card-content .ct-entry-content-block[data-id="' . $id . '"]',
				$prefix
			),
			'variableName' => 'card-element-spacing',
			'value' => $spacing,
			'unit' => 'px'
		]);
	}

	if (in_array(
		$layer['id'],
		[
			'acf_field',
			'metabox_field',
			'toolset_field',
			'jetengine_field',
			'custom_field',
			'pods_field',
		]
	)) {
		$id = substr(isset($layer["__id"]) ? $layer["__id"] : 'default', 0, 6);

		noorgfx_output_responsive([
			'css' => $css,
			'tablet_css' => $tablet_css,
			'mobile_css' => $mobile_css,
			'selector' => noorgfx_prefix_selector(
				'[data-archive="default"] .card-content .ct-dynamic-data-layer[data-field*=":' . $id . '"]',
				$prefix
			),
			'variableName' => 'card-element-spacing',
			'value' => $spacing,
			'unit' => 'px'
		]);
	}
}

$cards_gap = noorgfx_get_theme_mod($prefix. '_cardsGap', '30px');

if ($cards_gap !== '30px') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entries', $prefix),
		'variableName' => 'grid-columns-gap',
		'value' => $cards_gap,
		'unit' => '',
		'previousUnit' => 'px'
	]);
}


// content alignment
$horizontal_alignment = noorgfx_get_theme_mod(
	$prefix. '_content_horizontal_alignment',
	'CT_CSS_SKIP_RULE'
);

$flex_horizontal_alignment = $horizontal_alignment;

$flex_horizontal_alignment = noorgfx_map_values([
	'value' => $horizontal_alignment,
	'map' => [
		'start' => 'flex-start',
		'end' => 'flex-end'
	]
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
	'variableName' => 'text-horizontal-alignment',
	'value' => $horizontal_alignment,
	'unit' => '',
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
	'variableName' => 'horizontal-alignment',
	'value' => $flex_horizontal_alignment,
	'unit' => '',
]);


if ($card_type === 'cover') {
	noorgfx_output_responsive([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-card', $prefix),
		'variableName' => 'vertical-alignment',
		'value' => noorgfx_get_theme_mod($prefix. '_content_vertical_alignment', 'CT_CSS_SKIP_RULE'),
		'unit' => '',
	]);
}

// Featured Image Radius
if ($card_type === 'simple' || $structure === 'gutenberg') {
	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-card .ct-media-container', $prefix),
		'property' => 'theme-border-radius',
		'value' => noorgfx_get_theme_mod(
			$prefix . '_cardThumbRadius',
			noorgfx_spacing_value()
		)
	]);

	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => noorgfx_prefix_selector('.entry-card .ct-media-container', $prefix),
		'value' => noorgfx_get_theme_mod($prefix . '_cardThumbShadow', noorgfx_box_shadow_value([
			'enable' => false,
			'h_offset' => 0,
			'v_offset' => 12,
			'blur' => 18,
			'spread' => -6,
			'inset' => false,
			'color' => [
				'color' => 'rgba(34, 56, 101, 0.04)',
			],
		])),
		'variableName' => 'theme-image-shadow',
		'responsive' => true
	]);
}

noorgfx_output_background_css([
	'selector' => 'body' . noorgfx_prefix_selector('', $prefix),
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'value' => noorgfx_get_theme_mod(
		$prefix . '_background',
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
				],
			],
		])
	),
	'responsive' => true,
]);
