<?php

$post_type = get_current_screen()->post_type;

$post_id = null;

if (isset($_GET['post']) && $_GET['post']) {
	$post_id = $_GET['post'];
}

$prefix = noorgfx_manager()->screen->get_admin_prefix($post_type);

$post_atts = noorgfx_get_post_options($post_id);

$background_source = noorgfx_default_akg(
	'background',
	$post_atts,
	noorgfx_background_default_value([
		'backgroundColor' => [
			'default' => [
				'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
			],
		],
	])
);

if ($post_type === 'ct_content_block') {
	$template_type = get_post_meta($post_id, 'template_type', true);
	$template_subtype = noorgfx_akg('template_subtype', $post_atts, 'card');

	if ($template_type === 'popup') {
		$background_source = noorgfx_default_akg(
			'popup_background',
			$post_atts,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => '#ffffff'
					],
				],
			])
		);
	}

	if ($template_type !== 'popup') {
		$default_content_block_structure = 'yes';

		if ($template_type === 'hook') {
			$default_content_block_structure = 'no';
		}

		$has_content_block_structure = noorgfx_akg(
			'has_content_block_structure',
			$post_atts,
			$default_content_block_structure
		);

		if (
			$has_content_block_structure !== 'yes'
			||
			$template_type === 'archive' && $template_subtype === 'card'
		) {
			$background_source = noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
					],
				],
			]);
		}
	}
}

$maybe_matching_template = null;
$content_block_atts = null;
$strategy = [
	'strategy' => 'customizer',
	'prefix' => $prefix
];

if (function_exists('blc_get_content_block_that_matches')) {
	$maybe_matching_template = blc_get_content_block_that_matches([
		'template_type' => 'single',
		'template_subtype' => 'canvas',
		'match_conditions_strategy' => $prefix
	]);

	if ($maybe_matching_template) {
		$content_block_atts = noorgfx_get_post_options($maybe_matching_template);

		$strategy = [
			'strategy' => $content_block_atts
		];
	}
}

if (
	isset($background_source['background_type'])
	&&
	$background_source['background_type'] === 'color'
	&&
	isset($background_source['backgroundColor']['default']['color'])
	&&
	$background_source['backgroundColor']['default']['color'] === Noorgfx_Css_Injector::get_skip_rule_keyword()
) {
	$background_source = noorgfx_akg_or_customizer(
		'background',
		$strategy,
		noorgfx_background_default_value([
			'backgroundColor' => [
				'default' => [
					'color' => Noorgfx_Css_Injector::get_skip_rule_keyword()
				],
			],
		])
	);

	if (
		isset($background_source['background_type'])
		&&
		$background_source['background_type'] === 'color'
		&&
		isset($background_source['backgroundColor']['default']['color'])
		&&
		$background_source['backgroundColor']['default']['color'] === Noorgfx_Css_Injector::get_skip_rule_keyword()
	) {
		$background_source = noorgfx_get_theme_mod(
			'site_background',
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'var(--theme-palette-color-7)'
					],
				],
			])
		);
	}
}

$background_source = noorgfx_expand_responsive_value($background_source);

global $wp_version;

$is_65_wordpress = version_compare($wp_version, '6.5', '>=');

$background_selectors = [
	'desktop' => '.ct-desktop-view iframe[name="editor-canvas"], .ct-desktop-view .edit-post-visual-editor',
	'tablet' => '.ct-tablet-view iframe[name="editor-canvas"]',
	'mobile' => '.ct-mobile-view iframe[name="editor-canvas"]'
];

// We don't support boxed styles for 6.4 and less. For that version of WP
// we will only support the main page background.
if (! $is_65_wordpress) {
	$background_selectors = [
		'desktop' => '.ct-desktop-view iframe[name="editor-canvas"], .ct-desktop-view .edit-post-visual-editor__content-area > div',
		'tablet' => '.ct-tablet-view iframe[name="editor-canvas"]',
		'mobile' => '.ct-mobile-view iframe[name="editor-canvas"]'
	];
}

noorgfx_output_background_css([
	'selector' => $background_selectors['desktop'],
	'css' => $css,
	'value' => $background_source['desktop'],
	'responsive' => false,
	'important' => true
]);

noorgfx_output_background_css([
	'selector' => $background_selectors['tablet'],
	'css' => $css,
	'value' => $background_source['tablet'],
	'responsive' => false,
	'important' => true
]);

noorgfx_output_background_css([
	'selector' => $background_selectors['mobile'],
	'css' => $css,
	'value' => $background_source['mobile'],
	'responsive' => false,
	'important' => true
]);

