<?php

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => ".editor-styles-wrapper",
	'variableName' => 'has-boxed',
	'value' => noorgfx_map_values([
		'value' => $has_boxed,
		'map' => [
			'boxed' => 'var(--true)',
			'wide' => 'var(--false)'
		]
	]),
	'unit' => ''
]);

noorgfx_output_responsive([
	'css' => $css,
	'tablet_css' => $tablet_css,
	'mobile_css' => $mobile_css,
	'selector' => ".editor-styles-wrapper",
	'variableName' => 'has-wide',
	'value' => noorgfx_map_values([
		'value' => $has_boxed,
		'map' => [
			'wide' => 'var(--true)',
			'boxed' => 'var(--false)'
		]
	]),
	'unit' => ''
]);

// boxed content area styles
if (noorgfx_some_device($has_boxed, 'boxed')) {
	noorgfx_output_background_css([
		'selector' => '.editor-styles-wrapper',
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'value' => noorgfx_akg_or_customizer(
			'content_background',
			$source,
			noorgfx_background_default_value([
				'backgroundColor' => [
					'default' => [
						'color' => 'var(--theme-palette-color-8)'
					],
				],
			])
		),
		'responsive' => true,
		'conditional_var' => '--has-boxed'
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.editor-styles-wrapper',
		'property' => 'theme-boxed-content-border-radius',
		'value' => noorgfx_akg_or_customizer(
			'content_boxed_radius',
			$source,
			noorgfx_spacing_value([
				'top' => '3px',
				'left' => '3px',
				'right' => '3px',
				'bottom' => '3px',
			])
		)
	]);

	noorgfx_output_border([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.editor-styles-wrapper',
		'variableName' => 'theme-boxed-content-border',
		'value' => noorgfx_akg_or_customizer(
			'content_boxed_border',
			$source,
			[
				'width' => 1,
				'style' => 'none',
				'color' => [
					'color' => 'rgba(44,62,80,0.2)',
				],
			]
		),
		'default' => [
			'width' => 1,
			'style' => 'none',
			'color' => [
				'color' => 'rgba(44,62,80,0.2)',
			],
		],
		'responsive' => true,
		'skip_none' => true
	]);

	noorgfx_output_spacing([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.editor-styles-wrapper',
		'property' => 'theme-boxed-content-spacing',
		'value' => noorgfx_akg_or_customizer(
			'boxed_content_spacing',
			$source,
			[
				'desktop' => noorgfx_spacing_value([
					'top' => '40px',
					'left' => '40px',
					'right' => '40px',
					'bottom' => '40px',
				]),
				'tablet' => noorgfx_spacing_value([
					'top' => '35px',
					'left' => '35px',
					'right' => '35px',
					'bottom' => '35px',
				]),
				'mobile'=> noorgfx_spacing_value([
					'top' => '20px',
					'left' => '20px',
					'right' => '20px',
					'bottom' => '20px',
				]),
			]
		)
	]);

	noorgfx_output_box_shadow([
		'css' => $css,
		'tablet_css' => $tablet_css,
		'mobile_css' => $mobile_css,
		'selector' => '.editor-styles-wrapper',
		'variableName' => 'theme-boxed-content-box-shadow',
		'value' => noorgfx_akg_or_customizer(
			'content_boxed_shadow',
			$source,
			noorgfx_box_shadow_value([
				'enable' => true,
				'h_offset' => 0,
				'v_offset' => 12,
				'blur' => 18,
				'spread' => -6,
				'inset' => false,
				'color' => [
					'color' => 'rgba(34, 56, 101, 0.04)',
				],
			])
		),
		'responsive' => true
	]);
} else {
	$css->put(
		'.editor-styles-wrapper',
		'background-color: transparent'
	);
}
